/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.one337x;

import com.frostwire.search.CrawlableSearchResult;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.one337x.One337xSearchResult;
import com.frostwire.search.one337x.One337xTempSearchResult;
import com.frostwire.search.torrent.TorrentRegexCrawlerSearchPerformer;

public final class One337xSearchPerformer
extends TorrentRegexCrawlerSearchPerformer<One337xSearchResult> {
    public static final String SEARCH_RESULTS_REGEX = "(?is)<a href=\"/torrent/(?<itemId>[0-9]*)/(?<htmlFileName>.*?)\">(?<displayName>.*?)</a>";
    public static final String TORRENT_DETAILS_PAGE_REGEX = "(?is)<div class=\"box-info-heading clearfix\">.*?<a class=\".*\" href=\"(?<magnet>.*?)\" onclick=\".*\">.*?<strong>Language</strong>.*?<span>.*?</span>.*?<strong>Total size</strong>.*?<span>(?<size>.*?)</span>.*?<strong>Date uploaded</strong>.*?<span>(?<creationDate>.*?)</span>.*?<strong>Seeders</strong>.*?<span class=\"seeds\">(?<seeds>[0-9]+)</span>";
    private static final int MAX_RESULTS = 20;
    private boolean isDDOSProtectionActive;

    public One337xSearchPerformer(String domainName, long token, String keywords, int timeout2) {
        super(domainName, token, keywords, timeout2, 1, 40, 20, SEARCH_RESULTS_REGEX, TORRENT_DETAILS_PAGE_REGEX);
    }

    @Override
    protected String getSearchUrl(int page, String encodedKeywords) {
        return "https://" + this.getDomainName() + "/search/" + encodedKeywords + "/1/";
    }

    @Override
    public CrawlableSearchResult fromMatcher(SearchMatcher matcher) {
        String itemId = matcher.group("itemId");
        String htmlFileName = matcher.group("htmlFileName");
        String displayName = matcher.group("displayName");
        return new One337xTempSearchResult(this.getDomainName(), itemId, htmlFileName, displayName);
    }

    @Override
    protected One337xSearchResult fromHtmlMatcher(CrawlableSearchResult sr, SearchMatcher matcher) {
        return new One337xSearchResult(sr.getDetailsUrl(), sr.getDisplayName(), matcher);
    }

    @Override
    protected boolean isValidHtml(String html) {
        this.isDDOSProtectionActive = html == null || html.contains("Cloudflare");
        return !this.isDDOSProtectionActive;
    }

    @Override
    public boolean isDDOSProtectionActive() {
        return this.isDDOSProtectionActive;
    }

    @Override
    public boolean isCrawler() {
        return true;
    }

    @Override
    protected int htmlPrefixOffset(String html) {
        int offset = html.indexOf("<div class=\"col-9 page-content\">");
        return Math.max(offset, 0);
    }

    @Override
    protected int htmlSuffixOffset(String html) {
        int offset = html.indexOf("<div class=\"torrent-detail-info\"");
        return offset > 0 ? offset : html.length();
    }
}

