/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.magnetdl;

import com.frostwire.regex.Pattern;
import com.frostwire.search.SearchError;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.magnetdl.MagnetDLSearchResult;
import com.frostwire.search.torrent.SimpleTorrentSearchPerformer;
import com.frostwire.util.Logger;
import java.util.ArrayList;
import java.util.List;

public class MagnetDLSearchPerformer
extends SimpleTorrentSearchPerformer {
    private static Logger LOG = Logger.getLogger(MagnetDLSearchPerformer.class);
    private static Pattern pattern;
    private final String nonEncodedKeywords;
    private int minSeeds = 1;

    public MagnetDLSearchPerformer(long token, String keywords, int timeout2) {
        super("magnetdl.com", token, keywords, timeout2, 1, 0);
        this.nonEncodedKeywords = keywords;
        if (pattern == null) {
            pattern = Pattern.compile("(?is)<td class=\"m\"><a href=\"(?<magnet>.*?)\" title=.*?<img.*?</td><td class=\"n\"><a href=\"(?<detailUrl>.*?)\" title=\"(?<title>.*?)\">.*?</td><td>(?<age>.*?)</td><td class=\"t[0-9]\">.*?</td><td>.*?</td>.*?<td>(?<fileSizeMagnitude>.*?) (?<fileSizeUnit>[A-Z]+)</td><td class=\"s\">(?<seeds>.*?)</td>");
        }
    }

    public void setMinSeeds(int minSeeds) {
        this.minSeeds = minSeeds;
    }

    @Override
    protected String getSearchUrl(int page, String encodedKeywords) {
        String transformedKeywords = this.nonEncodedKeywords.replace("%20", "-");
        return "https://" + this.getDomainName() + "/" + String.valueOf(transformedKeywords.subSequence(0, 1)) + "/" + transformedKeywords + "/";
    }

    protected List<MagnetDLSearchResult> searchPage(String page) {
        boolean matcherFound;
        String HTML_PREFIX_MARKER = "<tbody>";
        int htmlPrefixIndex = page.indexOf("<tbody>") + "<tbody>".length();
        String HTML_SUFFIX_MARKER = "Download Search Help";
        int htmlSuffixIndex = page.indexOf("Download Search Help");
        String reducedHtml = page.substring(htmlPrefixIndex, htmlSuffixIndex > 0 ? htmlSuffixIndex : page.length() - htmlPrefixIndex);
        ArrayList<MagnetDLSearchResult> results = new ArrayList<MagnetDLSearchResult>(0);
        SearchMatcher matcher = new SearchMatcher(pattern.matcher(reducedHtml));
        int MAX_RESULTS = 50;
        do {
            try {
                matcherFound = matcher.find();
            }
            catch (Throwable t) {
                matcherFound = false;
                LOG.error("searchPage() has failed.\n" + t.getMessage(), t);
            }
            if (matcherFound) {
                MagnetDLSearchResult sr = this.fromMatcher(matcher);
                if (sr.getSeeds() < this.minSeeds) continue;
                results.add(sr);
                continue;
            }
            LOG.warn("MagnetDLSearchPerformer::searchPage(String page): search matcher broken. Please notify at https://github.com/frostwire/frostwire/issues/new");
            if (this.getListener() == null || results.size() >= 5) continue;
            this.getListener().onError(this.getToken(), new SearchError(0, "Search Matcher Broken"));
        } while (matcherFound && !this.isStopped() && results.size() <= MAX_RESULTS);
        return results;
    }

    private MagnetDLSearchResult fromMatcher(SearchMatcher matcher) {
        String magnet = matcher.group("magnet");
        String detailsURL = "https://" + this.getDomainName() + matcher.group("detailUrl");
        String title = matcher.group("title");
        String ageString = matcher.group("age");
        String fileSizeMagnitude = matcher.group("fileSizeMagnitude");
        String fileSizeUnit = matcher.group("fileSizeUnit");
        String seeds = matcher.group("seeds");
        return new MagnetDLSearchResult(detailsURL, magnet, fileSizeMagnitude, fileSizeUnit, ageString, seeds, title);
    }

    @Override
    public boolean isCrawler() {
        return false;
    }
}

