/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.filter;

import com.frostwire.search.SearchResult;
import com.frostwire.search.filter.FilterKey;
import com.frostwire.search.filter.SearchFilter;
import com.frostwire.search.filter.SourceKey;
import com.frostwire.search.torrent.TorrentSearchResult;
import java.util.Comparator;
import java.util.HashMap;

public final class SourceFilter
implements SearchFilter {
    private static final Comparator<SearchResult> CMP = (o1, o2) -> {
        int x = o1 instanceof TorrentSearchResult ? ((TorrentSearchResult)o1).getSeeds() : 0;
        int y = o2 instanceof TorrentSearchResult ? ((TorrentSearchResult)o2).getSeeds() : 0;
        return Integer.compare(x, y);
    };
    private final HashMap<String, SourceKey> keys = new HashMap();

    public SourceFilter(SourceKey ... keys2) {
        for (SourceKey k : keys2) {
            this.keys.put(k.source(), k);
        }
    }

    @Override
    public FilterKey key(SearchResult sr) {
        if (this.keys.containsKey(sr.getSource())) {
            return this.keys.get(sr.getSource());
        }
        return FilterKey.NULL;
    }

    @Override
    public boolean accept(SearchResult sr) {
        return true;
    }

    @Override
    public Comparator<SearchResult> comparator() {
        return CMP;
    }
}

