/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.eztv;

import com.frostwire.search.SearchMatcher;
import com.frostwire.search.torrent.AbstractTorrentSearchResult;
import com.frostwire.util.HtmlManipulator;
import com.frostwire.util.UrlUtils;

public final class EztvSearchResult
extends AbstractTorrentSearchResult {
    private final String filename;
    private final String displayName;
    private final String detailsUrl;
    private final String torrentUrl;
    private final String infoHash;
    private final long size;
    private final long creationTime;
    private final int seeds;

    public EztvSearchResult(String domainName, SearchMatcher matcher) {
        this.detailsUrl = domainName + matcher.group("detailUrl");
        this.displayName = HtmlManipulator.replaceHtmlEntities(matcher.group("displayname")).trim();
        this.torrentUrl = "magnet" + matcher.group("magnet");
        this.filename = this.displayName + ".torrent";
        this.infoHash = EztvSearchResult.parseInfoHash(matcher, this.torrentUrl);
        this.seeds = 500;
        this.creationTime = this.convertAgeStringToTimestamp(matcher.group("age"));
        this.size = this.parseSize(matcher.group("size"));
    }

    private static String parseInfoHash(SearchMatcher matcher, String torrentUrl) {
        try {
            if (matcher.group("infohash") != null) {
                return matcher.group("infohash");
            }
            if (torrentUrl.startsWith("magnet:?xt=urn:btih:")) {
                return UrlUtils.extractInfoHash(torrentUrl);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static int parseSeeds(String group) {
        try {
            return Integer.parseInt(group);
        }
        catch (Throwable e) {
            return 0;
        }
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getSource() {
        return "Eztv";
    }

    @Override
    public String getHash() {
        return this.infoHash;
    }

    @Override
    public int getSeeds() {
        return this.seeds;
    }

    @Override
    public String getDetailsUrl() {
        return this.detailsUrl;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getTorrentUrl() {
        return this.torrentUrl;
    }

    private long convertAgeStringToTimestamp(String age) {
        long timestamp = System.currentTimeMillis();
        if (age.contains("year")) {
            String[] parts = age.split("year");
            int years = Integer.parseInt(parts[0].trim());
            return timestamp -= (long)(years * 365 * 24 * 60 * 60 * 1000);
        }
        if (age.contains("mo")) {
            String[] parts = age.split("mo");
            int months = Integer.parseInt(parts[0].trim());
            return timestamp -= (long)(months * 30 * 24 * 60 * 60 * 1000);
        }
        if (age.contains("week")) {
            String[] parts = age.split("week");
            int weeks = Integer.parseInt(parts[0].trim());
            return timestamp -= (long)(weeks * 7 * 24 * 60 * 60 * 1000);
        }
        if (age.contains("d")) {
            String[] parts = age.split("d");
            int days = Integer.parseInt(parts[0].trim());
            return timestamp -= (long)(days * 24 * 60 * 60 * 1000);
        }
        if (age.contains("h") && !age.contains("d")) {
            String[] parts = age.split("h");
            int hours = Integer.parseInt(parts[0].trim());
            return timestamp -= (long)(hours * 60 * 60 * 1000);
        }
        return timestamp;
    }
}

