/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.archiveorg;

import com.frostwire.search.CrawlPagedWebSearchPerformer;
import com.frostwire.search.SearchResult;
import com.frostwire.search.archiveorg.ArchiveorgCrawledSearchResult;
import com.frostwire.search.archiveorg.ArchiveorgCrawledStreamableSearchResult;
import com.frostwire.search.archiveorg.ArchiveorgFile;
import com.frostwire.search.archiveorg.ArchiveorgItem;
import com.frostwire.search.archiveorg.ArchiveorgResponse;
import com.frostwire.search.archiveorg.ArchiveorgSearchResult;
import com.frostwire.search.archiveorg.ArchiveorgTorrentSearchResult;
import com.frostwire.util.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ArchiveorgSearchPerformer
extends CrawlPagedWebSearchPerformer<ArchiveorgSearchResult> {
    private static final int MAX_RESULTS = 12;

    public ArchiveorgSearchPerformer(String domainName, long token, String keywords, int timeout2) {
        super(domainName, token, keywords, timeout2, 1, 12);
    }

    @Override
    protected String getSearchUrl(int page, String encodedKeywords) {
        return "https://" + this.getDomainName() + "/advancedsearch.php?q=" + encodedKeywords + "&fl[]=avg_rating&fl[]=call_number&fl[]=collection&fl[]=contributor&fl[]=coverage&fl[]=creator&fl[]=date&fl[]=description&fl[]=downloads&fl[]=foldoutcount&fl[]=format&fl[]=headerImage&fl[]=identifier&fl[]=imagecount&fl[]=language&fl[]=licenseurl&fl[]=mediatype&fl[]=month&fl[]=num_reviews&fl[]=oai_updatedate&fl[]=publicdate&fl[]=publisher&fl[]=rights&fl[]=scanningcentre&fl[]=source&fl[]=title&fl[]=type&fl[]=volume&fl[]=week&fl[]=year&rows=50&page=1&indent=yes&output=json";
    }

    @Override
    protected List<? extends SearchResult> searchPage(String page) {
        LinkedList<ArchiveorgSearchResult> result = new LinkedList<ArchiveorgSearchResult>();
        ArchiveorgResponse response = JsonUtils.toObject(page, ArchiveorgResponse.class);
        for (ArchiveorgItem item : response.response.docs) {
            if (this.isStopped() || !this.filter(item)) continue;
            ArchiveorgSearchResult sr = new ArchiveorgSearchResult(this.getDomainName(), item);
            result.add(sr);
        }
        return result;
    }

    @Override
    protected String getCrawlUrl(ArchiveorgSearchResult sr) {
        return "https://" + this.getDomainName() + "/details/" + sr.getIdentifier() + "?output=json";
    }

    @Override
    protected List<? extends SearchResult> crawlResult(ArchiveorgSearchResult sr, byte[] data) throws Exception {
        LinkedList<ArchiveorgCrawledSearchResult> list = new LinkedList<ArchiveorgCrawledSearchResult>();
        String json = new String(data, StandardCharsets.UTF_8);
        List<ArchiveorgFile> files = this.readFiles(json);
        long totalSize = this.calcTotalSize(files);
        for (ArchiveorgFile file : files) {
            if (ArchiveorgSearchPerformer.isStreamable(file.filename)) {
                list.add(new ArchiveorgCrawledStreamableSearchResult(sr, file));
                continue;
            }
            if (file.filename.endsWith(".torrent")) {
                list.add(new ArchiveorgTorrentSearchResult(sr, file, totalSize));
                continue;
            }
            list.add(new ArchiveorgCrawledSearchResult(sr, file));
        }
        return list;
    }

    private List<ArchiveorgFile> readFiles(String json) {
        LinkedList<ArchiveorgFile> result = new LinkedList<ArchiveorgFile>();
        JsonElement element = JsonParser.parseString(json);
        JsonObject obj = element.getAsJsonObject();
        JsonObject files = obj.getAsJsonObject("files");
        Iterator<Map.Entry<String, JsonElement>> it = files.entrySet().iterator();
        while (it.hasNext() && !this.isStopped()) {
            Map.Entry<String, JsonElement> e = it.next();
            String name = e.getKey();
            String value = e.getValue().toString();
            ArchiveorgFile file = JsonUtils.toObject(value, ArchiveorgFile.class);
            if (!this.filter(file)) continue;
            file.filename = this.cleanName(name);
            result.add(file);
        }
        return result;
    }

    private String cleanName(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name;
    }

    private long calcTotalSize(List<ArchiveorgFile> files) {
        long size = 0L;
        for (ArchiveorgFile f : files) {
            try {
                size += Long.parseLong(f.size);
            }
            catch (Throwable throwable) {}
        }
        return size;
    }

    private boolean filter(ArchiveorgItem item) {
        return item.collection == null || !item.collection.contains("samples_only");
    }

    private boolean filter(ArchiveorgFile file) {
        return file.format == null || !file.format.equalsIgnoreCase("metadata");
    }

    @Override
    public boolean isCrawler() {
        return true;
    }
}

