/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search;

import com.frostwire.search.AbstractSearchPerformer;
import com.frostwire.search.CrawlableSearchResult;
import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.Logger;
import com.frostwire.util.UrlUtils;
import com.frostwire.util.UserAgentGenerator;
import com.frostwire.util.http.HttpClient;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public abstract class WebSearchPerformer
extends AbstractSearchPerformer {
    private static final Logger LOG = Logger.getLogger(WebSearchPerformer.class);
    private static final String DEFAULT_USER_AGENT = UserAgentGenerator.getUserAgent();
    private static final String[] STREAMABLE_EXTENSIONS = new String[]{"mp3", "ogg", "wma", "wmv", "m4a", "aac", "flac", "mp4", "flv", "mov", "mpg", "mpeg", "3gp", "m4v", "webm"};
    private final String domainName;
    private final String keywords;
    private final String encodedKeywords;
    private final int timeout;
    private final HttpClient client;

    WebSearchPerformer(String domainName, long token, String keywords, int timeoutInMilliseconds) {
        super(token);
        if (domainName == null) {
            throw new IllegalArgumentException("domainName can't be null");
        }
        this.domainName = domainName;
        this.keywords = keywords;
        this.encodedKeywords = UrlUtils.encode(keywords);
        this.timeout = timeoutInMilliseconds;
        this.client = HttpClientFactory.getInstance(HttpClientFactory.HttpContext.SEARCH);
    }

    public static boolean isStreamable(String filename) {
        return Arrays.asList(STREAMABLE_EXTENSIONS).contains(FilenameUtils.getExtension(filename));
    }

    public final String getKeywords() {
        return this.keywords;
    }

    public String getEncodedKeywords() {
        return this.encodedKeywords;
    }

    @Override
    public void crawl(CrawlableSearchResult sr) {
        LOG.warn("Review your logic, calling deep search without implementation for: " + String.valueOf(sr));
    }

    public String fetch(String url) throws IOException {
        return this.fetch(url, null, null);
    }

    public String fetch(String url, String cookie, Map<String, String> customHeaders) throws IOException {
        return this.client.get(url, this.timeout, DEFAULT_USER_AGENT, null, cookie, customHeaders);
    }

    public String post(String url, Map<String, String> formData) {
        try {
            return this.client.post(url, this.timeout, DEFAULT_USER_AGENT, formData);
        }
        catch (IOException throwable) {
            LOG.error(throwable.getMessage(), throwable);
            return null;
        }
    }

    public final byte[] fetchBytes(String url) {
        return this.fetchBytes(url, null, this.timeout);
    }

    protected final byte[] fetchBytes(String url, String referrer, int timeout2) {
        if (url.startsWith("htt")) {
            return this.client.getBytes(url, timeout2, DEFAULT_USER_AGENT, referrer);
        }
        return null;
    }

    public String getDomainName() {
        return this.domainName;
    }
}

