/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search;

import com.frostwire.jlibtorrent.FileStorage;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.regex.Pattern;
import com.frostwire.search.AbstractCrawledSearchResult;
import com.frostwire.search.AlbumCluster;
import com.frostwire.search.CrawledSearchResult;
import com.frostwire.search.FileSearchResult;
import com.frostwire.search.RegexSearchPerformer;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.SearchPerformer;
import com.frostwire.search.SearchResult;
import com.frostwire.search.torrent.TorrentCrawlableSearchResult;
import com.frostwire.search.torrent.TorrentCrawledSearchResult;
import com.frostwire.util.Logger;
import com.frostwire.util.StringUtils;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class PerformersHelper {
    private static final Logger LOG = Logger.getLogger(PerformersHelper.class);
    private static final Pattern MAGNET_HASH_PATTERN = Pattern.compile("magnet\\:\\?xt\\=urn\\:btih\\:([a-fA-F0-9]{40})");

    private PerformersHelper() {
    }

    public static List<? extends SearchResult> searchPageHelper(RegexSearchPerformer<?> performer, String page, int regexMaxResults) {
        boolean matcherFound;
        LinkedList result = new LinkedList();
        if (page == null) {
            LOG.warn(performer.getClass().getSimpleName() + " returning null page. Issue fetching page or issue getting page prefix/suffix offsets. Notify developers at contact@frostwire.com");
            return result;
        }
        SearchMatcher matcher = SearchMatcher.from(performer.getPattern().matcher(page));
        int i2 = 0;
        do {
            Object sr;
            try {
                matcherFound = matcher.find();
            }
            catch (Throwable t) {
                matcherFound = false;
                LOG.error("searchPageHelper(...): " + performer.getPattern().toString() + " has failed.\n" + t.getMessage(), t);
            }
            if (!matcherFound || (sr = performer.fromMatcher(matcher)) == null) continue;
            result.add(sr);
            ++i2;
        } while (matcherFound && i2 < regexMaxResults && !performer.isStopped());
        return result;
    }

    public static List<? extends SearchResult> crawlTorrentInfo(SearchPerformer performer, TorrentCrawlableSearchResult sr, byte[] data, boolean detectAlbums) {
        LinkedList<TorrentCrawledSearchResult> list = new LinkedList<TorrentCrawledSearchResult>();
        if (data == null) {
            return list;
        }
        TorrentInfo ti = TorrentInfo.bdecode(data);
        int numFiles = ti.numFiles();
        FileStorage fs = ti.files();
        for (int i2 = 0; !performer.isStopped() && i2 < numFiles; ++i2) {
            if (fs.padFileAt(i2)) continue;
            list.add(new TorrentCrawledSearchResult(sr, ti, i2, fs.filePath(i2), fs.fileSize(i2)));
        }
        if (detectAlbums) {
            LinkedList<AbstractCrawledSearchResult> temp = new LinkedList<AbstractCrawledSearchResult>();
            temp.addAll(list);
            temp.addAll(new AlbumCluster().detect(sr, list));
            return temp;
        }
        return list;
    }

    public static List<? extends SearchResult> crawlTorrentInfo(SearchPerformer performer, TorrentCrawlableSearchResult sr, byte[] data) {
        return PerformersHelper.crawlTorrentInfo(performer, sr, data, false);
    }

    public static String parseInfoHash(String url) {
        String result = null;
        SearchMatcher matcher = SearchMatcher.from(MAGNET_HASH_PATTERN.matcher(url));
        try {
            if (matcher.find()) {
                result = matcher.group(1).toLowerCase();
            }
        }
        catch (Throwable t) {
            LOG.error("Could not parse magnet out of " + url, t);
        }
        return result;
    }

    public static String reduceHtml(String html, int prefixOffset, int suffixOffset) {
        if (prefixOffset == -1 || suffixOffset == -1) {
            html = null;
        } else if (prefixOffset > 0 || suffixOffset < html.length()) {
            if (prefixOffset > suffixOffset) {
                LOG.warn("PerformersHelper.reduceHtml() Check your logic: prefixOffset:" + prefixOffset + " > suffixOffset:" + suffixOffset);
                LOG.info(html);
                return null;
            }
            html = new String(html.substring(prefixOffset, suffixOffset).toCharArray());
        }
        return html;
    }

    public static boolean someSearchTokensMatchSearchResult(List<String> keywords, SearchResult sr) {
        String str = PerformersHelper.searchResultAsNormalizedString(sr);
        for (String keyword : keywords) {
            if (!str.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    public static boolean allQueryTokensExistInSearchResult(List<String> tokens, SearchResult sr) {
        String str = PerformersHelper.searchResultAsNormalizedString(sr);
        tokens.removeIf(str::contains);
        return tokens.isEmpty();
    }

    public static List<String> tokenizeSearchKeywords(String keywords) {
        keywords = PerformersHelper.sanitize(keywords);
        HashSet<String> tokens = new HashSet<String>(Arrays.asList(keywords.toLowerCase(Locale.US).split(" ")));
        return new ArrayList<String>(PerformersHelper.normalizeTokens(tokens));
    }

    private static String searchResultAsNormalizedString(SearchResult sr) {
        StringBuilder sb = new StringBuilder();
        sb.append(sr.getDisplayName());
        if (sr instanceof CrawledSearchResult) {
            sb.append(((CrawledSearchResult)sr).getParent().getDisplayName());
        }
        if (sr instanceof FileSearchResult) {
            sb.append(((FileSearchResult)sr).getFilename());
        }
        String str = PerformersHelper.sanitize(sb.toString());
        return PerformersHelper.normalize(str);
    }

    private static String sanitize(String str) {
        str = StringUtils.fromHtml(str);
        str = str.replaceAll("\\.torrent|www\\.|\\.com|\\.net|[\\\\\\/%_;\\-\\.\\(\\)\\[\\]\\n\\r\u00c3\u0090&~{}\\*@\\^'=!,\u00c2\u00a1|#\u00c3\u0080\u00c3\u0081]", " ");
        str = StringUtils.removeDoubleSpaces(str);
        return str.trim();
    }

    private static String normalize(String token) {
        String norm = Normalizer.normalize(token, Normalizer.Form.NFKD);
        norm = norm.replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
        norm = norm.toLowerCase(Locale.US);
        return norm;
    }

    private static Set<String> normalizeTokens(Set<String> tokens) {
        HashSet<String> normalizedTokens = new HashSet<String>(0);
        for (String token : tokens) {
            String norm = PerformersHelper.normalize(token);
            normalizedTokens.add(norm);
        }
        return normalizedTokens;
    }
}

