/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search;

import com.frostwire.content.ContentValues;
import com.frostwire.database.Cursor;
import com.frostwire.search.CrawlCache;
import com.frostwire.search.CrawlCacheDB;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.settings.SearchSettings;

public class DatabaseCrawlCache
implements CrawlCache {
    private static final Logger LOG = Logger.getLogger(DatabaseCrawlCache.class);
    private final CrawlCacheDB db = CrawlCacheDB.instance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(String key) {
        byte[] data = null;
        try (Cursor c = null;){
            String[] columns = new String[]{"data"};
            String where = "key = ?";
            String[] whereArgs = new String[]{key};
            c = this.db.query(columns, where, whereArgs, null);
            if (c.moveToNext()) {
                data = c.getBytes(c.getColumnIndex("data"));
            }
        }
        return data;
    }

    @Override
    public void put(String key, byte[] data) {
        if (SearchSettings.SMART_SEARCH_ENABLED.getValue()) {
            try {
                ContentValues values2 = new ContentValues();
                values2.put("key", key);
                values2.put("data", data);
                this.db.insert(values2);
            }
            catch (Throwable e) {
                LOG.warn("Error putting value to crawl cache: " + e.getMessage());
            }
        }
    }

    @Override
    public void remove(String key) {
        try {
            String where = "key = ?";
            String[] whereArgs = new String[]{key};
            this.db.delete(where, whereArgs);
        }
        catch (Throwable e) {
            LOG.warn("Error deleting value from crawl cache: " + e.getMessage());
        }
    }

    @Override
    public synchronized void clear() {
        try {
            this.db.truncate();
        }
        catch (Throwable e) {
            LOG.warn("Error deleting crawl cache: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numEntries() {
        long size = 0L;
        try (Cursor c = null;){
            String[] projection = new String[]{"count(*) as total"};
            c = this.db.query(projection, null, null, null);
            if (c != null) {
                size = c.getInt(1);
            }
        }
        return size;
    }

    @Override
    public long sizeInBytes() {
        return this.db.sizeInBytes();
    }
}

