/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search;

import com.frostwire.search.torrent.TorrentCrawlableSearchResult;
import com.frostwire.search.torrent.TorrentCrawledAlbumSearchResult;
import com.frostwire.search.torrent.TorrentItemSearchResult;
import com.frostwire.util.MimeDetector;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class AlbumCluster {
    private static final int ALBUM_SIZE_THRESHOLD = 4;

    public LinkedList<TorrentCrawledAlbumSearchResult> detect(TorrentCrawlableSearchResult parent, List<? extends TorrentItemSearchResult> results) {
        LinkedList<TorrentCrawledAlbumSearchResult> albums = new LinkedList<TorrentCrawledAlbumSearchResult>();
        HashMap dirs = new HashMap();
        for (TorrentItemSearchResult torrentItemSearchResult : results) {
            String path = torrentItemSearchResult.getFilePath();
            String dir = FilenameUtils.getPathNoEndSeparator(path);
            if (!dirs.containsKey(dir)) {
                dirs.put(dir, new LinkedList());
            }
            LinkedList items = (LinkedList)dirs.get(dir);
            items.add(torrentItemSearchResult);
        }
        for (Map.Entry entry2 : dirs.entrySet()) {
            int numAudio = 0;
            for (TorrentItemSearchResult sr : (LinkedList)entry2.getValue()) {
                String mime = MimeDetector.getMimeType(sr.getFilePath());
                if (!mime.startsWith("audio")) continue;
                ++numAudio;
            }
        }
        return albums;
    }
}

