/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.regex;

import com.frostwire.regex.GroupInfo;
import com.frostwire.regex.Matcher;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;

public class Pattern {
    private static final String NAME_PATTERN = "[^!=].*?";
    private static final java.util.regex.Pattern NAMED_GROUP_PATTERN = java.util.regex.Pattern.compile("\\(\\?<([^!=].*?)>", 32);
    private static final int INDEX_GROUP_NAME = 1;
    private com.google.re2j.Pattern pattern;
    private String namedPattern;
    private List<String> groupNames;
    private Map<String, List<GroupInfo>> groupInfo;

    protected Pattern(String regex, int flags) {
        this.namedPattern = regex;
        this.groupInfo = Pattern.extractGroupInfo(regex);
        this.pattern = this.buildStandardPattern(regex, flags);
    }

    public static Pattern compile(String regex) {
        return new Pattern(regex, 0);
    }

    public static Pattern compile(String regex, int flags) {
        return new Pattern(regex, flags);
    }

    private static boolean isEscapedChar(String s, int pos) {
        return Pattern.isSlashEscapedChar(s, pos) || Pattern.isQuoteEscapedChar(s, pos);
    }

    private static boolean isSlashEscapedChar(String s, int pos) {
        int numSlashes = 0;
        while (pos > 0 && s.charAt(pos - 1) == '\\') {
            --pos;
            ++numSlashes;
        }
        return numSlashes % 2 != 0;
    }

    private static boolean isQuoteEscapedChar(String s, int pos) {
        boolean openQuoteFound = false;
        boolean closeQuoteFound = false;
        String s2 = s.substring(0, pos);
        int posOpen = pos;
        while ((posOpen = s2.lastIndexOf("\\Q", posOpen - 1)) != -1) {
            if (Pattern.isSlashEscapedChar(s2, posOpen)) continue;
            openQuoteFound = true;
            break;
        }
        if (openQuoteFound && s2.indexOf("\\E", posOpen) != -1) {
            closeQuoteFound = true;
        }
        return openQuoteFound && !closeQuoteFound;
    }

    private static boolean isInsideCharClass(String s, int pos) {
        boolean openBracketFound = false;
        boolean closeBracketFound = false;
        String s2 = s.substring(0, pos);
        int posOpen = pos;
        while ((posOpen = s2.lastIndexOf(91, posOpen - 1)) != -1) {
            if (Pattern.isEscapedChar(s2, posOpen)) continue;
            openBracketFound = true;
            break;
        }
        if (openBracketFound) {
            String s3 = s.substring(posOpen, pos);
            int posClose = -1;
            while ((posClose = s3.indexOf(93, posClose + 1)) != -1) {
                if (Pattern.isEscapedChar(s3, posClose)) continue;
                closeBracketFound = true;
                break;
            }
        }
        return openBracketFound && !closeBracketFound;
    }

    private static boolean isNoncapturingParen(String s, int pos) {
        boolean isLookbehind = false;
        String pre = s.substring(pos, pos + 4);
        isLookbehind = pre.equals("(?<=") || pre.equals("(?<!");
        return s.charAt(pos + 1) == '?' && (isLookbehind || s.charAt(pos + 2) != '<');
    }

    private static int countOpenParens(String s, int pos) {
        java.util.regex.Pattern p = java.util.regex.Pattern.compile("\\(");
        java.util.regex.Matcher m = p.matcher(s.subSequence(0, pos));
        int numParens = 0;
        while (m.find()) {
            if (Pattern.isInsideCharClass(s, m.start()) || Pattern.isEscapedChar(s, m.start()) || Pattern.isNoncapturingParen(s, m.start())) continue;
            ++numParens;
        }
        return numParens;
    }

    public static Map<String, List<GroupInfo>> extractGroupInfo(String namedPattern) {
        LinkedHashMap<String, List<GroupInfo>> groupInfo = new LinkedHashMap<String, List<GroupInfo>>();
        java.util.regex.Matcher matcher = NAMED_GROUP_PATTERN.matcher(namedPattern);
        while (matcher.find()) {
            int pos = matcher.start();
            if (Pattern.isEscapedChar(namedPattern, pos)) continue;
            String name = matcher.group(1);
            int groupIndex = Pattern.countOpenParens(namedPattern, pos);
            List list = groupInfo.containsKey(name) ? (List)groupInfo.get(name) : new ArrayList();
            list.add(new GroupInfo(groupIndex, pos));
            groupInfo.put(name, list);
        }
        return groupInfo;
    }

    private static StringBuilder replace(StringBuilder input, java.util.regex.Pattern pattern, String replacement) {
        java.util.regex.Matcher m = pattern.matcher(input);
        while (m.find()) {
            if (Pattern.isEscapedChar(input.toString(), m.start())) continue;
            input.replace(m.start(), m.end(), replacement);
            m.reset(input);
        }
        return input;
    }

    public int indexOf(String groupName) {
        return this.indexOf(groupName, 0);
    }

    public int indexOf(String groupName, int index) {
        int idx = -1;
        if (this.groupInfo.containsKey(groupName)) {
            List<GroupInfo> list = this.groupInfo.get(groupName);
            idx = list.get(index).groupIndex();
        }
        return idx;
    }

    public int flags() {
        return this.pattern.flags();
    }

    public Matcher matcher(CharSequence input) {
        return new Matcher(this, input);
    }

    public com.google.re2j.Pattern pattern() {
        return this.pattern;
    }

    public String standardPattern() {
        return this.pattern.pattern();
    }

    public String namedPattern() {
        return this.namedPattern;
    }

    public List<String> groupNames() {
        if (this.groupNames == null) {
            this.groupNames = new ArrayList<String>(this.groupInfo.keySet());
        }
        return this.groupNames;
    }

    public Map<String, List<GroupInfo>> groupInfo() {
        return this.groupInfo;
    }

    public String[] split(String input, int limit) {
        return this.pattern.split(input, limit);
    }

    public String[] split(String input) {
        return this.pattern.split(input);
    }

    public String toString() {
        return this.namedPattern;
    }

    private StringBuilder replaceGroupNameWithIndex(StringBuilder input, java.util.regex.Pattern pattern, String prefix) {
        java.util.regex.Matcher m = pattern.matcher(input);
        while (m.find()) {
            if (Pattern.isEscapedChar(input.toString(), m.start())) continue;
            int index = this.indexOf(m.group(1));
            if (index < 0) {
                throw new PatternSyntaxException("unknown group name", input.toString(), m.start(1));
            }
            input.replace(m.start(), m.end(), prefix + ++index);
            m.reset(input);
        }
        return input;
    }

    private com.google.re2j.Pattern buildStandardPattern(String namedPattern, Integer flags) {
        StringBuilder s = new StringBuilder(namedPattern);
        s = Pattern.replace(s, NAMED_GROUP_PATTERN, "(");
        return com.google.re2j.Pattern.compile(s.toString(), flags);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pattern)) {
            return false;
        }
        Pattern other = (Pattern)obj;
        return this.namedPattern.equals(other.namedPattern) && this.pattern.flags() == other.pattern.flags();
    }

    public int hashCode() {
        return this.namedPattern.hashCode() ^ this.pattern.flags();
    }
}

