/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.FullBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class VideoMediaHeaderBox
extends FullBox {
    protected final short[] opcolor = new short[]{0, 0, 0};
    protected short graphicsmode;

    VideoMediaHeaderBox() {
        super(vmhd);
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        IO.read(ch, 8, buf);
        this.graphicsmode = buf.getShort();
        IO.get(buf, this.opcolor);
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        buf.putShort(this.graphicsmode);
        IO.put(buf, this.opcolor);
        IO.write(ch, 8, buf);
    }

    @Override
    void update() {
        long s = 0L;
        s += 4L;
        s += 2L;
        this.length(s += 6L);
    }
}

