/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.FullBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class TrackRunBox
extends FullBox {
    protected int sample_count;
    protected int data_offset;
    protected int first_sample_flags;
    protected Entry[] entries;

    TrackRunBox() {
        super(trun);
    }

    public boolean dataOffsetPresent() {
        return (this.flags & 1) == 1;
    }

    public boolean firstSampleFlagsPresent() {
        return (this.flags & 4) == 4;
    }

    public boolean sampleDurationPresent() {
        return (this.flags & 0x100) == 256;
    }

    public boolean sampleSizePresent() {
        return (this.flags & 0x200) == 512;
    }

    public boolean sampleFlagsPresent() {
        return (this.flags & 0x400) == 1024;
    }

    public boolean sampleCompositionTimeOffsetsPresent() {
        return (this.flags & 0x800) == 2048;
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        IO.read(ch, 4, buf);
        this.sample_count = buf.getInt();
        if ((this.flags & 1) == 1) {
            IO.read(ch, 4, buf);
            this.data_offset = buf.getInt();
        }
        if ((this.flags & 4) == 4) {
            IO.read(ch, 4, buf);
            this.first_sample_flags = buf.getInt();
        }
        this.entries = new Entry[this.sample_count];
        for (int i2 = 0; i2 < this.sample_count; ++i2) {
            Entry e = new Entry();
            if ((this.flags & 0x100) == 256) {
                IO.read(ch, 4, buf);
                e.sample_duration = buf.getInt();
            }
            if ((this.flags & 0x200) == 512) {
                IO.read(ch, 4, buf);
                e.sample_size = buf.getInt();
            }
            if ((this.flags & 0x400) == 1024) {
                IO.read(ch, 4, buf);
                e.sample_flags = buf.getInt();
            }
            if ((this.flags & 0x800) == 2048) {
                IO.read(ch, 4, buf);
                e.sample_composition_time_offset = buf.getInt();
            }
            this.entries[i2] = e;
        }
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        buf.putInt(this.sample_count);
        IO.write(ch, 4, buf);
        if ((this.flags & 1) == 1) {
            buf.putInt(this.data_offset);
            IO.write(ch, 4, buf);
        }
        if ((this.flags & 4) == 4) {
            buf.putInt(this.first_sample_flags);
            IO.write(ch, 4, buf);
        }
        for (int i2 = 0; i2 < this.sample_count; ++i2) {
            Entry e = this.entries[i2];
            if ((this.flags & 0x100) == 256) {
                buf.putInt(e.sample_duration);
                IO.write(ch, 4, buf);
            }
            if ((this.flags & 0x200) == 512) {
                buf.putInt(e.sample_size);
                IO.write(ch, 4, buf);
            }
            if ((this.flags & 0x400) == 1024) {
                buf.putInt(e.sample_flags);
                IO.write(ch, 4, buf);
            }
            if ((this.flags & 0x800) != 2048) continue;
            buf.putInt(e.sample_composition_time_offset);
            IO.write(ch, 4, buf);
        }
    }

    @Override
    void update() {
        long s = 0L;
        s += 4L;
        s += 4L;
        if ((this.flags & 1) == 1) {
            s += 4L;
        }
        if ((this.flags & 4) == 4) {
            s += 4L;
        }
        for (int i2 = 0; i2 < this.sample_count; ++i2) {
            if ((this.flags & 0x100) == 256) {
                s += 4L;
            }
            if ((this.flags & 0x200) == 512) {
                s += 4L;
            }
            if ((this.flags & 0x400) == 1024) {
                s += 4L;
            }
            if ((this.flags & 0x800) != 2048) continue;
            s += 4L;
        }
        this.length(s);
    }

    public static final class Entry {
        public int sample_duration;
        public int sample_size;
        public int sample_flags;
        public int sample_composition_time_offset;
    }
}

