/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.FullBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class TrackHeaderBox
extends FullBox {
    protected final int[] reserved2 = new int[2];
    protected final int[] matrix = new int[]{65536, 0, 0, 0, 65536, 0, 0, 0, 0x40000000};
    protected long creation_time;
    protected long modification_time;
    protected int reserved1;
    protected long duration;
    protected short layer;
    protected short alternate_group;
    protected short volume;
    protected short reserved3;
    protected int width;
    protected int height;
    private int track_ID;

    TrackHeaderBox() {
        super(tkhd);
    }

    public int trackId() {
        return this.track_ID;
    }

    public void trackId(int value) {
        this.track_ID = value;
    }

    public boolean enabled() {
        return (this.flags & 1) == 1;
    }

    public void enabled(boolean value) {
        this.flags = value ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public boolean inMovie() {
        return (this.flags & 2) == 2;
    }

    public void inMovie(boolean value) {
        this.flags = value ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public boolean inPreview() {
        return (this.flags & 4) == 4;
    }

    public void inPreview(boolean value) {
        this.flags = value ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public boolean inPoster() {
        return (this.flags & 8) == 8;
    }

    public void inPoster(boolean value) {
        this.flags = value ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        IO.read(ch, (this.version == 1 ? 32 : 20) + 60, buf);
        if (this.version == 1) {
            this.creation_time = buf.getLong();
            this.modification_time = buf.getLong();
            this.track_ID = buf.getInt();
            this.reserved1 = buf.getInt();
            this.duration = buf.getLong();
        } else {
            this.creation_time = buf.getInt();
            this.modification_time = buf.getInt();
            this.track_ID = buf.getInt();
            this.reserved1 = buf.getInt();
            this.duration = buf.getInt();
        }
        IO.get(buf, this.reserved2);
        this.layer = buf.getShort();
        this.alternate_group = buf.getShort();
        this.volume = buf.getShort();
        this.reserved3 = buf.getShort();
        IO.get(buf, this.matrix);
        this.width = buf.getInt();
        this.height = buf.getInt();
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        if (this.version == 1) {
            buf.putLong(this.creation_time);
            buf.putLong(this.modification_time);
            buf.putInt(this.track_ID);
            buf.putInt(this.reserved1);
            buf.putLong(this.duration);
        } else {
            buf.putInt((int)this.creation_time);
            buf.putInt((int)this.modification_time);
            buf.putInt(this.track_ID);
            buf.putInt(this.reserved1);
            buf.putInt((int)this.duration);
        }
        IO.put(buf, this.reserved2);
        buf.putShort(this.layer);
        buf.putShort(this.alternate_group);
        buf.putShort(this.volume);
        buf.putShort(this.reserved3);
        IO.put(buf, this.matrix);
        buf.putInt(this.width);
        buf.putInt(this.height);
        IO.write(ch, (this.version == 1 ? 32 : 20) + 60, buf);
    }

    @Override
    void update() {
        long s = 0L;
        s += 4L;
        s += 60L;
        s = this.version == 1 ? (s += 32L) : (s += 20L);
        this.length(s);
    }
}

