/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.Bits;
import com.frostwire.mp4.Box;
import com.frostwire.mp4.BoxEntry;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public final class IsoMedia {
    private IsoMedia() {
    }

    static boolean read(InputChannel ch, long len, Box p, ByteBuffer buf, OnBoxListener l) throws IOException {
        long n = ch.count();
        do {
            long length;
            IO.read(ch, 8, buf);
            int size = buf.getInt();
            int type = buf.getInt();
            Long largesize = null;
            if (size == 1) {
                IO.read(ch, 8, buf);
                largesize = buf.getLong();
            }
            byte[] usertype = null;
            if (type == Box.uuid) {
                usertype = new byte[16];
                IO.read(ch, 16, buf);
                buf.get(usertype);
            }
            Box b = Box.empty(type);
            b.size = size;
            b.largesize = largesize;
            b.usertype = usertype;
            b.parent = p;
            long r = ch.count();
            b.read(ch, buf);
            r = ch.count() - r;
            if (p != null) {
                p.boxes.add(b);
            }
            if (l != null) {
                long pos = ch.count();
                if (!l.onBox(b)) {
                    return false;
                }
                if (pos != ch.count() && (r = ch.count() - pos) != b.length()) {
                    throw new UnsupportedOperationException("Invalid read inside listener");
                }
            }
            if (r >= (length = b.length())) continue;
            if (type != Box.mdat) {
                if (IsoMedia.read(ch, length - r, b, buf, l)) continue;
                return false;
            }
            if (length > 0L) {
                IO.skip(ch, length - r, buf);
                continue;
            }
            IO.skip(ch, buf);
        } while (len == -1L || ch.count() - n < len);
        return true;
    }

    public static void read(InputChannel ch, ByteBuffer buf, OnBoxListener l) throws IOException {
        try {
            IsoMedia.read(ch, -1L, null, buf, l);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public static boolean write(OutputChannel ch, LinkedList<Box> boxes, ByteBuffer buf, OnBoxListener l) throws IOException {
        buf.clear();
        for (Box b : boxes) {
            buf.putInt(b.size);
            buf.putInt(b.type);
            IO.write(ch, 8, buf);
            if (b.largesize != null) {
                buf.putLong(b.largesize);
                IO.write(ch, 8, buf);
            }
            if (b.usertype != null) {
                buf.put(b.usertype);
                IO.write(ch, 16, buf);
            }
            long length = b.length();
            long w = ch.count();
            b.write(ch, buf);
            if (l != null && !l.onBox(b)) {
                return false;
            }
            if (b.boxes != null && !IsoMedia.write(ch, b.boxes, buf, l)) {
                return false;
            }
            w = ch.count() - w;
            if (w == length || b.type == Box.mdat) continue;
            throw new IOException("Inconsistent box data: " + Bits.make4cc(b.type));
        }
        return true;
    }

    static void write(OutputChannel ch, int count, int size, BoxEntry[] entries, ByteBuffer buf) throws IOException {
        if (count > 0) {
            for (int i2 = 0; i2 < count; ++i2) {
                if (buf.position() > 0 && buf.remaining() < size) {
                    IO.write(ch, buf.position(), buf);
                }
                entries[i2].put(buf);
            }
            if (buf.position() > 0) {
                IO.write(ch, buf.position(), buf);
            }
        }
    }

    public static interface OnBoxListener {
        public static final OnBoxListener ALL = new OnBoxListener(){

            @Override
            public boolean onBox(Box b) {
                return true;
            }
        };

        public boolean onBox(Box var1) throws IOException;
    }
}

