/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.Box;
import com.frostwire.mp4.FreeSpaceBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.Int32;
import com.frostwire.mp4.IsoMedia;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public final class IsoFile {
    private IsoFile() {
    }

    public static LinkedList<Box> head(RandomAccessFile in, ByteBuffer buf) throws IOException {
        in.seek(0L);
        InputChannel ch = new InputChannel(in.getChannel());
        final LinkedList<Box> boxes = new LinkedList<Box>();
        IsoMedia.read(ch, buf, new IsoMedia.OnBoxListener(){

            @Override
            public boolean onBox(Box b) {
                if (b.parent == null) {
                    boxes.add(b);
                }
                return b.type != Box.mdat;
            }
        });
        in.seek(0L);
        return boxes;
    }

    public static int count(RandomAccessFile in, final int type, ByteBuffer buf) throws IOException {
        in.seek(0L);
        InputChannel ch = new InputChannel(in.getChannel());
        final Int32 n = new Int32(0);
        IsoMedia.read(ch, buf, new IsoMedia.OnBoxListener(){

            @Override
            public boolean onBox(Box b) {
                if (b.type == type || type == 0) {
                    n.increment();
                }
                return true;
            }
        });
        in.seek(0L);
        return n.get();
    }

    public static void free(RandomAccessFile in, final int type, final ByteBuffer buf) throws IOException {
        in.seek(0L);
        final InputChannel ch = new InputChannel(in.getChannel());
        final LinkedList<Box> boxes = new LinkedList<Box>();
        IsoMedia.read(ch, buf, new IsoMedia.OnBoxListener(){

            @Override
            public boolean onBox(Box b) throws IOException {
                if (b.parent == null) {
                    boxes.add(b);
                }
                if (b.type == type && b.parent != null) {
                    b.parent.boxes.remove(b);
                    b.parent.boxes.add(FreeSpaceBox.free(b.length()));
                    IO.skip(ch, b.length(), buf);
                }
                return b.type != Box.mdat;
            }
        });
        in.seek(0L);
        OutputChannel out = new OutputChannel(in.getChannel());
        IsoMedia.write(out, boxes, buf, IsoMedia.OnBoxListener.ALL);
        in.seek(0L);
    }
}

