/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.FullBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class EditListBox
extends FullBox {
    protected int entry_count;
    protected Entry[] entries;

    EditListBox() {
        super(elst);
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        IO.read(ch, 4, buf);
        this.entry_count = buf.getInt();
        this.entries = new Entry[this.entry_count];
        for (int i2 = 0; i2 < this.entry_count; ++i2) {
            Entry e = new Entry();
            IO.read(ch, this.version == 1 ? 20 : 12, buf);
            if (this.version == 1) {
                e.segment_duration = buf.getLong();
                e.media_time = buf.getLong();
            } else {
                e.segment_duration = buf.getInt();
                e.media_time = buf.getInt();
            }
            e.media_rate_integer = buf.getShort();
            e.media_rate_fraction = buf.getShort();
            this.entries[i2] = e;
        }
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        buf.putInt(this.entry_count);
        IO.write(ch, 4, buf);
        for (int i2 = 0; i2 < this.entry_count; ++i2) {
            Entry e = this.entries[i2];
            if (this.version == 1) {
                buf.putLong(e.segment_duration);
                buf.putLong(e.media_time);
            } else {
                buf.putInt((int)e.segment_duration);
                buf.putInt((int)e.media_time);
            }
            buf.putShort(e.media_rate_integer);
            buf.putShort(e.media_rate_fraction);
            IO.write(ch, this.version == 1 ? 20 : 12, buf);
        }
    }

    @Override
    void update() {
        long s = 0L;
        s += 4L;
        s += 4L;
        this.length(s += (long)(this.entry_count * (this.version == 1 ? 20 : 12)));
    }

    public static final class Entry {
        public long segment_duration;
        public long media_time;
        public short media_rate_integer;
        public short media_rate_fraction;
    }
}

