/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.Box;
import com.frostwire.mp4.FullBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class DataReferenceBox
extends FullBox {
    protected int entry_count;
    protected Box[] entries;

    DataReferenceBox() {
        super(dref);
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        IO.read(ch, 4, buf);
        this.entry_count = buf.getInt();
        this.entries = new Box[this.entry_count];
        for (int i2 = 0; i2 < this.entry_count; ++i2) {
            IO.read(ch, 8, buf);
            int size = buf.getInt();
            int type = buf.getInt();
            Long largesize = null;
            if (size == 1) {
                IO.read(ch, 8, buf);
                largesize = buf.getLong();
            }
            Box b = Box.empty(type);
            b.size = size;
            b.largesize = largesize;
            b.read(ch, buf);
            this.entries[i2] = b;
        }
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        buf.putInt(this.entry_count);
        IO.write(ch, 4, buf);
        for (int i2 = 0; i2 < this.entry_count; ++i2) {
            Box b = this.entries[i2];
            buf.putInt(b.size);
            buf.putInt(b.type);
            IO.write(ch, 8, buf);
            if (b.largesize != null) {
                buf.putLong(b.largesize);
                IO.write(ch, 8, buf);
            }
            b.write(ch, buf);
        }
    }

    @Override
    void update() {
        long s = 0L;
        s += 4L;
        s += 4L;
        for (int i2 = 0; i2 < this.entry_count; ++i2) {
            Box b = this.entries[i2];
            b.update();
            if (b.size == 1) {
                s += b.largesize.longValue();
                continue;
            }
            s += (long)b.size;
        }
        this.length(s);
    }
}

