/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.Box;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;

public class ContainerBox
extends Box {
    private static final HashMap<Integer, int[]> mapping = ContainerBox.buildMapping();

    ContainerBox(int type) {
        super(type);
        this.boxes = new LinkedList();
    }

    static long length(LinkedList<Box> boxes) {
        long s = 0L;
        for (Box b : boxes) {
            b.update();
            if (b.size == 1) {
                s += b.largesize.longValue();
                continue;
            }
            if (b.size == 0) {
                throw new UnsupportedOperationException();
            }
            s += (long)b.size;
        }
        return s;
    }

    static void sort(LinkedList<Box> boxes, final int[] list) {
        Collections.sort(boxes, new Comparator<Box>(){

            @Override
            public int compare(Box o1, Box o2) {
                int x = Integer.MAX_VALUE;
                int y = Integer.MAX_VALUE;
                for (int i2 = 0; i2 < list.length; ++i2) {
                    if (list[i2] == o1.type) {
                        x = i2;
                    }
                    if (list[i2] != o2.type) continue;
                    y = i2;
                }
                return Integer.compare(x, y);
            }
        });
    }

    private static HashMap<Integer, int[]> buildMapping() {
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        map.put(moov, new int[]{mvhd, trak, mvex, ipmc, udta, meta});
        map.put(trak, new int[]{tkhd, tref, edts, mdia, udta, meta});
        map.put(edts, new int[]{elst});
        map.put(mdia, new int[]{mdhd, hdlr, minf});
        map.put(minf, new int[]{vmhd, smhd, hmhd, nmhd, dinf, stbl});
        map.put(dinf, new int[]{dref});
        map.put(stbl, new int[]{stsd, stts, ctts, stsc, stsz, stz2, stco, co64, stss, stsh, padb, stdp, sdtp, sbgp, sgpd, subs});
        map.put(mvex, new int[]{mehd, trex});
        map.put(moof, new int[]{mfhd, traf});
        map.put(traf, new int[]{tfhd, trun, sdtp, sbgp, subs});
        map.put(mfra, new int[]{tfra, mfro});
        map.put(udta, new int[]{cprt, meta});
        map.put(meta, new int[]{hdlr, dinf, ipmc, iloc, ipro, iinf, xml_, bxml, pitm, ilst});
        map.put(ipro, new int[]{sinf});
        map.put(sinf, new int[]{frma, imif, schm, schi});
        map.put(ilst, new int[]{Cnam, CART, aART, Calb, Cgen, gnre, Cday, trkn, stik, covr});
        return map;
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
    }

    @Override
    final void update() {
        int[] list = mapping.get(this.type);
        if (list != null) {
            ContainerBox.sort(this.boxes, list);
        }
        long s = 0L;
        this.length(s += ContainerBox.length(this.boxes));
    }
}

