/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.FullBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class CompactSampleSizeBox
extends FullBox {
    protected final byte[] reserved = new byte[3];
    protected byte field_size;
    protected int sample_count;
    protected Entry[] entries;

    CompactSampleSizeBox() {
        super(stz2);
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        IO.read(ch, 8, buf);
        buf.get(this.reserved);
        this.field_size = buf.get();
        this.sample_count = buf.getInt();
        this.entries = new Entry[this.sample_count];
        for (int i2 = 0; i2 < this.sample_count; ++i2) {
            Entry e = new Entry();
            switch (this.field_size) {
                case 4: {
                    throw new UnsupportedOperationException();
                }
                case 8: {
                    IO.read(ch, 1, buf);
                    e.entry_size = buf.get();
                    break;
                }
                case 16: {
                    IO.read(ch, 2, buf);
                    e.entry_size = buf.getShort();
                }
            }
            this.entries[i2] = e;
        }
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        buf.put(this.reserved);
        buf.put(this.field_size);
        buf.putInt(this.sample_count);
        IO.write(ch, 8, buf);
        block5: for (int i2 = 0; i2 < this.sample_count; ++i2) {
            Entry e = this.entries[i2];
            switch (this.field_size) {
                case 4: {
                    throw new UnsupportedOperationException();
                }
                case 8: {
                    buf.put((byte)e.entry_size);
                    IO.write(ch, 1, buf);
                    continue block5;
                }
                case 16: {
                    buf.putShort(e.entry_size);
                    IO.write(ch, 2, buf);
                }
            }
        }
    }

    @Override
    void update() {
        long s = 0L;
        s += 4L;
        s += 8L;
        this.length(s += (long)(this.sample_count * this.field_size));
    }

    public static final class Entry {
        public short entry_size;
    }
}

