/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.AbstractID3v2FrameData;
import com.frostwire.mp3.BufferTools;
import com.frostwire.mp3.EncodedText;
import com.frostwire.mp3.InvalidDataException;

public class ID3v2UrlFrameData
extends AbstractID3v2FrameData {
    protected String url;
    protected EncodedText description;

    public ID3v2UrlFrameData(boolean unsynchronisation) {
        super(unsynchronisation);
    }

    public ID3v2UrlFrameData(boolean unsynchronisation, EncodedText description, String url) {
        super(unsynchronisation);
        this.description = description;
        this.url = url;
    }

    public ID3v2UrlFrameData(boolean unsynchronisation, byte[] bytes) throws InvalidDataException {
        super(unsynchronisation);
        this.synchroniseAndUnpackFrameData(bytes);
    }

    @Override
    protected void unpackFrameData(byte[] bytes) throws InvalidDataException {
        int marker;
        for (marker = 1; marker < bytes.length && bytes[marker] != 0; ++marker) {
        }
        this.description = new EncodedText(bytes[0], BufferTools.copyBuffer(bytes, 1, marker - 1));
        int length = 0;
        for (int i2 = marker + 1; i2 < bytes.length && bytes[i2] != 0; ++i2) {
            ++length;
        }
        this.url = BufferTools.byteBufferToString(bytes, marker + 1, length);
    }

    @Override
    protected byte[] packFrameData() {
        byte[] bytes = new byte[this.getLength()];
        bytes[0] = this.description != null ? this.description.getTextEncoding() : (byte)0;
        int descriptionLength = 0;
        if (this.description != null && this.description.toBytes().length > 0) {
            descriptionLength = this.description.toBytes().length;
            BufferTools.copyIntoByteBuffer(this.description.toBytes(), 0, descriptionLength, bytes, 1);
        }
        bytes[descriptionLength + 1] = 0;
        if (this.url != null && this.url.length() > 0) {
            BufferTools.stringIntoByteBuffer(this.url, 0, this.url.length(), bytes, descriptionLength + 2);
        }
        return bytes;
    }

    @Override
    protected int getLength() {
        int length = 2;
        if (this.description != null) {
            length += this.description.toBytes().length;
        }
        if (this.url != null) {
            length += this.url.length();
        }
        return length;
    }

    public EncodedText getDescription() {
        return this.description;
    }

    public void setDescription(EncodedText description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v2UrlFrameData)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ID3v2UrlFrameData other = (ID3v2UrlFrameData)obj;
        if (this.url == null) {
            if (other.url != null) {
                return false;
            }
        } else {
            if (other.url == null) {
                return false;
            }
            if (!this.url.equals(other.url)) {
                return false;
            }
        }
        if (this.description == null) {
            if (other.description != null) {
                return false;
            }
        } else {
            if (other.description == null) {
                return false;
            }
            if (!this.description.equals(other.description)) {
                return false;
            }
        }
        return true;
    }
}

