/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.BufferTools;
import com.frostwire.mp3.ID3v1;
import com.frostwire.mp3.ID3v1Genres;
import com.frostwire.mp3.NoSuchTagException;
import java.util.Arrays;

public class ID3v1Tag
implements ID3v1 {
    public static final int TAG_LENGTH = 128;
    private static final String VERSION_0 = "0";
    private static final String VERSION_1 = "1";
    private static final String TAG = "TAG";
    private static final int TITLE_OFFSET = 3;
    private static final int TITLE_LENGTH = 30;
    private static final int ARTIST_OFFSET = 33;
    private static final int ARTIST_LENGTH = 30;
    private static final int ALBUM_OFFSET = 63;
    private static final int ALBUM_LENGTH = 30;
    private static final int YEAR_OFFSET = 93;
    private static final int YEAR_LENGTH = 4;
    private static final int COMMENT_OFFSET = 97;
    private static final int COMMENT_LENGTH_V1_0 = 30;
    private static final int COMMENT_LENGTH_V1_1 = 28;
    private static final int TRACK_MARKER_OFFSET = 125;
    private static final int TRACK_OFFSET = 126;
    private static final int GENRE_OFFSET = 127;
    private String track = null;
    private String artist = null;
    private String title = null;
    private String album = null;
    private String year = null;
    private int genre = -1;
    private String comment = null;

    public ID3v1Tag() {
    }

    public ID3v1Tag(byte[] bytes) throws NoSuchTagException {
        this.unpackTag(bytes);
    }

    private void unpackTag(byte[] bytes) throws NoSuchTagException {
        this.sanityCheckTag(bytes);
        this.title = BufferTools.trimStringRight(BufferTools.byteBufferToString(bytes, 3, 30));
        this.artist = BufferTools.trimStringRight(BufferTools.byteBufferToString(bytes, 33, 30));
        this.album = BufferTools.trimStringRight(BufferTools.byteBufferToString(bytes, 63, 30));
        this.year = BufferTools.trimStringRight(BufferTools.byteBufferToString(bytes, 93, 4));
        this.genre = bytes[127] & 0xFF;
        if (this.genre == 255) {
            this.genre = -1;
        }
        if (bytes[125] != 0) {
            this.comment = BufferTools.trimStringRight(BufferTools.byteBufferToString(bytes, 97, 30));
            this.track = null;
        } else {
            this.comment = BufferTools.trimStringRight(BufferTools.byteBufferToString(bytes, 97, 28));
            byte trackInt = bytes[126];
            this.track = trackInt == 0 ? "" : Integer.toString(trackInt);
        }
    }

    private void sanityCheckTag(byte[] bytes) throws NoSuchTagException {
        if (bytes.length != 128) {
            throw new NoSuchTagException("Buffer length wrong");
        }
        if (!TAG.equals(BufferTools.byteBufferToString(bytes, 0, TAG.length()))) {
            throw new NoSuchTagException();
        }
    }

    @Override
    public byte[] toBytes() {
        byte[] bytes = new byte[128];
        this.packTag(bytes);
        return bytes;
    }

    public void toBytes(byte[] bytes) {
        this.packTag(bytes);
    }

    public void packTag(byte[] bytes) {
        Arrays.fill(bytes, (byte)0);
        BufferTools.stringIntoByteBuffer(TAG, 0, 3, bytes, 0);
        this.packField(bytes, this.title, 30, 3);
        this.packField(bytes, this.artist, 30, 33);
        this.packField(bytes, this.album, 30, 63);
        this.packField(bytes, this.year, 4, 93);
        bytes[127] = this.genre < 128 ? (byte)this.genre : (byte)(this.genre - 256);
        if (this.track == null) {
            this.packField(bytes, this.comment, 30, 97);
        } else {
            this.packField(bytes, this.comment, 28, 97);
            String trackTemp = this.numericsOnly(this.track);
            if (trackTemp.length() > 0) {
                int trackInt = Integer.parseInt(trackTemp);
                bytes[126] = trackInt < 128 ? (byte)trackInt : (byte)(trackInt - 256);
            }
        }
    }

    private void packField(byte[] bytes, String value, int maxLength, int offset) {
        if (value != null) {
            BufferTools.stringIntoByteBuffer(value, 0, Math.min(value.length(), maxLength), bytes, offset);
        }
    }

    private String numericsOnly(String s) {
        char ch;
        StringBuilder stringBuffer = new StringBuilder();
        for (int i2 = 0; i2 < s.length() && (ch = s.charAt(i2)) >= '0' && ch <= '9'; ++i2) {
            stringBuffer.append(ch);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getVersion() {
        if (this.track == null) {
            return VERSION_0;
        }
        return VERSION_1;
    }

    @Override
    public String getTrack() {
        return this.track;
    }

    @Override
    public void setTrack(String track) {
        this.track = track;
    }

    @Override
    public String getArtist() {
        return this.artist;
    }

    @Override
    public void setArtist(String artist) {
        this.artist = artist;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getAlbum() {
        return this.album;
    }

    @Override
    public void setAlbum(String album) {
        this.album = album;
    }

    @Override
    public String getYear() {
        return this.year;
    }

    @Override
    public void setYear(String year) {
        this.year = year;
    }

    @Override
    public int getGenre() {
        return this.genre;
    }

    @Override
    public void setGenre(int genre) {
        this.genre = genre;
    }

    @Override
    public String getGenreDescription() {
        try {
            return ID3v1Genres.GENRES[this.genre];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "Unknown";
        }
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v1Tag)) {
            return false;
        }
        if (super.equals(obj)) {
            return true;
        }
        ID3v1Tag other = (ID3v1Tag)obj;
        if (this.genre != other.genre) {
            return false;
        }
        if (this.track == null) {
            if (other.track != null) {
                return false;
            }
        } else {
            if (other.track == null) {
                return false;
            }
            if (!this.track.equals(other.track)) {
                return false;
            }
        }
        if (this.artist == null) {
            if (other.artist != null) {
                return false;
            }
        } else {
            if (other.artist == null) {
                return false;
            }
            if (!this.artist.equals(other.artist)) {
                return false;
            }
        }
        if (this.title == null) {
            if (other.title != null) {
                return false;
            }
        } else {
            if (other.title == null) {
                return false;
            }
            if (!this.title.equals(other.title)) {
                return false;
            }
        }
        if (this.album == null) {
            if (other.album != null) {
                return false;
            }
        } else {
            if (other.album == null) {
                return false;
            }
            if (!this.album.equals(other.album)) {
                return false;
            }
        }
        if (this.year == null) {
            if (other.year != null) {
                return false;
            }
        } else {
            if (other.year == null) {
                return false;
            }
            if (!this.year.equals(other.year)) {
                return false;
            }
        }
        if (this.comment == null) {
            if (other.comment != null) {
                return false;
            }
        } else {
            if (other.comment == null) {
                return false;
            }
            if (!this.comment.equals(other.comment)) {
                return false;
            }
        }
        return true;
    }
}

