/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.licenses;

import com.frostwire.licenses.License;
import java.util.Locale;

public final class CreativeCommonsLicense
extends License {
    private final String acronym;

    CreativeCommonsLicense(String name, String url, String acronym) {
        super(name, url);
        this.acronym = acronym;
    }

    static CreativeCommonsLicense standard(String name, String acronym, String version) {
        String fullName = "Creative Commons " + name + " " + version;
        String url = "http://creativecommons.org/licenses/" + acronym.toLowerCase(Locale.US) + "/" + version + "/";
        String fullAcronym = "CC " + acronym.toUpperCase(Locale.US) + " " + version;
        return new CreativeCommonsLicense(fullName, url, fullAcronym);
    }

    public String acronym() {
        return this.acronym;
    }
}

