/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.Files;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.swig.entry;
import com.frostwire.jlibtorrent.swig.entry_vector;
import com.frostwire.jlibtorrent.swig.string_entry_map;
import com.frostwire.jlibtorrent.swig.string_vector;
import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Entry {
    private final entry e;

    public Entry(entry e) {
        this.e = e;
    }

    public Entry(String s) {
        this(new entry(s));
    }

    public Entry(long n) {
        this(new entry(n));
    }

    public entry swig() {
        return this.e;
    }

    public byte[] bencode() {
        return Vectors.byte_vector2bytes(this.e.bencode());
    }

    public String string() {
        return this.e.string();
    }

    public long integer() {
        return this.e.integer();
    }

    public List<Entry> list() {
        return new EntryList(this.e.list());
    }

    public Map<String, Entry> dictionary() {
        return new EntryMap(this.e.dict());
    }

    public String toString() {
        return this.e.to_string();
    }

    public static Entry bdecode(byte[] data) {
        return new Entry(entry.bdecode(Vectors.bytes2byte_vector(data)));
    }

    public static Entry bdecode(File file) throws IOException {
        byte[] data = Files.bytes(file);
        return Entry.bdecode(data);
    }

    public static Entry fromList(List<?> list) {
        entry e = new entry(entry.data_type.list_t);
        entry_vector d = e.list();
        for (Object v : list) {
            if (v instanceof String) {
                d.push_back(new entry((String)v));
                continue;
            }
            if (v instanceof Integer) {
                d.push_back(new entry(((Integer)v).intValue()));
                continue;
            }
            if (v instanceof Entry) {
                d.push_back(((Entry)v).swig());
                continue;
            }
            if (v instanceof entry) {
                d.push_back((entry)v);
                continue;
            }
            if (v instanceof List) {
                d.push_back(Entry.fromList((List)v).swig());
                continue;
            }
            if (v instanceof Map) {
                d.push_back(Entry.fromMap((Map)v).swig());
                continue;
            }
            d.push_back(new entry(v.toString()));
        }
        return new Entry(e);
    }

    public static Entry fromMap(Map<String, ?> map) {
        entry e = new entry(entry.data_type.dictionary_t);
        string_entry_map d = e.dict();
        for (String k : map.keySet()) {
            Object v = map.get(k);
            if (v instanceof String) {
                d.set(k, new entry((String)v));
                continue;
            }
            if (v instanceof Integer) {
                d.set(k, new entry(((Integer)v).intValue()));
                continue;
            }
            if (v instanceof Entry) {
                d.set(k, ((Entry)v).swig());
                continue;
            }
            if (v instanceof entry) {
                d.set(k, (entry)v);
                continue;
            }
            if (v instanceof List) {
                d.set(k, Entry.fromList((List)v).swig());
                continue;
            }
            if (v instanceof Map) {
                d.set(k, Entry.fromMap((Map)v).swig());
                continue;
            }
            d.set(k, new entry(v.toString()));
        }
        return new Entry(e);
    }

    private static final class EntryList
    extends AbstractList<Entry> {
        private final entry_vector v;

        public EntryList(entry_vector v) {
            this.v = v;
        }

        @Override
        public Entry get(int index) {
            return new Entry(this.v.get(index));
        }

        @Override
        public boolean add(Entry entry2) {
            this.v.push_back(entry2.swig());
            return true;
        }

        @Override
        public int size() {
            return (int)this.v.size();
        }

        @Override
        public void clear() {
            this.v.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.v.empty();
        }
    }

    private static final class EntryMap
    extends AbstractMap<String, Entry> {
        private final string_entry_map m;

        public EntryMap(string_entry_map m) {
            this.m = m;
        }

        @Override
        public Entry get(Object key) {
            String k = key.toString();
            return this.m.has_key(k) ? new Entry(this.m.get(key.toString())) : null;
        }

        @Override
        public Entry put(String key, Entry value) {
            Entry r = this.get(key);
            this.m.set(key, value.swig());
            return r;
        }

        @Override
        public int size() {
            return (int)this.m.size();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.m.has_key(key.toString());
        }

        @Override
        public boolean isEmpty() {
            return this.m.empty();
        }

        @Override
        public Set<String> keySet() {
            HashSet<String> s = new HashSet<String>();
            string_vector v = this.m.keys();
            int size = (int)v.size();
            for (int i2 = 0; i2 < size; ++i2) {
                s.add(v.get(i2));
            }
            return s;
        }

        @Override
        public Set<Map.Entry<String, Entry>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }
}

