/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.updates;

import com.frostwire.gui.updates.UpdateManager;
import com.frostwire.gui.updates.UpdateMessage;
import com.frostwire.util.Logger;
import com.frostwire.util.OSUtils;
import com.limegroup.gnutella.gui.search.SearchEngine;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

final class UpdateMessageReader
implements ContentHandler {
    private static final Logger LOG = Logger.getLogger(UpdateMessageReader.class);
    private static final String DEFAULT_UPDATE_URL = "https://update.frostwire.com";
    private HashSet<UpdateMessage> _announcements = null;
    private UpdateMessage _bufferMessage = null;
    private LinkedList<UpdateMessage> _overlays = null;
    private UpdateMessage _updateMessage = null;

    UpdateMessageReader() {
    }

    private void addAnnouncement(UpdateMessage msg) {
        if (this._announcements == null) {
            this._announcements = new HashSet();
        }
        if (msg.getMessageType().equals("announcement") && !msg.hasExpired()) {
            this._announcements.add(msg);
        }
    }

    private void addOverlay(UpdateMessage msg) {
        if (msg != null && msg.getMessageType().equals("overlay")) {
            if (this._overlays == null) {
                this._overlays = new LinkedList();
            }
            if (!this._overlays.isEmpty()) {
                for (UpdateMessage m : this._overlays) {
                    if (m.isIntro() != msg.isIntro()) continue;
                    this._overlays.remove(m);
                    this._overlays.add(msg);
                    return;
                }
            }
            this._overlays.add(msg);
        } else {
            LOG.info("UpdateManager.addOverlay() - The message given wasn't good.");
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXException {
        if (!this.isMessageForMe(this._bufferMessage)) {
            if (this._bufferMessage != null) {
                LOG.info("UpdateMessageReader.endElement() Discarding message (os=" + this._bufferMessage.getOs() + ")");
            }
            this._bufferMessage = null;
            return;
        }
        if (this._bufferMessage != null && name.equalsIgnoreCase("message")) {
            if (this._bufferMessage.getMessageType().equalsIgnoreCase("update")) {
                LOG.info("UpdateMessageReader.endElement() Setting update message (os=" + this._bufferMessage.getOs() + ")");
                this.setUpdateMessage(this._bufferMessage);
            } else if (this._bufferMessage.getMessageType().equalsIgnoreCase("announcement")) {
                LOG.info("AUpdateMessageReader.endElement() adding announcement message " + String.valueOf(this._bufferMessage));
                this.addAnnouncement(this._bufferMessage);
            } else if (this._bufferMessage.getMessageType().equalsIgnoreCase("overlay")) {
                LOG.info("UpdateMessageReader.endElement() - addOverlay");
                this.addOverlay(this._bufferMessage);
            }
            this._bufferMessage = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
    }

    HashSet<UpdateMessage> getAnnouncements() {
        return this._announcements;
    }

    UpdateMessage getUpdateMessage() {
        return this._updateMessage;
    }

    private void setUpdateMessage(UpdateMessage msg) {
        if (this._updateMessage == null && msg != null && msg.getMessageType().equals("update")) {
            this._updateMessage = msg;
        }
    }

    boolean hasAnnouncements() {
        return this._announcements != null && this._announcements.size() > 0;
    }

    boolean hasUpdateMessage() {
        return this._updateMessage != null;
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    private boolean isMessageEligibleForMyLang(UpdateMessage msg) {
        String langInMsg = msg.getLanguage();
        if (langInMsg == null || langInMsg.equals("*")) {
            return true;
        }
        String langinapp = ApplicationSettings.getLanguage().toLowerCase();
        if (langInMsg.length() == 2) {
            return langinapp.toLowerCase().startsWith(langInMsg.toLowerCase());
        }
        if (langInMsg.endsWith("*")) {
            langinapp = ApplicationSettings.getLanguage().substring(0, 2);
            langInMsg = langInMsg.substring(0, langInMsg.indexOf("*"));
        }
        return langInMsg.equalsIgnoreCase(langinapp);
    }

    private boolean isMessageEligibleForMyOs(UpdateMessage msg) {
        if (msg.getOs() == null || "*".equals(msg.getOs())) {
            return true;
        }
        boolean im_mac_msg_for_me = msg.getOs().equals("mac." + OSUtils.getMacOSArchitecture()) && OSUtils.isMacOSX();
        boolean im_windows_msg_for_me = msg.getOs().equals("windows") && (OSUtils.isWindows() || OSUtils.isWindowsXP() || OSUtils.isWindowsNT() || OSUtils.isWindows98() || OSUtils.isWindows95() || OSUtils.isWindowsMe() || OSUtils.isWindowsVista());
        boolean im_linux_msg_for_me = msg.getOs().equals("linux") && OSUtils.isLinux();
        LOG.info("isMessageEligibleForMyOs(" + msg.getOs() + "): im_mac_msg_for_me=" + im_mac_msg_for_me + " || im_windows_msg_for_me=" + im_windows_msg_for_me + " || im_linux_msg_for_me=" + im_linux_msg_for_me);
        return im_mac_msg_for_me || im_windows_msg_for_me || im_linux_msg_for_me;
    }

    private boolean isMessageEligibleForMyVersion(UpdateMessage msg) {
        return msg.getVersion() == null || msg.getMessageType().equalsIgnoreCase("update") || !UpdateManager.isFrostWireOld(msg);
    }

    private boolean isMessageForMe(UpdateMessage msg) {
        if (msg == null) {
            return false;
        }
        return this.isMessageEligibleForMyOs(msg) && this.isMessageEligibleForMyLang(msg) && this.isMessageEligibleForMyVersion(msg);
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readUpdateFile() {
        URLConnection connection = null;
        try {
            String userAgent = "FrostWire/" + OSUtils.getOS() + "-" + OSUtils.getArchitecture() + "/" + FrostWireUtils.getFrostWireVersion() + "/build-" + FrostWireUtils.getBuildNumber();
            if (OSUtils.isAnyMac()) {
                userAgent = "FrostWire/" + OSUtils.getOS() + "-" + OSUtils.getMacOSArchitecture() + "/" + FrostWireUtils.getFrostWireVersion() + "/build-" + FrostWireUtils.getBuildNumber();
            }
            connection = (HttpURLConnection)new URI(DEFAULT_UPDATE_URL).toURL().openConnection();
            LOG.info("Reading update file from https://update.frostwire.com");
            connection.setRequestProperty("User-Agent", userAgent);
            connection.setRequestProperty("Connection", "close");
            connection.setReadTimeout(10000);
            int responseCode = ((HttpURLConnection)connection).getResponseCode();
            if (responseCode >= 400) {
                LOG.error("readUpdateFile(): Could not read update file, error code " + responseCode);
                ((HttpURLConnection)connection).disconnect();
                return;
            }
            InputSource src = new InputSource(connection.getInputStream());
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser saxParser = spf.newSAXParser();
            XMLReader rdr = saxParser.getXMLReader();
            rdr.setContentHandler(this);
            LOG.info("readUpdateFile(): got update file, about to parse");
            rdr.parse(src);
            LOG.info("readUpdateFile(): finished parsing");
        }
        catch (Throwable t) {
            System.err.println("UpdateMessageReader.readUpdateFile() " + t.getClass().getName() + " " + String.valueOf(t));
            t.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.getInputStream().close();
                    ((HttpURLConnection)connection).disconnect();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.equalsIgnoreCase("update")) {
            UpdateManager.getInstance().setServerTime(atts.getValue("time"));
            if (atts.getValue("torrentDetailsUrl") != null && atts.getValue("torrentDetailsUrl").length() > 0) {
                String torrentDetailsUrl = atts.getValue("torrentDetailsUrl");
                List<SearchEngine> searchEngines = SearchEngine.getEngines();
                for (SearchEngine searchEngine : searchEngines) {
                    searchEngine.setRedirectUrl(torrentDetailsUrl);
                }
            }
        } else if (localName.equalsIgnoreCase("message")) {
            String type = atts.getValue("type");
            String message = atts.getValue("value");
            String url = atts.getValue("url");
            String torrent = atts.getValue("torrent");
            String installerUrl = atts.getValue("installerUrl");
            String os = atts.getValue("os");
            String showOnce = atts.getValue("showOnce");
            String version = atts.getValue("version");
            String build = atts.getValue("build");
            String src = atts.getValue("src");
            String saveAs = atts.getValue("saveAs");
            this._bufferMessage = new UpdateMessage(type, message);
            this._bufferMessage.setUrl(url);
            this._bufferMessage.setTorrent(torrent);
            this._bufferMessage.setInstallerUrl(installerUrl);
            this._bufferMessage.setOs(os);
            this._bufferMessage.setShowOnce(showOnce);
            this._bufferMessage.setVersion(version);
            this._bufferMessage.setBuild(build);
            this._bufferMessage.setSaveAs(saveAs);
            if (atts.getValue("md5") != null) {
                this._bufferMessage.setRemoteMD5(atts.getValue("md5"));
            }
            if (atts.getValue("language") != null) {
                this._bufferMessage.setLanguage(atts.getValue("language"));
            }
            if (atts.getValue("valueInstallerReady") != null) {
                this._bufferMessage.setMessageInstallerReady(atts.getValue("valueInstallerReady"));
            }
            if (this._bufferMessage.getMessageType().equalsIgnoreCase("announcement")) {
                this._bufferMessage.setExpiration(atts.getValue("expiration"));
            }
            if (this._bufferMessage.getMessageType().equalsIgnoreCase("overlay")) {
                this._bufferMessage.setSrc(src);
                this._bufferMessage.setIntro(atts.getValue("intro") != null && (atts.getValue("intro").equals("1") || atts.getValue("intro").equalsIgnoreCase("true") || atts.getValue("intro").equalsIgnoreCase("yes")));
            }
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

