/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.updates;

import com.frostwire.gui.updates.UpdateManager;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;

final class UpdateMessage
implements Serializable {
    public static final long serialVersionUID = 44L;
    private int _hashCode = -1;
    private String _message;
    private String _messageInstallerReady;
    private String _url;
    private String _messageType;
    private String _version = null;
    private String build = null;
    private Date _expiration = null;
    private String _torrent = null;
    private String installerUrl = null;
    private String _os = null;
    private String _showOnce = "false";
    private String _src = "";
    private boolean _intro = false;
    private String _lang = "en";
    private String _md5 = "";
    private String _saveAs = null;

    UpdateMessage(String msgType, String message) {
        this.setMessageType(msgType);
        this.setMessage(message);
    }

    public String getMessage() {
        return this._message;
    }

    private void setMessage(String m) {
        this._message = m;
    }

    String getMessageInstallerReady() {
        return this._messageInstallerReady;
    }

    void setMessageInstallerReady(String m) {
        this._messageInstallerReady = m;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String u) {
        this._url = u;
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        this._src = src;
    }

    boolean isIntro() {
        return this._intro;
    }

    void setIntro(boolean intro) {
        this._intro = intro;
    }

    public String getLanguage() {
        return this._lang;
    }

    public void setLanguage(String lang) {
        this._lang = lang;
    }

    String getRemoteMD5() {
        return this._md5;
    }

    void setRemoteMD5(String md5) {
        this._md5 = md5.trim().toUpperCase();
    }

    String getMessageType() {
        return this._messageType;
    }

    private void setMessageType(String mt) {
        boolean typeIsValid;
        String type = mt != null ? mt.toLowerCase().trim() : "";
        boolean bl = typeIsValid = type.equals("update") || type.equals("announcement") || type.equals("overlay") || type.equals("chat_server") || type.equals("uxstats");
        if (mt == null || !typeIsValid) {
            this._messageType = "update";
            return;
        }
        this._messageType = mt.toLowerCase().trim();
    }

    public String getOs() {
        return this._os;
    }

    public void setOs(String os) {
        this._os = null;
        if (os != null) {
            if ((os = os.trim()).equalsIgnoreCase("windows") || os.equalsIgnoreCase("linux") || os.toLowerCase().startsWith("mac")) {
                this._os = os.toLowerCase();
            } else if (os.equals("*")) {
                this._os = null;
            }
        }
    }

    public String getTorrent() {
        return this._torrent;
    }

    public void setTorrent(String t) {
        this._torrent = t;
    }

    String getInstallerUrl() {
        return this.installerUrl;
    }

    void setInstallerUrl(String installerUrl) {
        this.installerUrl = installerUrl;
    }

    private Date getExpiration() {
        return this._expiration;
    }

    void setExpiration(String expTimestamp) {
        if (expTimestamp == null || expTimestamp.equals("0")) {
            this._expiration = null;
            return;
        }
        try {
            this._expiration = new Date(Long.parseLong(expTimestamp));
        }
        catch (NumberFormatException e) {
            System.out.println("Expiration passed cannot be converted to a long");
            this._expiration = null;
        }
    }

    boolean hasExpired() {
        if (this.getExpiration() == null) {
            return false;
        }
        long serverTimestamp = UpdateManager.getInstance().getServerTime().getTime();
        long myTimestamp = this._expiration.getTime();
        return myTimestamp < serverTimestamp;
    }

    public String getVersion() {
        if (this._version != null && this._version.equals("")) {
            this._version = null;
        }
        return this._version;
    }

    public void setVersion(String v) {
        this._version = v;
    }

    public String getBuild() {
        if (this.build != null && this.build.equals("")) {
            this.build = null;
        }
        return this.build;
    }

    public void setBuild(String b) {
        this.build = b;
    }

    boolean isShownOnce() {
        return this._showOnce.equalsIgnoreCase("true");
    }

    void setShowOnce(String s) {
        if (s != null) {
            this._showOnce = s;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof UpdateMessage && obj.hashCode() == this.hashCode() && this.isIntro() == ((UpdateMessage)obj).isIntro();
    }

    public int hashCode() {
        if (this._hashCode <= 0) {
            try {
                String byteString = this._message + this._url + this._messageType + this._version + this._torrent + this._os + this._showOnce;
                this._hashCode = byteString.hashCode();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this._hashCode;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    public String toString() {
        return "\nUpdateMessage @" + super.hashCode() + "{_hashCode : " + this.hashCode() + ", \n_message : " + this.getMessage() + ", \n_url : " + this.getUrl() + ", \n_messageType : " + this.getMessageType() + ", \n_version : " + this.getVersion() + ", \nbuild : " + this.getBuild() + ", \n_expiration : " + String.valueOf(this.getExpiration()) + ", \n_torrent : " + this.getTorrent() + ", \ninstallerUrl : " + this.getInstallerUrl() + ", \n_os : " + this.getOs() + ", \n_language : " + this.getLanguage() + ", \n_applanguage : " + ApplicationSettings.getLanguage() + ", \n_showOnce : " + this.isShownOnce() + ", \n_isIntro : " + this.isIntro() + ", \n_md5 : " + this.getRemoteMD5() + ", \n_saveAs : " + this.getSaveAs() + ", \n}\n";
    }

    public String getSaveAs() {
        return this._saveAs;
    }

    public void setSaveAs(String saveAs) {
        this._saveAs = saveAs;
    }
}

