/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.SkinColors;
import com.frostwire.gui.theme.ThemeMediator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.synth.SynthTreeUI;
import javax.swing.tree.TreePath;

public final class SkinTreeUI
extends SynthTreeUI {
    private SkinMouseListener mouseListener;

    public static ComponentUI createUI(JComponent comp) {
        ThemeMediator.testComponentCreationThreadingViolation();
        return new SkinTreeUI();
    }

    @Override
    protected CellRendererPane createCellRendererPane() {
        return new SkinCellRendererPane();
    }

    @Override
    protected MouseListener createMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = new SkinMouseListener(super.createMouseListener());
        }
        return this.mouseListener;
    }

    private void paintRowBackground(Graphics g, int x, int y, int w, int h) {
        try {
            TreePath path = this.getClosestPathForLocation(this.tree, 0, y);
            int row = this.treeState.getRowForPath(path);
            boolean selected = this.tree.isRowSelected(row);
            if (selected) {
                g.setColor(SkinColors.TABLE_SELECTED_BACKGROUND_ROW_COLOR);
            } else if (row % 2 == 1) {
                g.setColor(SkinColors.TABLE_ALTERNATE_ROW_COLOR);
            } else if (row % 2 == 0) {
                g.setColor(Color.WHITE);
            }
            g.fillRect(0, y, this.tree.getWidth(), h);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final class SkinCellRendererPane
    extends CellRendererPane {
        private SkinCellRendererPane() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean shouldValidate) {
            if (c == null) {
                if (p != null) {
                    Color oldColor = g.getColor();
                    g.setColor(p.getBackground());
                    g.fillRect(x, y, w, h);
                    g.setColor(oldColor);
                }
                return;
            }
            if (c.getParent() != this) {
                this.add(c);
            }
            c.setBounds(x, y, w, h);
            if (shouldValidate) {
                c.validate();
            }
            boolean wasDoubleBuffered = false;
            if (c instanceof JComponent && c.isDoubleBuffered()) {
                wasDoubleBuffered = true;
                ((JComponent)c).setDoubleBuffered(false);
            }
            SkinTreeUI.this.paintRowBackground(g, x, y, w, h);
            Graphics cg = g.create(x, y, w, h);
            try {
                c.paint(cg);
            }
            finally {
                cg.dispose();
            }
            if (wasDoubleBuffered && c instanceof JComponent) {
                ((JComponent)c).setDoubleBuffered(true);
            }
            c.setBounds(-w, -h, 0, 0);
        }
    }

    private final class SkinMouseListener
    implements MouseListener {
        private final MouseListener delegate;

        public SkinMouseListener(MouseListener delegate) {
            this.delegate = delegate;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.delegate.mouseClicked(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TreePath path = SkinTreeUI.this.getClosestPathForLocation(SkinTreeUI.this.tree, e.getX(), e.getY());
            if (path != null) {
                SkinTreeUI.this.tree.setSelectionPath(path);
            }
            this.delegate.mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.delegate.mouseReleased(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.delegate.mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.delegate.mouseExited(e);
        }
    }
}

