/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.AbstractSkinPainter;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.JComponent;

public final class SkinRadioButtonIconPainter
extends AbstractSkinPainter {
    private final Image image;

    public SkinRadioButtonIconPainter(State state) {
        this.image = this.getImage(this.getImageName(state));
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        g.drawImage(this.image, 0, 0, null);
    }

    private String getImageName(State state) {
        String imageName = null;
        switch (state) {
            case DisabledSelected: {
                imageName = "radio_btn_checked_disabled";
                break;
            }
            case Disabled: {
                imageName = "radio_btn_unchecked_disabled";
                break;
            }
            case Enabled: 
            case FocusedMouseOver: 
            case Focused: 
            case MouseOver: {
                imageName = "radio_btn_unchecked_active";
                break;
            }
            case FocusedMouseOverSelected: 
            case FocusedPressedSelected: 
            case FocusedPressed: 
            case FocusedSelected: 
            case MouseOverSelected: 
            case PressedSelected: 
            case Pressed: 
            case Selected: {
                imageName = "radio_btn_checked_active";
                break;
            }
            default: {
                throw new RuntimeException("Not supported state");
            }
        }
        return imageName;
    }

    public static enum State {
        DisabledSelected,
        Disabled,
        Enabled,
        FocusedMouseOverSelected,
        FocusedMouseOver,
        FocusedPressedSelected,
        FocusedPressed,
        FocusedSelected,
        Focused,
        MouseOverSelected,
        MouseOver,
        PressedSelected,
        Pressed,
        Selected;

    }
}

