/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.Border;

public final class SkinEtchedBorder
implements Border {
    private final Color color;
    private final Color bottomShadeColor;

    public SkinEtchedBorder(Color color) {
        this.color = color;
        this.bottomShadeColor = new Color(255, 255, 255, 150);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.color);
        g2d.drawRoundRect(x, y, width - 1, height - 2, 16, 16);
        g2d.setColor(this.bottomShadeColor);
        g2d.drawLine(x + 7, height - 1, width - 7, height - 1);
        g2d.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        float borderStrokeWidth = 2.0f;
        int prefSize = (int)Math.ceil(2.0 * (double)borderStrokeWidth);
        return new Insets(prefSize, prefSize, prefSize, prefSize);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

