/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.ShellFolderColumnInfo;
import com.frostwire.gui.theme.ShellFolderManager;
import java.awt.Image;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;

abstract class ShellFolder
extends File {
    private static ShellFolderManager shellFolderManager;
    protected ShellFolder parent;

    ShellFolder(ShellFolder parent, String pathname) {
        super(pathname != null ? pathname : "ShellFolder");
        this.parent = parent;
    }

    static ShellFolder getShellFolder(File file) throws FileNotFoundException {
        if (file instanceof ShellFolder) {
            return (ShellFolder)file;
        }
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        return shellFolderManager.createShellFolder(file);
    }

    public static Object get(String key) {
        return shellFolderManager.get(key);
    }

    private static boolean isFileSystemRoot(File dir) {
        return shellFolderManager.isFileSystemRoot(dir);
    }

    static File getNormalizedFile(File f) throws IOException {
        File canonical = f.getCanonicalFile();
        if (f.equals(canonical)) {
            return canonical;
        }
        return new File(f.toURI().normalize());
    }

    static ShellFolderColumnInfo[] getFolderColumns(File dir) {
        return shellFolderManager.getFolderColumns(dir);
    }

    static Object getFolderColumnValue(File file, int column) {
        return shellFolderManager.getFolderColumnValue(file, column);
    }

    boolean isFileSystem() {
        return !this.getPath().startsWith("ShellFolder");
    }

    protected abstract Object writeReplace();

    @Override
    public String getParent() {
        if (this.parent == null && this.isFileSystem()) {
            return super.getParent();
        }
        if (this.parent != null) {
            return this.parent.getPath();
        }
        return null;
    }

    @Override
    public File getParentFile() {
        if (this.parent != null) {
            return this.parent;
        }
        if (this.isFileSystem()) {
            return super.getParentFile();
        }
        return null;
    }

    @Override
    public File[] listFiles() {
        return this.listFiles(true);
    }

    public File[] listFiles(boolean includeHiddenFiles) {
        File[] files = super.listFiles();
        if (!includeHiddenFiles) {
            Vector<File> v = new Vector<File>();
            int nameCount = files == null ? 0 : files.length;
            for (int i2 = 0; i2 < nameCount; ++i2) {
                if (files[i2].isHidden()) continue;
                v.addElement(files[i2]);
            }
            files = v.toArray(new File[0]);
        }
        return files;
    }

    public abstract boolean isLink();

    public abstract String getDisplayName();

    @Override
    public int compareTo(File file2) {
        if (!(file2 instanceof ShellFolder) || file2 instanceof ShellFolder && ((ShellFolder)file2).isFileSystem()) {
            if (this.isFileSystem()) {
                return super.compareTo(file2);
            }
            return -1;
        }
        if (this.isFileSystem()) {
            return 1;
        }
        return this.getName().compareTo(file2.getName());
    }

    public Image getIcon() {
        return null;
    }

    @Override
    public boolean isAbsolute() {
        return !this.isFileSystem() || super.isAbsolute();
    }

    @Override
    public File getAbsoluteFile() {
        return this.isFileSystem() ? super.getAbsoluteFile() : this;
    }

    @Override
    public boolean canRead() {
        return !this.isFileSystem() || super.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.isFileSystem() && super.canWrite();
    }

    @Override
    public boolean exists() {
        return !this.isFileSystem() || ShellFolder.isFileSystemRoot(this) || super.exists();
    }

    @Override
    public boolean isDirectory() {
        return !this.isFileSystem() || super.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.isFileSystem() ? super.isFile() : !this.isDirectory();
    }

    @Override
    public long lastModified() {
        return this.isFileSystem() ? super.lastModified() : 0L;
    }

    @Override
    public long length() {
        return this.isFileSystem() ? super.length() : 0L;
    }

    @Override
    public boolean createNewFile() throws IOException {
        return this.isFileSystem() && super.createNewFile();
    }

    @Override
    public boolean delete() {
        return this.isFileSystem() && super.delete();
    }

    @Override
    public void deleteOnExit() {
        if (this.isFileSystem()) {
            super.deleteOnExit();
        }
    }

    @Override
    public boolean mkdir() {
        return this.isFileSystem() && super.mkdir();
    }

    @Override
    public boolean mkdirs() {
        return this.isFileSystem() && super.mkdirs();
    }

    @Override
    public boolean renameTo(File dest) {
        return this.isFileSystem() && super.renameTo(dest);
    }

    @Override
    public boolean setLastModified(long time) {
        return this.isFileSystem() && super.setLastModified(time);
    }

    @Override
    public boolean setReadOnly() {
        return this.isFileSystem() && super.setReadOnly();
    }

    @Override
    public String toString() {
        return this.isFileSystem() ? super.toString() : this.getDisplayName();
    }

    ShellFolderColumnInfo[] getFolderColumns() {
        return null;
    }

    Object getFolderColumnValue() {
        return null;
    }

    static {
        Class<ShellFolderManager> managerClass = ShellFolderManager.class;
        try {
            shellFolderManager = (ShellFolderManager)managerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new Error("Could not instantiate Shell Folder Manager: " + managerClass.getName());
        }
        catch (IllegalAccessException e) {
            throw new Error("Could not access Shell Folder Manager: " + managerClass.getName());
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

