/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;

public final class ShapeGenerator {
    private static final double baseRadius = 4.0;
    private final Path2D path = new Path2D.Double(0);
    private final Ellipse2D ellipse = new Ellipse2D.Float();

    public Shape createRectangle(int x, int y, int w, int h) {
        return this.createRoundRectangleInternal(x, y, w, h, 0.0, CornerStyle.SQUARE, CornerStyle.SQUARE, CornerStyle.SQUARE, CornerStyle.SQUARE);
    }

    Shape createRoundRectangle(int x, int y, int w, int h, CornerSize size) {
        return this.createRoundRectangle(x, y, w, h, size, CornerStyle.ROUNDED, CornerStyle.ROUNDED, CornerStyle.ROUNDED, CornerStyle.ROUNDED);
    }

    private Shape createRoundRectangle(int x, int y, int w, int h, CornerSize size, CornerStyle topLeft, CornerStyle bottomLeft, CornerStyle bottomRight, CornerStyle topRight) {
        return this.createRoundRectangleInternal(x, y, w, h, size.getRadius(w, h), topLeft, bottomLeft, bottomRight, topRight);
    }

    Shape createArrowLeft(double x, double y, double w, double h) {
        this.path.reset();
        this.path.moveTo(x + w, y);
        this.path.lineTo(x, y + h / 2.0);
        this.path.lineTo(x + w, y + h);
        this.path.closePath();
        return this.path;
    }

    Shape createProgressBarIndeterminatePattern(int x, int y, int w, int h) {
        double wHalf = (double)w / 2.0;
        double xOffset = 5.0;
        this.path.reset();
        this.path.moveTo(5.0, 0.0);
        this.path.lineTo(5.0 + wHalf, 0.0);
        this.path.curveTo(5.0 + wHalf - 5.0, h / 2 - 4, 5.0 + wHalf + 5.0, h / 2 + 4, 5.0 + wHalf, h);
        this.path.lineTo(5.0, h);
        this.path.curveTo(10.0, h / 2 + 4, 0.0, h / 2 - 4, 5.0, 0.0);
        this.path.closePath();
        return this.path;
    }

    public Shape createRadioButton(int x, int y, int diameter) {
        return this.createEllipseInternal(x, y, diameter, diameter);
    }

    private Shape createEllipseInternal(int x, int y, int w, int h) {
        this.ellipse.setFrame(x, y, w, h);
        return this.ellipse;
    }

    private Shape createRoundRectangleInternal(int x, int y, int w, int h, double radius, CornerStyle topLeft, CornerStyle bottomLeft, CornerStyle bottomRight, CornerStyle topRight) {
        int right = x + w;
        int bottom = y + h;
        this.path.reset();
        switch (topLeft) {
            case SQUARE: {
                this.path.moveTo(x, y);
                break;
            }
            case ROUNDED: {
                this.path.moveTo((double)x + radius, y);
                this.path.quadTo(x, y, x, (double)y + radius);
            }
        }
        switch (bottomLeft) {
            case SQUARE: {
                this.path.lineTo(x, bottom);
                break;
            }
            case ROUNDED: {
                this.path.lineTo(x, (double)bottom - radius);
                this.path.quadTo(x, bottom, (double)x + radius, bottom);
            }
        }
        switch (bottomRight) {
            case SQUARE: {
                this.path.lineTo(right, bottom);
                break;
            }
            case ROUNDED: {
                this.path.lineTo((double)right - radius, bottom);
                this.path.quadTo(right, bottom, right, (double)bottom - radius);
            }
        }
        switch (topRight) {
            case SQUARE: {
                this.path.lineTo(right, y);
                break;
            }
            case ROUNDED: {
                this.path.lineTo(right, (double)y + radius);
                this.path.quadTo(right, y, (double)right - radius, y);
            }
        }
        this.path.closePath();
        return this.path;
    }

    public static enum CornerStyle {
        SQUARE,
        ROUNDED;

    }

    public static enum CornerSize {
        ROUND_HEIGHT(0.0),
        ROUND_HEIGHT_DRAW(0.0),
        ROUND_WIDTH(0.0),
        ROUND_WIDTH_DRAW(0.0),
        INTERIOR(3.0),
        BORDER(4.0),
        INNER_FOCUS(5.0),
        OUTER_FOCUS(6.0),
        SLIDER_INTERIOR(2.0),
        SLIDER_BORDER(3.0),
        SLIDER_INNER_FOCUS(4.0),
        SLIDER_OUTER_FOCUS(5.0),
        CHECKBOX_INTERIOR(2.0),
        CHECKBOX_BORDER(2.5),
        CHECKBOX_INNER_FOCUS(3.0),
        CHECKBOX_OUTER_FOCUS(3.5),
        POPUP_BORDER(3.0),
        POPUP_INTERIOR(2.5),
        FRAME_BORDER(5.0),
        FRAME_INNER_HIGHLIGHT(4.0),
        FRAME_INTERIOR(3.0);

        private final double radius;

        private CornerSize(double radius) {
            this.radius = radius;
        }

        double getRadius(int w, int h) {
            switch (this) {
                case ROUND_HEIGHT: {
                    return (double)h / 2.0;
                }
                case ROUND_HEIGHT_DRAW: {
                    return (double)(h + 1) / 2.0;
                }
                case ROUND_WIDTH: {
                    return (double)w / 2.0;
                }
                case ROUND_WIDTH_DRAW: {
                    return (double)(w + 1) / 2.0;
                }
            }
            return this.radius;
        }
    }
}

