/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.ShapeGenerator;
import java.awt.Color;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.imageio.ImageIO;
import javax.swing.plaf.nimbus.AbstractRegionPainter;

public abstract class AbstractSkinPainter
extends AbstractRegionPainter {
    private static final String IMAGES_PATH = "org/limewire/gui/images/skin_";
    protected final ShapeGenerator shapeGenerator = new ShapeGenerator();

    protected AbstractSkinPainter() {
    }

    @Override
    protected final AbstractRegionPainter.PaintContext getPaintContext() {
        return null;
    }

    protected final Paint createVerticalGradient(Shape s, Color[] colors) {
        Rectangle2D bounds = s.getBounds2D();
        float xCenter = (float)bounds.getCenterX();
        float yMin = (float)bounds.getMinY();
        float yMax = (float)bounds.getMaxY();
        return this.createGradient(xCenter, yMin, xCenter, yMax, new float[]{0.0f, 1.0f}, colors);
    }

    private LinearGradientPaint createGradient(float x1, float y1, float x2, float y2, float[] midpoints, Color[] colors) {
        if (x1 == x2 && y1 == y2) {
            y2 += 1.0E-5f;
        }
        return new LinearGradientPaint(x1, y1, x2, y2, midpoints, colors);
    }

    protected final boolean testValid(int x, int y, int w, int h) {
        return x >= 0 && y >= 0 && w - x > 0 && h - y > 0;
    }

    final Image getImage(String name) {
        String imagePath = IMAGES_PATH + name + ".png";
        try {
            return ImageIO.read(ClassLoader.getSystemResource(imagePath));
        }
        catch (Throwable e) {
            throw new RuntimeException("Error loading skin image: " + imagePath, e);
        }
    }
}

