/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.searchfield;

import com.frostwire.gui.searchfield.JXSearchField;
import com.frostwire.gui.searchfield.NativeSearchFieldSupport;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class RecentSearches
implements ActionListener {
    private Preferences prefsNode;
    private final List<String> recentSearches = new ArrayList<String>();
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    RecentSearches(String saveName) {
        this(null, saveName);
    }

    private RecentSearches(Preferences prefs, String saveName) {
        if (prefs == null) {
            try {
                prefs = Preferences.userRoot();
            }
            catch (Throwable t) {
                Logger.getLogger(this.getClass().getName()).warning("cannot acces preferences. persistency disabled.");
            }
        }
        if (prefs != null && saveName != null) {
            this.prefsNode = prefs.node(saveName);
            this.load();
        }
    }

    private void load() {
        try {
            String[] recent = new String[this.prefsNode.keys().length];
            String[] stringArray = this.prefsNode.keys();
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String key;
                recent[this.prefsNode.getInt((String)key, (int)-1)] = key = stringArray[j];
            }
            this.recentSearches.addAll(Arrays.asList(recent));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void save() {
        if (this.prefsNode == null) {
            return;
        }
        try {
            this.prefsNode.clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        int i2 = 0;
        for (String search : this.recentSearches) {
            this.prefsNode.putInt(search, i2++);
        }
    }

    private void put(String searchString) {
        if (searchString == null || searchString.trim().length() == 0) {
            return;
        }
        int lastIndex = this.recentSearches.indexOf(searchString);
        if (lastIndex != -1) {
            this.recentSearches.remove(lastIndex);
        }
        this.recentSearches.add(0, searchString);
        if (this.getLength() > this.getMaxRecents()) {
            this.recentSearches.remove(this.recentSearches.size() - 1);
        }
        this.save();
        this.fireChangeEvent();
    }

    private String[] getRecentSearches() {
        return this.recentSearches.toArray(new String[0]);
    }

    private int getLength() {
        return this.recentSearches.size();
    }

    private void removeAll() {
        this.recentSearches.clear();
        this.save();
        this.fireChangeEvent();
    }

    private int getMaxRecents() {
        return 5;
    }

    private void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    private void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    private JPopupMenu createPopupMenu(JTextField searchField) {
        return new RecentSearchesPopup(this, searchField);
    }

    public void install(JTextField searchField) {
        searchField.addActionListener(this);
        NativeSearchFieldSupport.setFindPopupMenu(searchField, this.createPopupMenu(searchField));
    }

    void uninstall(JXSearchField searchField) {
        searchField.removeActionListener(this);
        if (searchField.getFindPopupMenu() instanceof RecentSearchesPopup) {
            this.removeChangeListener((ChangeListener)((Object)searchField.getFindPopupMenu()));
            searchField.setFindPopupMenu(null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.put(e.getActionCommand());
    }

    public static class RecentSearchesPopup
    extends JPopupMenu
    implements ActionListener,
    ChangeListener {
        private static final long serialVersionUID = 3389724537449677787L;
        private final RecentSearches recentSearches;
        private final JTextField searchField;
        private JMenuItem clear;

        RecentSearchesPopup(RecentSearches recentSearches, JTextField searchField) {
            this.searchField = searchField;
            this.recentSearches = recentSearches;
            recentSearches.addChangeListener(this);
            this.buildMenu();
        }

        private void buildMenu() {
            this.setVisible(false);
            this.removeAll();
            if (this.recentSearches.getLength() == 0) {
                JMenuItem noRecent = new JMenuItem(UIManager.getString("SearchField.noRecentsText"));
                noRecent.setEnabled(false);
                this.add(noRecent);
            } else {
                JMenuItem recent = new JMenuItem(UIManager.getString("SearchField.recentsMenuTitle"));
                recent.setEnabled(false);
                this.add(recent);
                for (String searchString : this.recentSearches.getRecentSearches()) {
                    JMenuItem mi = new JMenuItem(searchString);
                    mi.addActionListener(this);
                    this.add(mi);
                }
                this.addSeparator();
                this.clear = new JMenuItem(UIManager.getString("SearchField.clearRecentsText"));
                this.clear.addActionListener(this);
                this.add(this.clear);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.clear) {
                this.recentSearches.removeAll();
            } else {
                this.searchField.setText(e.getActionCommand());
                this.searchField.postActionEvent();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.buildMenu();
        }
    }
}

