/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.player;

import com.frostwire.concurrent.concurrent.ExecutorsHelper;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.tags.TagsReader;
import com.frostwire.gui.mplayer.MPlayer;
import com.frostwire.gui.player.MPlayerUIEventHandler;
import com.frostwire.gui.player.MPlayerUIEventListener;
import com.frostwire.gui.player.MediaPlayerLinux;
import com.frostwire.gui.player.MediaPlayerListener;
import com.frostwire.gui.player.MediaPlayerOSX;
import com.frostwire.gui.player.MediaPlayerWindows;
import com.frostwire.gui.player.MediaSource;
import com.frostwire.gui.player.RepeatMode;
import com.frostwire.gui.player.StreamMediaSource;
import com.frostwire.mp4.Box;
import com.frostwire.mp4.IsoFile;
import com.frostwire.mp4.MovieHeaderBox;
import com.frostwire.mplayer.MediaPlaybackState;
import com.frostwire.util.OSUtils;
import com.frostwire.util.StringUtils;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.settings.PlayerSettings;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.limewire.util.FileUtils;

public abstract class MediaPlayer
implements RefreshListener,
MPlayerUIEventListener {
    private static final String[] PLAYABLE_EXTENSIONS = new String[]{"mp3", "ogg", "wav", "wma", "wmv", "m4a", "aac", "flac", "mp4", "flv", "avi", "mov", "mkv", "mpg", "mpeg", "3gp", "m4v", "webm"};
    private static MediaPlayer instance;
    private final ExecutorService playExecutor;
    private final List<MediaPlayerListener> listenerList = new CopyOnWriteArrayList<MediaPlayerListener>();
    private final MPlayer mplayer;
    private MediaSource currentMedia;
    private MediaSource[] playlistFilesView;
    private RepeatMode repeatMode;
    private boolean shuffle;
    private boolean playNextMedia;
    private double volume;
    private final Queue<MediaSource> lastRandomFiles = new LinkedList<MediaSource>();
    private long durationInSeconds;
    private boolean isPlayPausedForSliding = false;
    private boolean stateNotificationsEnabled = true;

    MediaPlayer() {
        this.playExecutor = ExecutorsHelper.newProcessingQueue("AudioPlayer-PlayExecutor");
        String playerPath = this.getPlayerPath();
        MPlayer.initialize(new File(playerPath));
        this.mplayer = new MPlayer();
        this.mplayer.addPositionListener(this::notifyProgress);
        this.mplayer.addStateListener(newState -> {
            if (newState == MediaPlaybackState.Closed) {
                this.playNextMedia();
            }
        });
        this.mplayer.addIcyInfoListener(this::notifyIcyInfo);
        this.repeatMode = RepeatMode.values()[PlayerSettings.LOOP_PLAYLIST.getValue()];
        this.shuffle = PlayerSettings.SHUFFLE_PLAYLIST.getValue();
        this.playNextMedia = true;
        this.volume = PlayerSettings.PLAYER_VOLUME.getValue();
        this.notifyVolumeChanged();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(e -> {
            Component s;
            if (!(e.getID() != 401 || e.getKeyCode() != 32 || (s = e.getComponent()) instanceof JTextField || s instanceof JCheckBox || s instanceof JTable && ((JTable)s).isEditing())) {
                this.togglePause();
                return true;
            }
            return false;
        });
        MPlayerUIEventHandler.instance().addListener(this);
    }

    public static MediaPlayer instance() {
        if (instance == null) {
            if (OSUtils.isWindows()) {
                instance = new MediaPlayerWindows();
            } else if (OSUtils.isMacOSX()) {
                instance = new MediaPlayerOSX();
            } else if (OSUtils.isLinux()) {
                instance = new MediaPlayerLinux();
            }
        }
        return instance;
    }

    public static boolean isPlayableFile(File file) {
        return file.exists() && !file.isDirectory() && MediaPlayer.isPlayableFile(file.getAbsolutePath());
    }

    private static boolean isPlayableFile(String filename) {
        return FileUtils.hasExtension(filename, MediaPlayer.getPlayableExtensions());
    }

    public static String[] getPlayableExtensions() {
        return PLAYABLE_EXTENSIONS;
    }

    public static boolean isPlayableFile(MediaSource mediaSource) {
        if (mediaSource == null) {
            return false;
        }
        if (mediaSource.getFile() != null) {
            return mediaSource.getFile().exists() && MediaPlayer.isPlayableFile(mediaSource.getFile());
        }
        return mediaSource instanceof StreamMediaSource;
    }

    protected abstract String getPlayerPath();

    float getVolumeGainFactor() {
        return 100.0f;
    }

    public MediaSource getCurrentMedia() {
        return this.currentMedia;
    }

    public MediaSource[] getPlaylistFilesView() {
        return this.playlistFilesView;
    }

    public synchronized void setPlaylistFilesView(List<MediaSource> playlistFilesView) {
        this.playlistFilesView = playlistFilesView.toArray(new MediaSource[0]);
    }

    RepeatMode getRepeatMode() {
        return this.repeatMode;
    }

    void setRepeatMode(RepeatMode repeatMode) {
        this.repeatMode = repeatMode;
        PlayerSettings.LOOP_PLAYLIST.setValue(repeatMode.getValue());
    }

    boolean isShuffle() {
        return this.shuffle;
    }

    void setShuffle(boolean shuffle) {
        this.shuffle = shuffle;
        PlayerSettings.SHUFFLE_PLAYLIST.setValue(shuffle);
    }

    public void addMediaPlayerListener(MediaPlayerListener listener) {
        this.listenerList.add(listener);
    }

    public MediaPlaybackState getState() {
        return this.mplayer.getCurrentState();
    }

    private void loadMedia(MediaSource source2, boolean isPreview, boolean playNextSong, List<MediaSource> playlistFilesView) {
        try {
            if (source2 == null) {
                return;
            }
            MediaType mt = null;
            if (source2.isFile()) {
                mt = MediaType.getMediaTypeForExtension(FilenameUtils.getExtension(source2.getFile().getName()));
            } else if (source2.isURL()) {
                GUIMediator.instance().playInOS(source2);
                return;
            }
            if (mt != null && mt.equals(MediaType.getVideoMediaType())) {
                GUIMediator.instance().playInOS(source2);
                return;
            }
            if (!isPreview && PlayerSettings.USE_OS_DEFAULT_PLAYER.getValue()) {
                GUIMediator.instance().playInOS(source2);
                return;
            }
            this.currentMedia = source2;
            this.playNextMedia = playNextSong;
            this.playlistFilesView = playlistFilesView != null ? playlistFilesView.toArray(new MediaSource[0]) : null;
            this.durationInSeconds = -1L;
            if (this.currentMedia.getFile() != null) {
                TagsReader tagsReader = new TagsReader(this.currentMedia.getFile());
                LibraryMediator.instance().getLibraryCoverArtPanel().setTagsReader(tagsReader).asyncRetrieveImage();
                this.calculateDurationInSecs(this.currentMedia.getFile());
                this.playMedia();
            } else if (this.currentMedia instanceof StreamMediaSource) {
                LibraryMediator.instance().getLibraryCoverArtPanel().setDefault();
                this.playMedia();
            }
            this.notifyOpened(source2);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void calculateDurationInSecs(File f) {
        String ext = FilenameUtils.getExtension(f.getName());
        if (ext == null || !ext.toLowerCase().endsWith("mp3") || !ext.toLowerCase().endsWith("m4a")) {
            this.durationInSeconds = -1L;
            return;
        }
        if (ext.toLowerCase().endsWith("mp3")) {
            this.durationInSeconds = this.getDurationFromMP3(f);
        } else if (ext.toLowerCase().endsWith("m4a")) {
            this.durationInSeconds = this.getDurationFromM4A(f);
        }
    }

    private long getDurationFromMP3(File f) {
        try {
            return new TagsReader(f).parse().getDuration();
        }
        catch (Throwable e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getDurationFromM4A(File f) {
        try {
            RandomAccessFile isoFile;
            block6: {
                long l;
                isoFile = new RandomAccessFile(f, "r");
                LinkedList<Box> boxes = IsoFile.head(isoFile, ByteBuffer.allocate(102400));
                try {
                    MovieHeaderBox mvhd = (MovieHeaderBox)Box.findFirst(boxes, Box.mvhd);
                    if (mvhd == null) break block6;
                    l = mvhd.duration() / (long)mvhd.timescale();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(isoFile);
                    throw throwable;
                }
                IOUtils.closeQuietly(isoFile);
                return l;
            }
            IOUtils.closeQuietly(isoFile);
        }
        finally {
            return -1L;
        }
    }

    public void asyncLoadMedia(MediaSource source2, boolean playNextSong, List<MediaSource> playlistFilesView) {
        this.playExecutor.execute(() -> this.loadMedia(source2, false, playNextSong, playlistFilesView));
    }

    public void loadMedia(MediaSource source2, boolean isPreview, boolean playNextSong) {
        this.loadMedia(source2, isPreview, playNextSong, this.playlistFilesView != null ? Arrays.asList(this.playlistFilesView) : null);
    }

    public void asyncLoadMedia(MediaSource source2, boolean isPreview, boolean playNextSong) {
        this.playExecutor.execute(() -> this.loadMedia(source2, isPreview, playNextSong));
    }

    private String stopAndPrepareFilename() {
        String filename = "";
        try {
            this.mplayer.stop();
            this.setVolume(this.volume);
            if (this.currentMedia != null) {
                if (this.currentMedia.getFile() != null) {
                    filename = this.currentMedia.getFile().getAbsolutePath();
                } else if (this.currentMedia.getURL() != null) {
                    filename = this.currentMedia.getURL();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return filename;
    }

    private void playMedia() {
        String filename = this.stopAndPrepareFilename();
        if (filename.length() > 0) {
            this.mplayer.open(filename, this.getAdjustedVolume());
        }
        this.notifyState(this.getState());
    }

    void togglePause() {
        this.mplayer.togglePause();
        this.notifyState(this.getState());
    }

    public void stop() {
        this.mplayer.stop();
        this.currentMedia = null;
        this.notifyState(this.getState());
    }

    private void fastForward() {
        this.mplayer.fastForward();
    }

    private void rewind() {
        this.mplayer.rewind();
    }

    public void seek(float timeInSecs) {
        this.mplayer.seek(timeInSecs);
        this.notifyState(this.getState());
    }

    private int getAdjustedVolume() {
        return (int)(this.volume * (double)this.getVolumeGainFactor());
    }

    private double getVolume() {
        return this.volume;
    }

    public void setVolume(double fGain) {
        this.volume = Math.max(Math.min(fGain, 1.0), 0.0);
        this.mplayer.setVolume(this.getAdjustedVolume());
        PlayerSettings.PLAYER_VOLUME.setValue((float)this.volume);
        this.notifyVolumeChanged();
    }

    private void incrementVolume() {
        this.setVolume(this.getVolume() + 0.1);
    }

    private void decrementVolume() {
        this.setVolume(this.getVolume() - 0.1);
    }

    private void notifyVolumeChanged() {
        SwingUtilities.invokeLater(() -> this.fireVolumeChanged(this.volume));
    }

    private void notifyOpened(MediaSource mediaSource) {
        SwingUtilities.invokeLater(() -> this.fireOpened(mediaSource));
    }

    private void notifyState(MediaPlaybackState state) {
        if (this.stateNotificationsEnabled) {
            SwingUtilities.invokeLater(() -> this.fireState(state));
        }
    }

    private void notifyProgress(float currentTimeInSecs) {
        SwingUtilities.invokeLater(() -> this.fireProgress(currentTimeInSecs));
    }

    private void notifyIcyInfo(String data) {
        SwingUtilities.invokeLater(() -> this.fireIcyInfo(data));
    }

    private void fireOpened(MediaSource mediaSource) {
        for (MediaPlayerListener listener : this.listenerList) {
            listener.mediaOpened(this, mediaSource);
        }
    }

    private void fireProgress(float currentTimeInSecs) {
        for (MediaPlayerListener listener : this.listenerList) {
            listener.progressChange(this, currentTimeInSecs);
        }
    }

    private void fireVolumeChanged(double currentVolume) {
        for (MediaPlayerListener listener : this.listenerList) {
            listener.volumeChange(this, currentVolume);
        }
    }

    private void fireState(MediaPlaybackState state) {
        for (MediaPlayerListener listener : this.listenerList) {
            listener.stateChange(this, state);
        }
    }

    private void fireIcyInfo(String data) {
        for (MediaPlayerListener listener : this.listenerList) {
            listener.icyInfo(data);
        }
    }

    @Override
    public void refresh() {
        this.notifyState(this.getState());
    }

    void playNextMedia() {
        if (!this.playNextMedia) {
            return;
        }
        MediaSource media = this.getRepeatMode() == RepeatMode.SONG ? this.currentMedia : (this.isShuffle() ? this.getNextRandomSong(this.currentMedia) : (this.getRepeatMode() == RepeatMode.ALL ? this.getNextContinuousMedia(this.currentMedia) : this.getNextMedia(this.currentMedia)));
        if (media != null) {
            this.asyncLoadMedia(media, true, Arrays.asList(this.playlistFilesView));
        }
    }

    private boolean isPlayerStoppedClosedFailed() {
        MediaPlaybackState state = this.getState();
        return state == MediaPlaybackState.Stopped || state == MediaPlaybackState.Closed || state == MediaPlaybackState.Failed;
    }

    public boolean isThisBeingPlayed(File file) {
        if (this.isPlayerStoppedClosedFailed()) {
            return false;
        }
        MediaSource currentMedia = this.getCurrentMedia();
        if (currentMedia == null) {
            return false;
        }
        File currentMediaFile = currentMedia.getFile();
        return file.equals(currentMediaFile);
    }

    public boolean isThisBeingPlayed(String file) {
        if (StringUtils.isNullOrEmpty(file) || this.isPlayerStoppedClosedFailed()) {
            return false;
        }
        MediaSource currentMedia = this.getCurrentMedia();
        if (currentMedia == null) {
            return false;
        }
        String currentMediaUrl = currentMedia.getURL();
        return file.equalsIgnoreCase(currentMediaUrl);
    }

    private MediaSource getNextRandomSong(MediaSource currentMedia) {
        MediaSource songFile;
        if (this.playlistFilesView == null) {
            return null;
        }
        int count = 4;
        while ((songFile = this.findRandomMediaFile(currentMedia)) == null && count-- > 0) {
        }
        if (songFile != null) {
            if (count > 0) {
                this.lastRandomFiles.add(songFile);
                if (this.lastRandomFiles.size() > 3) {
                    this.lastRandomFiles.poll();
                }
            } else {
                songFile = currentMedia;
                this.lastRandomFiles.clear();
                this.lastRandomFiles.add(songFile);
            }
        }
        return songFile;
    }

    private MediaSource getNextContinuousMedia(MediaSource currentMedia) {
        if (this.playlistFilesView == null) {
            return null;
        }
        int n = this.playlistFilesView.length;
        if (n == 1) {
            return this.playlistFilesView[0];
        }
        for (int i2 = 0; i2 < n; ++i2) {
            try {
                MediaSource f1 = this.playlistFilesView[i2];
                if (!currentMedia.equals(f1)) continue;
                for (int j = 1; j < n; ++j) {
                    MediaSource file = this.playlistFilesView[(j + i2) % n];
                    if (!MediaPlayer.isPlayableFile(file)) continue;
                    return file;
                }
                continue;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private MediaSource getNextMedia(MediaSource currentMedia) {
        if (this.playlistFilesView == null) {
            return null;
        }
        int n = this.playlistFilesView.length;
        for (int i2 = 0; i2 < n; ++i2) {
            try {
                MediaSource f1 = this.playlistFilesView[i2];
                if (!currentMedia.equals(f1)) continue;
                for (int j = i2 + 1; j < n; ++j) {
                    MediaSource file = this.playlistFilesView[j];
                    if (!MediaPlayer.isPlayableFile(file)) continue;
                    return file;
                }
                continue;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    MediaSource getPreviousMedia(MediaSource currentMedia) {
        if (this.playlistFilesView == null) {
            return null;
        }
        int n = this.playlistFilesView.length;
        for (int i2 = 0; i2 < n; ++i2) {
            try {
                MediaSource f1 = this.playlistFilesView[i2];
                if (!currentMedia.equals(f1)) continue;
                for (int j = i2 - 1; j >= 0; --j) {
                    MediaSource file = this.playlistFilesView[j];
                    if (!MediaPlayer.isPlayableFile(file)) continue;
                    return file;
                }
                continue;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private MediaSource findRandomMediaFile(MediaSource excludeFile) {
        int index;
        if (this.playlistFilesView == null) {
            return null;
        }
        int n = this.playlistFilesView.length;
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return this.playlistFilesView[0];
        }
        for (int i2 = index = new Random(System.currentTimeMillis()).nextInt(n); i2 < n; ++i2) {
            try {
                MediaSource file = this.playlistFilesView[i2];
                if (this.lastRandomFiles.contains(file) || file.equals(excludeFile) || !MediaPlayer.isPlayableFile(file)) continue;
                return file;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    boolean canSeek() {
        if (this.durationInSeconds != -1L) {
            return this.durationInSeconds > 0L;
        }
        return this.mplayer.getDurationInSecs() > 0.0f;
    }

    public float getDurationInSecs() {
        if (this.durationInSeconds != -1L) {
            return this.durationInSeconds;
        }
        return this.mplayer.getDurationInSecs();
    }

    @Override
    public void onUIVolumeChanged(float volume) {
        this.setVolume(volume);
    }

    @Override
    public void onUISeekToTime(float seconds) {
        this.seek(seconds);
    }

    @Override
    public void onUIPlayPressed() {
        MediaPlaybackState curState = this.mplayer.getCurrentState();
        if (curState == MediaPlaybackState.Playing || curState == MediaPlaybackState.Paused) {
            this.togglePause();
        } else if (curState == MediaPlaybackState.Closed) {
            LibraryMediator.instance().playCurrentSelection();
        }
    }

    @Override
    public void onUIPausePressed() {
        this.togglePause();
    }

    @Override
    public void onUIFastForwardPressed() {
        this.fastForward();
    }

    @Override
    public void onUIRewindPressed() {
        this.rewind();
    }

    @Override
    public void onUIProgressSlideStart() {
        this.stateNotificationsEnabled = false;
        if (this.mplayer.getCurrentState() == MediaPlaybackState.Playing) {
            this.isPlayPausedForSliding = true;
            this.mplayer.pause();
        }
    }

    @Override
    public void onUIProgressSlideEnd() {
        if (this.isPlayPausedForSliding) {
            this.isPlayPausedForSliding = false;
            this.mplayer.play();
        }
        this.stateNotificationsEnabled = true;
    }

    @Override
    public void onUIVolumeIncremented() {
        this.incrementVolume();
    }

    @Override
    public void onUIVolumeDecremented() {
        this.decrementVolume();
    }
}

