/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.mplayer;

import com.frostwire.mplayer.Language;
import com.frostwire.mplayer.LanguageSource;
import com.frostwire.util.Logger;
import com.frostwire.util.OSUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.limewire.util.FileUtils;
import org.limewire.util.SystemUtils;

public class MPlayerInstance {
    private static final boolean LOG = true;
    private static final Logger LOGGER = Logger.getLogger(MPlayerInstance.class);
    private static File BINARY_PATH;
    volatile boolean activateNextSubtitleLoaded = false;
    private volatile Process mPlayerProcess;
    private boolean starting;
    private boolean started;
    private boolean stop_pending;
    private boolean stopped;
    private final AESemaphore stop_sem = new AESemaphore();
    private boolean paused;
    private final List<String> commands = new LinkedList<String>();
    private final AESemaphore command_sem = new AESemaphore();
    private boolean isSeeking;
    private int seekingTo;
    private volatile long seekingSendTime;
    private float nextSeek = -1.0f;
    private int pause_change_id_next;
    private boolean pause_reported;
    private long pause_reported_time = -1L;
    private int pending_sleeps;
    private int mute_count;
    private boolean redrawing;
    private long redraw_completion;
    private long redraw_last_frame;

    MPlayerInstance() {
    }

    static void initialize(File binary_path) {
        BINARY_PATH = binary_path;
        MPlayerInstance.killProcesses(false);
    }

    private static void killProcesses(boolean delay) {
        if (OSUtils.isAnyMac()) {
            String process_name = BINARY_PATH.getName();
            if (delay) {
                try {
                    Thread.sleep(250L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            MPlayerInstance.runCommand(new String[]{"killall", "-9", process_name});
        } else if (OSUtils.isWindows()) {
            String process_name = BINARY_PATH.getName();
            int pos = process_name.lastIndexOf(".");
            if (pos != -1) {
                process_name = process_name.substring(0, pos);
            }
            System.out.println("running tskill " + process_name);
            if (delay) {
                try {
                    Thread.sleep(250L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            MPlayerInstance.runCommand(new String[]{"cmd", "/C", "tskill", process_name});
        }
    }

    private static void runCommand(String[] command) {
        try {
            if (!OSUtils.isWindows()) {
                command[0] = MPlayerInstance.findCommand(command[0]);
            }
            Runtime.getRuntime().exec(command).waitFor();
        }
        catch (Throwable e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    private static String findCommand(String name) {
        String[] locations;
        for (String s : locations = new String[]{"/bin", "/usr/bin"}) {
            File f = new File(s, name);
            if (!f.exists() || !f.canRead()) continue;
            return f.getAbsolutePath();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doOpen(String fileOrUrl, int initialVolume, final OutputConsumer _outputConsumer) {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            if (this.starting || this.started) {
                throw new RuntimeException("no can do");
            }
            this.starting = true;
        }
        final OutputConsumer output_consumer = new OutputConsumer(){
            boolean latest = false;

            @Override
            public void consume(String output) {
                boolean is_paused = output.startsWith("ID_PAUSED");
                if (is_paused != this.latest) {
                    MPlayerInstance.this.updateObservedPaused(is_paused);
                    this.latest = is_paused;
                }
                _outputConsumer.consume(output);
            }
        };
        try {
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add(BINARY_PATH.getAbsolutePath());
            cmdList.add("-slave");
            if (fileOrUrl.toLowerCase().startsWith("http")) {
                cmdList.add("-cache");
                cmdList.add("64");
                cmdList.add("-cache-min");
                cmdList.add("50");
            }
            if (fileOrUrl.startsWith("https://")) {
                fileOrUrl = fileOrUrl.replace("https://", "ffmpeg://https://");
            }
            cmdList.add("-identify");
            cmdList.add("-prefer-ipv4");
            cmdList.add("-osdlevel");
            cmdList.add("0");
            cmdList.add("-noautosub");
            cmdList.add("-vo");
            if (OSUtils.isMacOSX()) {
                cmdList.add("corevideo:buffer_name=fwmplayer");
            } else if (OSUtils.isWindows()) {
                cmdList.add("direct3d,gl,directx,sdl");
            } else if (OSUtils.isLinux()) {
                cmdList.add("x11,gl,sdl");
            }
            if (OSUtils.isWindows()) {
                cmdList.add("-double");
                cmdList.add("-priority");
                cmdList.add("high");
                cmdList.add("-framedrop");
                if (FileUtils.hasExtension(fileOrUrl, "wma", "wmv", "asf")) {
                    cmdList.add("-demuxer");
                    cmdList.add("lavf");
                }
            }
            if (OSUtils.isLinux()) {
                cmdList.add("-double");
                cmdList.add("-framedrop");
            }
            cmdList.add("-volume");
            cmdList.add(String.valueOf(initialVolume));
            if (OSUtils.isLinux()) {
                cmdList.add("-zoom");
            }
            if (OSUtils.isMacOSX()) {
                cmdList.add(fileOrUrl);
            } else if (OSUtils.isWindows()) {
                if (fileOrUrl.length() > 250 && !fileOrUrl.toLowerCase().startsWith("http://") && !fileOrUrl.toLowerCase().startsWith("ffmpeg://")) {
                    String shortFileName = SystemUtils.getShortFileName(fileOrUrl);
                    if (shortFileName == null) {
                        shortFileName = fileOrUrl;
                    }
                    cmdList.add(String.format("\"%s\"", shortFileName));
                } else {
                    cmdList.add(String.format("\"%s\"", fileOrUrl));
                }
            } else if (OSUtils.isLinux()) {
                cmdList.add(fileOrUrl);
            }
            Object[] cmd = cmdList.toArray(new String[0]);
            String cmdString = Arrays.toString(cmd).replace(", ", " ");
            System.out.printf("starting mplayer: %s%n", cmdString);
            try {
                System.out.println("File Path: [" + (String)cmdList.get(cmdList.size() - 1) + "]");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ProcessBuilder pb = new ProcessBuilder((String[])cmd);
                this.mPlayerProcess = pb.start();
                InputStream stdOut = this.mPlayerProcess.getInputStream();
                InputStream stdErr = this.mPlayerProcess.getErrorStream();
                OutputStream stdIn = this.mPlayerProcess.getOutputStream();
                final BufferedReader brStdOut = new BufferedReader(new InputStreamReader(stdOut));
                final BufferedReader brStdErr = new BufferedReader(new InputStreamReader(stdErr));
                final PrintWriter pwStdIn = new PrintWriter(new OutputStreamWriter(stdIn));
                Thread stdOutReader = new Thread(this, "Player Console Out Reader"){

                    @Override
                    public void run() {
                        try {
                            String line;
                            while ((line = brStdOut.readLine()) != null) {
                                output_consumer.consume(line);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                stdOutReader.setDaemon(true);
                stdOutReader.start();
                Thread stdErrReader = new Thread(this, "Player Console Err Reader"){

                    @Override
                    public void run() {
                        try {
                            String line;
                            while ((line = brStdErr.readLine()) != null) {
                                output_consumer.consume(line);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                stdErrReader.setDaemon(true);
                stdErrReader.start();
                Thread stdInWriter = new Thread("Player Console In Writer"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            while (true) {
                                String toBeSent;
                                MPlayerInstance.this.command_sem.reserve();
                                MPlayerInstance mPlayerInstance = MPlayerInstance.this;
                                synchronized (mPlayerInstance) {
                                    if (MPlayerInstance.this.commands.isEmpty()) {
                                        break;
                                    }
                                    toBeSent = MPlayerInstance.this.commands.remove(0);
                                }
                                System.out.println("-> " + toBeSent);
                                if (toBeSent.startsWith("sleep ") || toBeSent.startsWith("pausing_keep_force sleep ")) {
                                    int millis = Integer.parseInt(toBeSent.substring(toBeSent.startsWith("p") ? 25 : 6));
                                    try {
                                        Thread.sleep(millis);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    MPlayerInstance mPlayerInstance2 = MPlayerInstance.this;
                                    synchronized (mPlayerInstance2) {
                                        MPlayerInstance.this.pending_sleeps -= millis;
                                    }
                                }
                                if (toBeSent.startsWith("seek") || toBeSent.startsWith("pausing_keep_force seek")) {
                                    MPlayerInstance.this.seekingSendTime = SystemTime.getMonotonousTime();
                                }
                                toBeSent = toBeSent.replaceAll("\\\\", "\\\\\\\\");
                                pwStdIn.write(toBeSent + "\n");
                                pwStdIn.flush();
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        finally {
                            MPlayerInstance.this.stop_sem.releaseForever();
                        }
                    }
                };
                stdInWriter.setDaemon(true);
                stdInWriter.start();
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.stop_sem.releaseForever();
            }
        }
        finally {
            MPlayerInstance mPlayerInstance2 = this;
            synchronized (mPlayerInstance2) {
                this.starting = false;
                this.started = true;
                if (this.stop_pending) {
                    this.doStop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommand(String cmd, CommandPauseMode pauseMode) {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            if (this.stopped) {
                return;
            }
            String prefix = "";
            if (CommandPauseMode.KEEP_FORCE == pauseMode) {
                prefix = "pausing_keep_force ";
            } else if (CommandPauseMode.KEEP == pauseMode) {
                prefix = "pausing_keep ";
            }
            this.commands.add(prefix + cmd);
            this.command_sem.release();
        }
    }

    private void sendCommand(String cmd) {
        this.sendCommand(cmd, CommandPauseMode.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialised() {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            this.sendCommand("get_property LENGTH");
            this.sendCommand("get_property SUB");
            this.sendCommand("get_property ASPECT");
            this.sendCommand("get_property WIDTH");
            this.sendCommand("get_property HEIGHT");
            this.sendCommand("get_property VOLUME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateObservedPaused(boolean r_paused) {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            this.pause_reported = r_paused;
            this.pause_reported_time = SystemTime.getMonotonousTime();
        }
    }

    private void pausedStateChanging() {
        int delay = 333;
        this.pause_reported_time = -1L;
        final int pause_change_id = ++this.pause_change_id_next;
        SimpleTimer.addEvent("MP:PO", SystemTime.getOffsetTime(333 + this.pending_sleeps), new TimerEventPerformer(){
            int level = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent event) {
                MPlayerInstance mPlayerInstance = MPlayerInstance.this;
                synchronized (mPlayerInstance) {
                    if (!MPlayerInstance.this.stopped && pause_change_id == MPlayerInstance.this.pause_change_id_next && this.level < 20) {
                        ++this.level;
                        if (MPlayerInstance.this.pause_reported_time >= 0L && MPlayerInstance.this.pause_reported == MPlayerInstance.this.paused) {
                            return;
                        }
                        MPlayerInstance.this.sendCommand("pause", CommandPauseMode.NONE);
                        SimpleTimer.addEvent("MP:PO2", SystemTime.getOffsetTime(333 + MPlayerInstance.this.pending_sleeps), this);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doPause() {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            if (this.paused) {
                return;
            }
            this.paused = true;
            this.pausedStateChanging();
            this.sendCommand("pause", CommandPauseMode.NONE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doResume() {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            if (!this.paused) {
                return;
            }
            this.paused = false;
            this.pausedStateChanging();
            this.sendCommand("pause", CommandPauseMode.NONE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSeek(float timeInSecs) {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            if (this.isSeeking) {
                this.nextSeek = timeInSecs;
            } else {
                int value;
                this.isSeeking = true;
                this.nextSeek = -1.0f;
                this.seekingTo = value = (int)timeInSecs;
                this.seekingSendTime = -1L;
                this.sendCommand("seek " + value + " 2", CommandPauseMode.KEEP);
                this.sendCommand("get_time_pos", CommandPauseMode.KEEP);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void positioned(float time) {
        long now = SystemTime.getMonotonousTime();
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            if (this.seekingSendTime == -1L) {
                return;
            }
            if (this.isSeeking && time >= (float)this.seekingTo && (now - this.seekingSendTime > 1000L || time - (float)this.seekingTo <= 2.0f)) {
                this.positioned();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void positioned() {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            if (this.isSeeking) {
                this.isSeeking = false;
                this.seekingSendTime = -1L;
                if (this.nextSeek != -1.0f) {
                    this.doSeek(this.nextSeek);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSetVolume(int volume) {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            CommandPauseMode pauseMode = this.paused ? CommandPauseMode.KEEP_FORCE : CommandPauseMode.NONE;
            this.sendCommand("volume " + volume + " 1", pauseMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doMute(boolean on) {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            if (on) {
                ++this.mute_count;
                if (this.mute_count == 1) {
                    this.sendCommand("mute 1");
                }
            } else {
                --this.mute_count;
                if (this.mute_count == 0) {
                    if (this.paused) {
                        this.nextSeek = -1.0f;
                        this.pending_sleeps += 100;
                        this.sendCommand("sleep 100");
                    }
                    this.sendCommand("mute 0");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAudioTrack(Language language) {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            if (language != null) {
                this.sendCommand("switch_audio " + language.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRedraw() {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            int delay = 250;
            long now = SystemTime.getMonotonousTime();
            this.redraw_completion = now + 250L;
            if (this.redrawing) {
                if (now - this.redraw_last_frame > 250L) {
                    this.redraw_last_frame = now;
                    this.sendCommand("frame_step", CommandPauseMode.NONE);
                }
            } else {
                this.doMute(true);
                this.redraw_last_frame = now;
                this.sendCommand("frame_step", CommandPauseMode.NONE);
                this.redrawing = true;
                SimpleTimer.addEvent("MP:RD", SystemTime.getOffsetTime(250L), new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent event) {
                        MPlayerInstance mPlayerInstance = MPlayerInstance.this;
                        synchronized (mPlayerInstance) {
                            long now = SystemTime.getMonotonousTime();
                            long diff = MPlayerInstance.this.redraw_completion - now;
                            if (diff < 0L || Math.abs(diff) <= 25L) {
                                MPlayerInstance.this.redrawing = false;
                                MPlayerInstance.this.doMute(false);
                            } else {
                                SimpleTimer.addEvent("MP:RD", SystemTime.getOffsetTime(diff), this);
                            }
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String setSubtitles(Language language) {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            String langId;
            String commandName = "sub_demux ";
            if (language != null) {
                langId = language.getId();
                if (language.getSource() == LanguageSource.FILE) {
                    commandName = "sub_file ";
                }
            } else {
                this.sendCommand("set_property sub_visibility 0");
                return null;
            }
            this.sendCommand("set_property sub_visibility 1");
            this.sendCommand(commandName + langId);
            return langId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doLoadSubtitlesFile(String file, boolean autoPlay) {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            this.activateNextSubtitleLoaded = autoPlay;
            this.sendCommand("sub_load \"" + file + "\"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStop() {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            if (this.starting) {
                this.stop_pending = true;
                return;
            }
            if (this.stopped) {
                return;
            }
            this.sendCommand("stop");
            this.sendCommand("quit 0");
            this.stopped = true;
        }
        this.command_sem.release();
        if (this.mPlayerProcess != null) {
            this.mPlayerProcess.destroy();
        }
        MPlayerInstance.killProcesses(true);
        this.stop_sem.reserve();
    }

    void doGetProperties(String fileOrUrl, OutputConsumer _outputConsumer) {
        final OutputConsumer output_consumer = _outputConsumer::consume;
        final CountDownLatch signal = new CountDownLatch(1);
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(BINARY_PATH.getAbsolutePath());
        cmdList.add("-slave");
        cmdList.add("-identify");
        cmdList.add("-prefer-ipv4");
        cmdList.add("-osdlevel");
        cmdList.add("0");
        cmdList.add("-noautosub");
        cmdList.add("-vo");
        cmdList.add("null");
        cmdList.add("-ao");
        cmdList.add("null");
        cmdList.add("-frames");
        cmdList.add("0");
        cmdList.add(fileOrUrl);
        String[] cmd = cmdList.toArray(new String[0]);
        try {
            InputStream stdOut = Runtime.getRuntime().exec(cmd).getInputStream();
            final BufferedReader brStdOut = new BufferedReader(new InputStreamReader(stdOut));
            Thread stdOutReader = new Thread(this, "Player Console Out Reader"){

                @Override
                public void run() {
                    try {
                        String line;
                        while ((line = brStdOut.readLine()) != null) {
                            if (line.startsWith("ID_EXIT")) {
                                signal.countDown();
                                break;
                            }
                            output_consumer.consume(line);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            stdOutReader.setDaemon(true);
            stdOutReader.start();
            signal.await(5L, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void printCommand(String[] cmd) {
        for (String s : cmd) {
            if (s.contains(" ")) {
                System.out.print("\"");
            }
            System.out.print(s);
            if (s.contains(" ")) {
                System.out.print("\"");
            }
            System.out.print(" ");
        }
        System.out.println("\n");
    }

    static interface OutputConsumer {
        public void consume(String var1);
    }

    public static enum CommandPauseMode {
        NONE,
        KEEP,
        KEEP_FORCE;

    }
}

