/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.mplayer;

import com.frostwire.gui.mplayer.MPlayerInstance;
import com.frostwire.mplayer.BaseMediaPlayer;
import com.frostwire.mplayer.IcyInfoListener;
import com.frostwire.mplayer.Language;
import com.frostwire.mplayer.LanguageSource;
import com.frostwire.mplayer.MediaPlaybackState;
import com.frostwire.mplayer.MetaDataListener;
import com.frostwire.mplayer.PlayerPreferences;
import com.frostwire.mplayer.PositionListener;
import com.frostwire.mplayer.StateListener;
import com.frostwire.mplayer.VolumeListener;
import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.Logger;
import com.frostwire.util.http.HttpClient;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MPlayer
extends BaseMediaPlayer {
    private static final String ANS_LENGTH = "ANS_LENGTH=";
    private static final String ANS_POSITION = "ANS_TIME_POSITION=";
    private static final String ANS_VOLUME = "ANS_VOLUME=";
    private static final String ANS_SUB = "ANS_SUB=";
    private static final String ANS_WIDTH = "ANS_WIDTH=";
    private static final String ANS_HEIGHT = "ANS_HEIGHT=";
    private static final String ANS_ASPECT = "ANS_ASPECT=";
    private static final String ID_AUDIO_ID = "ID_AUDIO_ID=";
    private static final String ID_SUBTITLE_ID = "ID_SUBTITLE_ID=";
    private static final String ID_AUDIO_TRACK = "ID_AUDIO_TRACK=";
    private static final String ID_SUBTITLE_TRACK = "ID_SUBTITLE_TRACK=";
    private static final String ID_FILE_SUB_ID = "ID_FILE_SUB_ID=";
    private static final String ID_FILE_SUB_FILENAME = "ID_FILE_SUB_FILENAME=";
    private static final String ID_EXIT = "ID_EXIT=";
    private static final String ICY_INFO = "ICY Info:";
    private static final Pattern v_timeInfo = Pattern.compile("A:\\s*([0-9\\.]+) V:\\s*[0-9\\.]* .*");
    private static final Pattern a_timeInfo = Pattern.compile("A:\\s*([0-9\\.]+) .*");
    private static final Logger LOG = Logger.getLogger(MPlayer.class);
    public static final String ID_AID = "ID_AID_";
    public static final String NAME = "_NAME=";
    public static final String LANG = "_LANG=";
    public static final String ID_SID = "ID_SID_";
    public static final String ID_ = "ID_";
    public static final String ID_CLIP_INFO_VALUE = "ID_CLIP_INFO_VALUE";
    public static final String ID_CLIP_INFO_NAME = "ID_CLIP_INFO_NAME";
    private final List<String> output = new LinkedList<String>();
    private volatile boolean disposed = false;
    private boolean firstLengthReceived = false;
    private boolean firstVolumeReceived = false;
    private MPlayerInstance currentInstance;
    private boolean parsingLanguage;
    private boolean isAudioTrack;
    private Language language;
    private int width;
    private float aspect;
    private MetaDataListener metaDataListener;
    private StateListener stateListener;
    private VolumeListener volumeListener;
    private PositionListener positionListener;
    private IcyInfoListener icyInfoListener;

    public MPlayer() {
        this(null);
    }

    private MPlayer(PlayerPreferences preferences) {
        super(preferences);
        Thread outputParser = new Thread("MPlayer output parser"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block7: while (true) {
                    try {
                        while (!MPlayer.this.disposed) {
                            String line = null;
                            List<String> list = MPlayer.this.output;
                            synchronized (list) {
                                if (!MPlayer.this.output.isEmpty()) {
                                    line = MPlayer.this.output.remove(0);
                                } else {
                                    MPlayer.this.output.wait();
                                }
                            }
                            if (line == null) continue;
                            try {
                                MPlayer.this.parseOutput(line);
                                continue block7;
                            }
                            catch (Throwable e) {
                                LOG.error(e.getMessage(), e);
                            }
                        }
                        break;
                    }
                    catch (Throwable e) {
                        LOG.error(e.getMessage(), e);
                        break;
                    }
                }
            }
        };
        outputParser.setDaemon(true);
        outputParser.start();
    }

    public static void initialize(File path) {
        MPlayerInstance.initialize(path);
    }

    private void parseOutput(String line) {
        boolean stillParsing;
        block82: {
            stillParsing = false;
            Matcher vMatcher = v_timeInfo.matcher(line);
            Matcher aMatcher = a_timeInfo.matcher(line);
            if (vMatcher.matches()) {
                float time = Float.parseFloat(vMatcher.group(1));
                MPlayerInstance instance = this.getCurrentInstance();
                if (instance != null) {
                    instance.positioned(time);
                }
                this.reportPosition(time);
            } else if (aMatcher.matches()) {
                float time = Float.parseFloat(aMatcher.group(1));
                MPlayerInstance instance = this.getCurrentInstance();
                if (instance != null) {
                    instance.positioned(time);
                }
                this.reportPosition(time);
            } else if (line.startsWith("Starting playback...")) {
                this.stateListener.stateChanged(MediaPlaybackState.Playing);
                MPlayerInstance instance = this.getCurrentInstance();
                if (instance != null) {
                    instance.initialised();
                }
                this.reportNewState(MediaPlaybackState.Playing);
            } else if (line.startsWith(ANS_POSITION)) {
                try {
                    MPlayerInstance instance = this.getCurrentInstance();
                    if (instance != null) {
                        instance.positioned();
                    }
                    float position = Float.parseFloat(line.substring(ANS_POSITION.length()));
                    this.reportPosition(position);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (line.startsWith(ANS_LENGTH)) {
                try {
                    float duration = Float.parseFloat(line.substring(ANS_LENGTH.length()));
                    if (!this.firstLengthReceived) {
                        float seekTo;
                        this.firstLengthReceived = true;
                        if (this.preferences != null && (seekTo = this.preferences.getPositionForFile(this.getOpenedFile()) - 2.0f) > 0.0f && (double)seekTo < 0.99 * (double)duration && seekTo < duration - 20.0f) {
                            this.doSeek(seekTo);
                        }
                    }
                    this.reportDuration(duration);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (line.startsWith(ANS_VOLUME)) {
                try {
                    int volume = (int)Float.parseFloat(line.substring(ANS_VOLUME.length()));
                    this.reportVolume(volume);
                    if (this.firstVolumeReceived) break block82;
                    this.firstVolumeReceived = true;
                    if (this.preferences != null && this.preferences.getVolume() != volume) {
                        this.setVolume(this.preferences.getVolume());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (line.startsWith(ANS_WIDTH)) {
                try {
                    this.width = Integer.parseInt(line.substring(ANS_WIDTH.length()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (line.startsWith(ANS_HEIGHT)) {
                try {
                    int videoWidth = this.width;
                    int videoHeight = Integer.parseInt(line.substring(ANS_HEIGHT.length()));
                    int displayWidth = videoWidth;
                    if (this.aspect > 0.0f && this.abs(this.aspect - (float)videoWidth / (float)videoHeight) > 0.1) {
                        displayWidth = (int)((float)videoHeight * this.aspect);
                    }
                    if (this.metaDataListener != null) {
                        this.metaDataListener.receivedVideoResolution(videoWidth, videoHeight);
                        this.metaDataListener.receivedDisplayResolution(displayWidth, videoHeight);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (line.startsWith(ANS_ASPECT)) {
                try {
                    this.aspect = Float.parseFloat(line.substring(ANS_ASPECT.length()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (line.startsWith(ID_AUDIO_ID)) {
                this.reportParsingDone();
                try {
                    String audioId = line.substring(ID_AUDIO_ID.length());
                    this.language = new Language(LanguageSource.STREAM, audioId);
                    this.parsingLanguage = true;
                    this.isAudioTrack = true;
                    stillParsing = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (line.startsWith(ID_SUBTITLE_ID)) {
                this.reportParsingDone();
                try {
                    String audioId = line.substring(ID_SUBTITLE_ID.length());
                    this.language = new Language(LanguageSource.STREAM, audioId);
                    this.parsingLanguage = true;
                    this.isAudioTrack = false;
                    stillParsing = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (line.startsWith(ID_FILE_SUB_ID)) {
                this.reportParsingDone();
                try {
                    String subId = line.substring(ID_FILE_SUB_ID.length());
                    this.language = new Language(LanguageSource.FILE, subId);
                    this.parsingLanguage = true;
                    this.isAudioTrack = false;
                    stillParsing = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (this.parsingLanguage && line.startsWith(ID_FILE_SUB_FILENAME)) {
                try {
                    String fileName = line.substring(ID_FILE_SUB_FILENAME.length());
                    try {
                        File f = new File(fileName);
                        this.language.setSourceInfo(f.getAbsolutePath());
                        fileName = f.getName();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.language.setName(fileName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (this.parsingLanguage && (line.startsWith(ID_AID + this.language.getId() + NAME) || line.startsWith(ID_SID + this.language.getId() + NAME))) {
                String key = ID_AID + this.language.getId() + NAME;
                String name = line.substring(key.length());
                this.language.setName(name);
                stillParsing = true;
            } else if (this.parsingLanguage && (line.startsWith(ID_AID + this.language.getId() + LANG) || line.startsWith(ID_SID + this.language.getId() + LANG))) {
                String key = ID_AID + this.language.getId() + LANG;
                String isoCode = line.substring(key.length());
                this.language.setLanguage(isoCode);
                stillParsing = true;
            } else if (this.parsingLanguage && (line.startsWith(ID_AID + this.language.getId()) || line.startsWith(ID_SID + this.language.getId()))) {
                stillParsing = true;
            } else if (line.startsWith(ID_AUDIO_TRACK)) {
                try {
                    String audioId = line.substring(ID_AUDIO_TRACK.length());
                    this.reportAudioTrackChanged(audioId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (line.startsWith(ID_SUBTITLE_TRACK)) {
                try {
                    String subtitleId = line.substring(ID_SUBTITLE_TRACK.length());
                    this.reportSubtitleChanged(subtitleId, LanguageSource.STREAM);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (line.startsWith(ANS_SUB)) {
                try {
                    String subtitleId = line.substring(ANS_SUB.length());
                    this.reportSubtitleChanged(subtitleId, LanguageSource.STREAM);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (line.startsWith("<vo_direct3d>Reading display capabilities failed")) {
                this.reportNewState(MediaPlaybackState.Failed);
            } else if (line.startsWith(ID_EXIT)) {
                this.reportNewState(MediaPlaybackState.Closed);
            } else if (line.startsWith(ICY_INFO)) {
                String data = line.substring(ICY_INFO.length()).trim();
                this.reportIcyInfo(data);
            }
        }
        if (this.parsingLanguage && !stillParsing) {
            Language parsed = this.language;
            this.reportParsingDone();
            MPlayerInstance instance = this.getCurrentInstance();
            if (instance != null && instance.activateNextSubtitleLoaded) {
                instance.activateNextSubtitleLoaded = false;
                this.setSubtitles(parsed);
            }
        }
    }

    private double abs(float f) {
        return f > 0.0f ? (double)f : (double)(-f);
    }

    @Override
    public void doLoadSubtitlesFile(String file, boolean autoPlay) {
        MPlayerInstance instance = this.getCurrentInstance();
        if (instance != null) {
            instance.doLoadSubtitlesFile(file, autoPlay);
        }
    }

    private void reportSubtitleChanged(String subtitleId, LanguageSource source2) {
        if (this.metaDataListener != null) {
            this.metaDataListener.activeSubtitleChanged(subtitleId, source2);
        }
    }

    private void reportAudioTrackChanged(String audioId) {
        if (this.metaDataListener != null) {
            this.metaDataListener.activeAudioTrackChanged(audioId);
        }
    }

    private void reportParsingDone() {
        if (this.parsingLanguage) {
            if (this.isAudioTrack) {
                this.reportFoundAudioTrack(this.language);
            } else {
                this.reportFoundSubtitle(this.language);
            }
            this.language = null;
            this.parsingLanguage = false;
            this.isAudioTrack = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doOpen(String fileOrUrl, int initialVolume) {
        MPlayerInstance instance;
        MPlayer mPlayer = this;
        synchronized (mPlayer) {
            this.doStop(false);
            instance = this.currentInstance = new MPlayerInstance();
        }
        this.reportNewState(MediaPlaybackState.Opening);
        this.firstLengthReceived = false;
        this.firstVolumeReceived = false;
        if (fileOrUrl.startsWith("http://") || fileOrUrl.startsWith("https://")) {
            HttpClient httpClient = HttpClientFactory.getInstance(HttpClientFactory.HttpContext.MISC);
            HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
            try {
                int responseCode = httpClient.head(fileOrUrl, 5000, responseHeaders);
                if (responseCode == 302 && responseHeaders.containsKey("Location") && ((List)responseHeaders.get("Location")).get(0) != null) {
                    fileOrUrl = (String)((List)responseHeaders.get("Location")).get(0);
                }
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), e);
            }
        }
        instance.doOpen(fileOrUrl, initialVolume, line -> {
            List<String> list = this.output;
            synchronized (list) {
                this.output.add(line);
                this.output.notifyAll();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MPlayerInstance getCurrentInstance() {
        MPlayer mPlayer = this;
        synchronized (mPlayer) {
            return this.currentInstance;
        }
    }

    @Override
    public void doPause() {
        MPlayerInstance instance = this.getCurrentInstance();
        if (instance != null) {
            instance.doPause();
        }
        this.reportNewState(MediaPlaybackState.Paused);
    }

    @Override
    public void doResume() {
        MPlayerInstance instance = this.getCurrentInstance();
        if (instance != null) {
            instance.doResume();
        }
        this.reportNewState(MediaPlaybackState.Playing);
    }

    @Override
    public void doSeek(float timeInSecs) {
        MPlayerInstance instance = this.getCurrentInstance();
        if (instance != null) {
            instance.doSeek(timeInSecs);
        }
    }

    @Override
    public void doSetVolume(int volume) {
        MPlayerInstance instance = this.getCurrentInstance();
        if (instance != null) {
            instance.doSetVolume(volume);
        }
        this.reportVolume(volume);
    }

    private void setSubtitles(Language language) {
        MPlayerInstance instance = this.getCurrentInstance();
        if (instance != null) {
            this.reportSubtitleChanged(instance.setSubtitles(language), language != null ? language.getSource() : null);
        }
    }

    @Override
    public void doStop() {
        this.doStop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStop(boolean report_state) {
        MPlayer mPlayer = this;
        synchronized (mPlayer) {
            if (this.currentInstance != null) {
                if (this.preferences != null) {
                    this.preferences.setPositionForFile(this.getOpenedFile(), this.getPositionInSecs());
                }
                this.currentInstance.doStop();
                this.currentInstance = null;
            }
            List<String> list = this.output;
            synchronized (list) {
                this.output.clear();
                this.output.notifyAll();
            }
        }
        if (report_state) {
            this.reportNewState(MediaPlaybackState.Stopped);
        }
    }

    @Override
    public void setMetaDataListener(MetaDataListener listener) {
        this.metaDataListener = listener;
    }

    @Override
    public void setStateListener(StateListener listener) {
        this.stateListener = listener;
    }

    @Override
    public void setVolumeListener(VolumeListener listener) {
        this.volumeListener = listener;
    }

    @Override
    public void setPositionListener(PositionListener listener) {
        this.positionListener = listener;
    }

    @Override
    public void setIcyInfoListener(IcyInfoListener listener) {
        this.icyInfoListener = listener;
    }

    private void reportPosition(float position) {
        if (this.positionListener != null) {
            this.positionListener.positionChanged(position);
        }
    }

    private void reportVolume(int volume) {
        if (this.volumeListener != null) {
            this.volumeListener.volumeChanged(volume);
        }
    }

    private void reportDuration(float duration) {
        if (this.metaDataListener != null) {
            this.metaDataListener.receivedDuration(duration);
        }
    }

    private void reportFoundAudioTrack(Language audioTrack) {
        if (this.metaDataListener != null) {
            this.metaDataListener.foundAudioTrack(audioTrack);
        }
    }

    private void reportFoundSubtitle(Language subtitle) {
        if (this.metaDataListener != null) {
            this.metaDataListener.foundSubtitle(subtitle);
        }
    }

    private void reportNewState(MediaPlaybackState state) {
        if (this.stateListener != null) {
            this.stateListener.stateChanged(state);
        }
    }

    private void reportIcyInfo(String data) {
        if (this.icyInfoListener != null) {
            this.icyInfoListener.newIcyInfoData(data);
        }
    }

    public void dispose() {
        this.disposed = true;
        this.doStop();
    }

    @Override
    public Map<String, String> getProperties(String fileOrUrl) {
        MPlayerInstance instance = new MPlayerInstance();
        final HashMap<String, String> properties = new HashMap<String, String>();
        instance.doGetProperties(fileOrUrl, new MPlayerInstance.OutputConsumer(){
            private String lastKey = null;

            @Override
            public void consume(String line) {
                if (line.split("=").length < 2) {
                    return;
                }
                if (line.startsWith(MPlayer.ID_CLIP_INFO_NAME)) {
                    this.lastKey = line.split("=")[1];
                } else if (line.startsWith(MPlayer.ID_CLIP_INFO_VALUE)) {
                    if (this.lastKey != null) {
                        properties.put(this.lastKey, line.split("=")[1]);
                        this.lastKey = null;
                    }
                } else if (line.startsWith(MPlayer.ID_)) {
                    String[] kv = line.split("=");
                    properties.put(kv[0], kv[1]);
                }
            }
        });
        return properties;
    }
}

