/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library.tags;

import com.frostwire.gui.library.tags.MPlayerParser;
import com.frostwire.gui.library.tags.TagsData;
import com.frostwire.gui.library.tags.TagsParser;
import com.frostwire.gui.library.tags.TagsParserFactory;
import com.frostwire.util.Logger;
import java.awt.image.BufferedImage;
import java.io.File;

public class TagsReader {
    private static final Logger LOG = Logger.getLogger(TagsReader.class);
    private final File file;
    private final TagsParser parser;

    public TagsReader(File file) {
        this.file = file;
        this.parser = new TagsParserFactory().getInstance(file);
    }

    public TagsData parse() {
        TagsData data = null;
        if (this.parser != null) {
            data = this.parser.parse();
            if (data == null || this.isEmpty(data)) {
                data = new MPlayerParser(this.file).parse();
            }
        } else {
            LOG.warn("Unable to create tags parser for file: " + String.valueOf(this.file));
        }
        return data;
    }

    public BufferedImage getArtwork() {
        BufferedImage image = null;
        if (this.parser != null) {
            image = this.parser.getArtwork();
        } else {
            LOG.warn("Unable to create tags parser for file: " + String.valueOf(this.file));
        }
        return image;
    }

    private boolean isEmpty(TagsData data) {
        return false;
    }

    public File getFile() {
        return this.file;
    }
}

