/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library.tags;

import com.frostwire.gui.library.tags.AbstractTagParser;
import com.frostwire.gui.library.tags.TagsData;
import com.frostwire.mp4.AppleCoverBox;
import com.frostwire.mp4.AppleIntegerBox;
import com.frostwire.mp4.AppleItemListBox;
import com.frostwire.mp4.AppleUtf8Box;
import com.frostwire.mp4.Box;
import com.frostwire.mp4.IsoFile;
import com.frostwire.mp4.MovieHeaderBox;
import com.frostwire.util.Logger;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;

class MP4Parser
extends AbstractTagParser {
    private static final Logger LOG = Logger.getLogger(MP4Parser.class);
    private static final String[] ID3_GENRES = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A capella", "Euro-House", "Dance Hall", "Goa", "Drum & Bass", "Club-House", "Hardcore", "Terror", "Indie", "Britpop", null, "Polsk Punk", "Beat", "Christian Gangsta", "Heavy Metal", "Black Metal", "Crossover", "Contemporary Christian", "Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "JPop", "Synthpop"};

    MP4Parser(File file) {
        super(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage getArtworkFromMP4(File file) {
        BufferedImage image = null;
        try {
            RandomAccessFile iso = new RandomAccessFile(file, "r");
            LinkedList<Box> boxes = IsoFile.head(iso, ByteBuffer.allocate(102400));
            try {
                AppleCoverBox data = (AppleCoverBox)Box.findFirst(boxes, Box.covr);
                if (data != null) {
                    byte[] imageData = data.value();
                    if (data.dataType() == 13) {
                        image = MP4Parser.imageFromData(imageData);
                    } else if (data.dataType() == 14) {
                        try {
                            image = ImageIO.read(new ByteArrayInputStream(imageData, 0, imageData.length));
                        }
                        catch (IIOException e) {
                            LOG.warn("Unable to decode png image from data tag");
                        }
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(iso);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagsData parse() {
        TagsData data = null;
        try {
            RandomAccessFile iso = new RandomAccessFile(this.file, "r");
            LinkedList<Box> boxes = IsoFile.head(iso, ByteBuffer.allocate(102400));
            try {
                int duration = this.getDuration(boxes);
                String bitrate = "";
                AppleItemListBox ilst = (AppleItemListBox)Box.findFirst(boxes, Box.ilst);
                String title = this.getBoxValue(ilst, Box.Cnam);
                String artist = this.getBoxValue(ilst, Box.CART);
                String album = this.getBoxValue(ilst, Box.Calb);
                String comment = this.getBoxValue(ilst, Box.Ccmt);
                String genre = this.getGenre(ilst);
                String track = "";
                String year = "";
                String lyrics = "";
                data = this.sanitize(duration, bitrate, title, artist, album, comment, genre, track, year, lyrics);
            }
            finally {
                IOUtils.closeQuietly(iso);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to parse file using mp4parser: " + String.valueOf(this.file));
        }
        return data;
    }

    @Override
    public BufferedImage getArtwork() {
        return MP4Parser.getArtworkFromMP4(this.file);
    }

    private int getDuration(LinkedList<Box> boxes) {
        MovieHeaderBox mvhd = (MovieHeaderBox)Box.findFirst(boxes, Box.mvhd);
        return (int)(mvhd.duration() / (long)mvhd.timescale());
    }

    private <T extends AppleUtf8Box> String getBoxValue(AppleItemListBox ilst, int type) {
        AppleUtf8Box b = (AppleUtf8Box)ilst.findFirst(type);
        return b != null ? b.value() : "";
    }

    private long getBoxLongValue(AppleItemListBox ilst) {
        AppleIntegerBox b = (AppleIntegerBox)ilst.findFirst(Box.gnre);
        return b != null ? (long)b.value() : -1L;
    }

    private String getGenre(AppleItemListBox ilst) {
        String value = null;
        long valueId = this.getBoxLongValue(ilst);
        if (0L <= valueId && valueId < (long)ID3_GENRES.length) {
            value = ID3_GENRES[(int)valueId];
        }
        if (value == null || value.equals("")) {
            value = this.getBoxValue(ilst, Box.Cgen);
        }
        return value;
    }
}

