/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library.tags;

import com.frostwire.gui.library.tags.AbstractTagParser;
import com.frostwire.gui.library.tags.TagsData;
import com.frostwire.util.Logger;
import java.awt.image.BufferedImage;
import java.io.File;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.generic.AudioFileReader;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.images.Artwork;

class JaudiotaggerParser
extends AbstractTagParser {
    private static final Logger LOG = Logger.getLogger(JaudiotaggerParser.class);
    private final AudioFileReader fileReader;

    JaudiotaggerParser(File file, AudioFileReader fileReader) {
        super(file);
        this.fileReader = fileReader;
    }

    public JaudiotaggerParser(File file) {
        this(file, null);
    }

    @Override
    public TagsData parse() {
        TagsData data = null;
        try {
            AudioFile audioFile = this.fileReader != null ? this.fileReader.read(this.file) : AudioFileIO.read(this.file);
            AudioHeader header = audioFile.getAudioHeader();
            int duration = header.getTrackLength();
            String bitrate = header.getBitRate();
            String title = this.getTitle(audioFile);
            String artist = this.getArtist(audioFile);
            String album = this.getAlbum(audioFile);
            String comment = this.getComment(audioFile);
            String genre = this.getGenre(audioFile);
            String track = this.getTrack(audioFile);
            String year = this.getYear(audioFile);
            String lyrics = this.getLyrics(audioFile);
            data = this.sanitize(duration, bitrate, title, artist, album, comment, genre, track, year, lyrics);
        }
        catch (Exception e) {
            LOG.warn("Unable to parse file using Jaudiotagger: " + String.valueOf(this.file));
        }
        return data;
    }

    @Override
    public BufferedImage getArtwork() {
        BufferedImage data = null;
        try {
            Artwork artwork;
            AudioFile audioFile = this.fileReader != null ? this.fileReader.read(this.file) : AudioFileIO.read(this.file);
            Tag tag = audioFile.getTag();
            if (tag != null && (artwork = audioFile.getTag().getFirstArtwork()) != null) {
                byte[] imageData = artwork.getBinaryData();
                data = JaudiotaggerParser.imageFromData(imageData);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to read artwork of file using Jaudiotagger: " + String.valueOf(this.file));
        }
        return data;
    }

    String getTitle(AudioFile audioFile) {
        return this.getValueSafe(audioFile.getTag(), FieldKey.TITLE);
    }

    String getArtist(AudioFile audioFile) {
        return this.getValueSafe(audioFile.getTag(), FieldKey.ARTIST);
    }

    String getAlbum(AudioFile audioFile) {
        return this.getValueSafe(audioFile.getTag(), FieldKey.ALBUM);
    }

    String getComment(AudioFile audioFile) {
        return this.getValueSafe(audioFile.getTag(), FieldKey.COMMENT);
    }

    String getGenre(AudioFile audioFile) {
        return this.getValueSafe(audioFile.getTag(), FieldKey.GENRE);
    }

    String getTrack(AudioFile audioFile) {
        return this.getValueSafe(audioFile.getTag(), FieldKey.TRACK);
    }

    String getYear(AudioFile audioFile) {
        return this.getValueSafe(audioFile.getTag(), FieldKey.YEAR);
    }

    String getLyrics(AudioFile audioFile) {
        return this.getValueSafe(audioFile.getTag(), FieldKey.LYRICS);
    }

    private String getValueSafe(Tag tag, FieldKey id) {
        String value = null;
        try {
            value = tag.getFirst(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }
}

