/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library.tags;

import com.frostwire.gui.library.tags.TagsData;
import com.frostwire.gui.library.tags.TagsParser;
import com.frostwire.jpeg.JPEGImageIO;
import com.frostwire.util.Logger;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;

abstract class AbstractTagParser
implements TagsParser {
    private static final Logger LOG = Logger.getLogger(AbstractTagParser.class);
    final File file;

    AbstractTagParser(File file) {
        this.file = file;
    }

    static BufferedImage imageFromData(byte[] data) {
        BufferedImage image = null;
        try {
            try {
                image = ImageIO.read(new ByteArrayInputStream(data, 0, data.length));
            }
            catch (IIOException e) {
                image = JPEGImageIO.read(new ByteArrayInputStream(data, 0, data.length));
            }
        }
        catch (Throwable e) {
            LOG.error("Unable to create artwork image from bytes");
        }
        return image;
    }

    TagsData sanitize(int duration, String bitrate, String title, String artist, String album, String comment, String genre, String track, String year, String lyrics) {
        if (title == null || title.length() == 0) {
            title = FilenameUtils.getBaseName(this.file.getAbsolutePath());
        }
        if (duration < 0) {
            duration = 0;
        }
        if (artist == null) {
            artist = "";
        }
        if (album == null) {
            album = "";
        }
        if (bitrate == null) {
            bitrate = "";
        }
        if (comment == null) {
            comment = "";
        }
        genre = genre == null ? "" : genre.replaceFirst("\\(.*\\)", "");
        if (track == null) {
            track = "";
        } else {
            int index = track.indexOf(47);
            if (index != -1) {
                track = track.substring(0, index);
            }
        }
        if (year == null) {
            year = "";
        }
        if (lyrics == null) {
            lyrics = "";
        }
        return new TagsData(duration, bitrate, title, artist, album, comment, genre, track, year, lyrics);
    }
}

