/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.concurrent.concurrent.ExecutorsHelper;
import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.gui.library.tags.TagsData;
import com.frostwire.gui.library.tags.TagsReader;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.util.HistoHashMap;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.event.KeyEvent;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.limewire.util.FileUtils;

public class LibraryUtils {
    private static final Logger LOG = Logger.getLogger(LibraryUtils.class);
    private static final ExecutorService executor = ExecutorsHelper.newProcessingQueue("LibraryUtils-Executor");

    public static ExecutorService getExecutor() {
        return executor;
    }

    public static String getSecondsInDDHHMMSS(int s) {
        Object SS;
        if (s < 0) {
            s = 0;
        }
        StringBuilder result = new StringBuilder();
        int days = s / 86400;
        int r = s % 86400;
        int hours = r / 3600;
        r = s % 3600;
        int minutes = r / 60;
        int seconds = r % 60;
        String DD = String.valueOf(days);
        Object HH = hours < 10 ? "0" + hours : String.valueOf(hours);
        Object MM = minutes < 10 ? "0" + minutes : String.valueOf(minutes);
        Object object = SS = seconds < 10 ? "0" + seconds : String.valueOf(seconds);
        if (days > 0) {
            result.append(DD);
            result.append(" day");
            if (days > 1) {
                result.append("s");
            }
            return result.toString();
        }
        if (hours > 0) {
            result.append((String)HH);
            result.append(":");
        }
        result.append((String)MM);
        result.append(":");
        result.append((String)SS);
        return result.toString();
    }

    public static boolean directoryContainsPlayableExtensions(File directory) {
        Set<File> ignore = TorrentUtil.getIgnorableFiles();
        return LibraryUtils.directoryContainsExtension(directory, 4, ignore, MediaPlayer.getPlayableExtensions());
    }

    public static boolean directoryContainsASinglePlayableFile(File directory) {
        File[] files = directory.listFiles();
        return LibraryUtils.directoryContainsPlayableExtensions(directory) && files != null && files.length == 1;
    }

    public static boolean directoryContainsAudio(File directory) {
        Set<File> ignore = TorrentUtil.getIgnorableFiles();
        return LibraryUtils.directoryContainsExtension(directory, 4, ignore, MediaPlayer.getPlayableExtensions());
    }

    public static boolean directoryContainsExtension(File directory, String extensionWithoutDot) {
        Set<File> ignore = TorrentUtil.getIgnorableFiles();
        return LibraryUtils.directoryContainsExtension(directory, 4, ignore, extensionWithoutDot);
    }

    private static boolean directoryContainsExtension(File directory, int depth, Set<File> ignore, String ... extensionWithoutDot) {
        try {
            if (directory == null || !directory.isDirectory()) {
                return false;
            }
            File[] files = directory.listFiles();
            if (files == null || files.length == 0) {
                return false;
            }
            for (File childFile : files) {
                if (!(!childFile.isDirectory() ? FileUtils.hasExtension(childFile.getAbsolutePath(), extensionWithoutDot) && !ignore.contains(childFile) : depth > 0 && LibraryUtils.directoryContainsExtension(childFile, depth - 1, ignore, extensionWithoutDot))) continue;
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    private static String suggestPlaylistName(File[] mediaFiles) {
        HistoHashMap<String> artistNames = new HistoHashMap<String>();
        HistoHashMap<CallSite> artistsAlbums = new HistoHashMap<CallSite>();
        HistoHashMap<String> albumNames = new HistoHashMap<String>();
        HistoHashMap<CallSite> genres = new HistoHashMap<CallSite>();
        for (File mf : mediaFiles) {
            if (!MediaPlayer.isPlayableFile(mf)) continue;
            TagsData mt = new TagsReader(mf).parse();
            artistNames.update(mt.getArtist());
            artistsAlbums.update((CallSite)((Object)(mt.getArtist() + " - " + mt.getAlbum())));
            albumNames.update(mt.getAlbum());
            genres.update((CallSite)((Object)("(" + mt.getGenre() + ")")));
        }
        List histogramArtistNames = artistNames.histogram();
        List histogramArtistsAlbums = artistsAlbums.histogram();
        List histogramAlbumNames = albumNames.histogram();
        List histogramGenres = genres.histogram();
        String topArtistName = (String)histogramArtistNames.get(histogramArtistNames.size() - 1).getKey();
        int topArtistNameCount = histogramArtistNames.get(histogramArtistNames.size() - 1).getValue();
        String topArtistAlbum = (String)histogramArtistsAlbums.get(histogramArtistsAlbums.size() - 1).getKey();
        int topArtistAlbumCount = histogramArtistsAlbums.get(histogramArtistsAlbums.size() - 1).getValue();
        String topAlbumName = (String)histogramAlbumNames.get(histogramAlbumNames.size() - 1).getKey();
        int topAlbumNameCount = histogramAlbumNames.get(histogramAlbumNames.size() - 1).getValue();
        String topGenre = (String)histogramGenres.get(histogramGenres.size() - 1).getKey();
        Object suggestedPlaylistName = topArtistName;
        if (topArtistAlbumCount >= topArtistNameCount) {
            suggestedPlaylistName = topArtistAlbum;
        } else if (topAlbumNameCount >= topArtistNameCount) {
            suggestedPlaylistName = topAlbumName;
            if (topArtistNameCount > 3) {
                suggestedPlaylistName = topArtistName + " - " + (String)suggestedPlaylistName;
            }
        }
        if (!topGenre.equals("()")) {
            suggestedPlaylistName = (String)suggestedPlaylistName + " " + topGenre;
        }
        return suggestedPlaylistName;
    }

    static boolean isRefreshKeyEvent(KeyEvent e) {
        int keyCode = e.getKeyCode();
        boolean ctrlCmdDown = e.isControlDown() || e.isAltGraphDown() || e.isMetaDown();
        return keyCode == 116 || ctrlCmdDown && keyCode == 82;
    }

    static void asyncParseLyrics(TagsReader tagsReader, OnLyricsParsedUICallback uiCallback) {
        File audioFile = tagsReader.getFile();
        if (audioFile == null || !audioFile.isFile() || !audioFile.canRead() || uiCallback == null) {
            if (uiCallback != null) {
                uiCallback.setLyrics("");
                GUIMediator.safeInvokeLater(uiCallback);
            }
            return;
        }
        executor.submit(() -> {
            TagsData tagsData = tagsReader.parse();
            if (tagsData != null) {
                uiCallback.setLyrics(tagsData.getLyrics());
                GUIMediator.safeInvokeLater(uiCallback);
            }
        });
    }

    public static abstract class OnLyricsParsedUICallback
    implements Runnable {
        private String lyrics;

        String getLyrics() {
            return this.lyrics;
        }

        void setLyrics(String lyrics) {
            this.lyrics = lyrics;
        }

        @Override
        public abstract void run();
    }
}

