/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.library.AbstractLibraryTableDataLine;
import com.frostwire.gui.library.LibraryFilesTableMediator;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.MulticastTransferHandler;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

class LibraryFilesTableTransferHandler
extends TransferHandler {
    private final LibraryFilesTableMediator mediator;
    private final TransferHandler fallbackTransferHandler;

    LibraryFilesTableTransferHandler(LibraryFilesTableMediator mediator) {
        this.mediator = mediator;
        this.fallbackTransferHandler = new MulticastTransferHandler(DNDUtils.DEFAULT_TRANSFER_HANDLERS);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return this.canImport(support, true);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support, false)) {
            return this.fallbackTransferHandler.importData(support);
        }
        return false;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 0x40000003;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        List lines = this.mediator.getSelectedLines();
        ArrayList<File> files = new ArrayList<File>(lines.size());
        for (AbstractLibraryTableDataLine line : lines) {
            files.add(line.getFile());
        }
        return new FileTransferable(files);
    }

    private boolean canImport(TransferHandler.TransferSupport support, boolean fallback) {
        support.setShowDropLocation(false);
        if (!this.mediator.getMediaType().equals(MediaType.getAudioMediaType())) {
            return fallback && this.fallbackTransferHandler.canImport(support);
        }
        return DNDUtils.supportCanImport(support.getDataFlavors()[0], support, this.fallbackTransferHandler, fallback);
    }
}

