/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.bittorrent.SendFileProgressDialog;
import com.frostwire.gui.library.AbstractLibraryTableDataLine;
import com.frostwire.gui.library.LibraryActionsRenderer;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.player.MediaSource;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.table.TableCellRenderer;

abstract class AbstractLibraryTableMediator<T extends DataLineModel<E, I>, E extends AbstractLibraryTableDataLine<I>, I>
extends AbstractTableMediator<T, E, I> {
    private static final LibraryActionsRenderer ACTION_RENDERER = new LibraryActionsRenderer();
    Action SEND_TO_FRIEND_ACTION;
    private MediaType mediaType;
    private int needToScrollTo;
    private AdjustmentListener adjustmentListener;

    AbstractLibraryTableMediator(String id) {
        super(id);
        GUIMediator.addRefreshListener(this);
        this.mediaType = MediaType.getAnyTypeMediaType();
        this.needToScrollTo = -1;
    }

    @Override
    protected void setupConstants() {
    }

    @Override
    protected TableCellRenderer getAbstractActionsRenderer() {
        return ACTION_RENDERER;
    }

    List<AbstractLibraryTableDataLine<I>> getSelectedLines() {
        int[] selected = this.TABLE.getSelectedRows();
        ArrayList<AbstractLibraryTableDataLine<I>> lines = new ArrayList<AbstractLibraryTableDataLine<I>>(selected.length);
        for (int aSelected : selected) {
            lines.add((AbstractLibraryTableDataLine)this.DATA_MODEL.get(aSelected));
        }
        return lines;
    }

    int[] getSelectedIndexes() {
        if (this.TABLE != null) {
            return this.TABLE.getSelectedRows();
        }
        return null;
    }

    private I getItemAt(int row) {
        try {
            return (I)((AbstractLibraryTableDataLine)this.DATA_MODEL.get(row)).getInitializeObject();
        }
        catch (Exception e) {
            return null;
        }
    }

    boolean setItemSelected(I item) {
        int i2 = this.DATA_MODEL.getRow(item);
        if (i2 != -1) {
            this.TABLE.setSelectedRow(i2);
            this.TABLE.ensureSelectionVisible();
            return true;
        }
        return false;
    }

    public boolean selectItemAt(int row) {
        return this.setItemSelected(this.getItemAt(row));
    }

    @Override
    protected JComponent getScrolledTablePane() {
        JComponent comp = super.getScrolledTablePane();
        if (this.adjustmentListener == null) {
            this.adjustmentListener = this::adjustmentListener_adjustmentValueChanged;
            this.SCROLL_PANE.getVerticalScrollBar().addAdjustmentListener(this.adjustmentListener);
        }
        return comp;
    }

    protected abstract List<MediaSource> getFilesView();

    public MediaType getMediaType() {
        return this.mediaType;
    }

    void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        this.SEND_TO_FRIEND_ACTION = new SendToFriendAction();
    }

    private void adjustmentListener_adjustmentValueChanged(AdjustmentEvent e) {
        try {
            int value = this.needToScrollTo;
            if (value >= 0 && this.SCROLL_PANE.getVerticalScrollBar().getMaximum() >= value) {
                this.SCROLL_PANE.getVerticalScrollBar().setValue(value);
                Toolkit.getDefaultToolkit().sync();
                this.needToScrollTo = -1;
            }
        }
        catch (Exception ex) {
            this.needToScrollTo = -1;
        }
    }

    void scrollTo(int value) {
        this.needToScrollTo = value;
    }

    int getScrollbarValue() {
        if (this.SCROLL_PANE != null && this.SCROLL_PANE.getVerticalScrollBar() != null) {
            return this.SCROLL_PANE.getVerticalScrollBar().getValue();
        }
        return 0;
    }

    void playCurrentSelection() {
        AbstractLibraryTableDataLine line = (AbstractLibraryTableDataLine)this.DATA_MODEL.get(this.TABLE.getSelectedRow());
        if (line == null) {
            return;
        }
        try {
            MediaSource mediaSource = this.createMediaSource(line);
            if (mediaSource != null) {
                MediaPlayer.instance().asyncLoadMedia(mediaSource, false, this.getFilesView());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract MediaSource createMediaSource(E var1);

    @Override
    public void removeSelection() {
        super.removeSelection();
        LibraryMediator.instance().clearDirectoryHolderCaches();
    }

    static class SendToFriendAction
    extends AbstractAction {
        private static final long serialVersionUID = 1329472129818371471L;

        SendToFriendAction() {
            super(I18n.tr("Send to friend"));
            this.putValue("LimeShortName", I18n.tr("Send"));
            this.putValue("LongDescription", I18n.tr("Send to friend"));
            this.putValue("LimeIconName", "LIBRARY_SEND");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = LibraryMediator.instance().getSelectedFile();
            if (file == null) {
                return;
            }
            DialogOption result = GUIMediator.showYesNoMessage(I18n.tr("Do you want to send this file to a friend?") + "\n\n\"" + file.getName() + "\"", I18n.tr("Send files with FrostWire"), 3);
            if (result == DialogOption.YES) {
                new SendFileProgressDialog(GUIMediator.getAppFrame(), file).setVisible(true);
                GUIMediator.instance().setWindow(GUIMediator.Tabs.TRANSFERS);
            }
        }
    }
}

