/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.transfers;

import com.frostwire.gui.components.transfers.TransferDetailPeers;
import com.frostwire.gui.components.transfers.TransferDetailPeersDataLine;
import com.frostwire.gui.components.transfers.TransferDetailPeersModel;
import com.frostwire.gui.theme.SkinPopupMenu;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;

public class TransferDetailPeersTableMediator
extends AbstractTableMediator<TransferDetailPeersModel, TransferDetailPeersDataLine, TransferDetailPeers.PeerItemHolder> {
    TransferDetailPeersTableMediator() {
        super("TRANSFER_DETAIL_PEERS_TABLE_MEDIATOR");
    }

    @Override
    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel();
        this.DATA_MODEL = new TransferDetailPeersModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this.TABLE.setAutoResizeMode(2);
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        SkinPopupMenu menu = new SkinPopupMenu();
        TransferDetailPeersModel dataModel = (TransferDetailPeersModel)this.getDataModel();
        TransferDetailPeersDataLine transferDetailPeersDataLine = (TransferDetailPeersDataLine)dataModel.get(this.TABLE.getSelectedRow());
        if (transferDetailPeersDataLine != null && transferDetailPeersDataLine.getInitializeObject() != null) {
            TransferDetailPeers.PeerItemHolder peerItemHolder = (TransferDetailPeers.PeerItemHolder)transferDetailPeersDataLine.getInitializeObject();
            menu.add(new CopyBittorrentAddressAction(peerItemHolder));
            menu.add(new CopyIPAction(peerItemHolder));
            menu.add(new CopyIPPortAction(peerItemHolder));
        }
        return menu;
    }

    @Override
    protected void updateSplashScreen() {
    }

    private static final class CopyBittorrentAddressAction
    extends AbstractAction {
        private final TransferDetailPeers.PeerItemHolder peerItemHolder;

        public CopyBittorrentAddressAction(TransferDetailPeers.PeerItemHolder itemHolder) {
            this.peerItemHolder = itemHolder;
            this.putValue("Name", I18n.tr("Copy") + " " + I18n.tr("Peer's") + " " + I18n.tr("Address"));
            this.putValue("LimeShortName", this.getValue("Name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GUIMediator.setClipboardContent(TransferDetailPeersDataLine.getBittorrentAddress(this.peerItemHolder.peerItem));
        }
    }

    private static final class CopyIPAction
    extends AbstractAction {
        private final TransferDetailPeers.PeerItemHolder peerItemHolder;

        public CopyIPAction(TransferDetailPeers.PeerItemHolder itemHolder) {
            this.peerItemHolder = itemHolder;
            this.putValue("Name", I18n.tr("Copy") + " " + I18n.tr("Peer's") + " " + I18n.tr("IP"));
            this.putValue("LimeShortName", this.getValue("Name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String ipPort = this.peerItemHolder.peerItem.ip();
            GUIMediator.setClipboardContent(ipPort.substring(0, ipPort.indexOf(":")));
        }
    }

    private static final class CopyIPPortAction
    extends AbstractAction {
        private final TransferDetailPeers.PeerItemHolder peerItemHolder;

        public CopyIPPortAction(TransferDetailPeers.PeerItemHolder itemHolder) {
            this.peerItemHolder = itemHolder;
            this.putValue("Name", I18n.tr("Copy") + " " + I18n.tr("Peer's") + " " + I18n.tr("IP") + ":" + I18n.tr("Port"));
            this.putValue("LimeShortName", this.getValue("Name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GUIMediator.setClipboardContent(this.peerItemHolder.peerItem.ip());
        }
    }
}

