/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.transfers;

import com.frostwire.gui.bittorrent.BittorrentDownload;
import com.frostwire.gui.components.transfers.TransferDetailFiles;
import com.frostwire.gui.components.transfers.TransferDetailGeneral;
import com.frostwire.gui.components.transfers.TransferDetailPeers;
import com.frostwire.gui.components.transfers.TransferDetailPieces;
import com.frostwire.gui.components.transfers.TransferDetailTrackers;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;

public final class TransferDetailComponent
extends JPanel
implements RefreshListener {
    private final String GENERAL_CARD = "G";
    private final String FILES_CARD = "F";
    private final String PIECES_CARD = "P";
    private final String TRACKERS_CARD = "T";
    private final String PEERS_CARD = "p";
    private JToggleButton filesButton;
    private JToggleButton piecesButton;
    private JToggleButton generalButton;
    private JToggleButton trackersButton;
    private JToggleButton peersButton;
    private JPanel detailComponentHolder;
    private HashMap<String, TransferDetailPanel> cardPanelMap;
    private TransferDetailPanel currentComponent;
    private BittorrentDownload selectedBittorrentDownload;

    public TransferDetailComponent(MouseAdapter hideDetailsActionListener) {
        super(new MigLayout("fill, insets 0 0 0 0", "", "[top][grow]"));
        JPanel labelAndLink = new JPanel(new FlowLayout());
        JLabel hideLink = new JLabel("<html><a href='#'>" + I18n.tr("hide") + "</a></html>");
        hideLink.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        hideLink.setFont(new Font("Helvetica", 0, 13));
        hideLink.addMouseListener(hideDetailsActionListener);
        labelAndLink.add(new JLabel(I18n.tr("Transfer Detail")));
        labelAndLink.add((Component)hideLink, "left, gapleft 10px, growx");
        this.add((Component)labelAndLink, "left, gapleft 10px, growx");
        this.add((Component)this.createDetailSwitcherButtons(), "push, right, wrap");
        this.add((Component)this.createDetailComponentHolder(), "hmin 0px, span 2, grow");
        GUIMediator.addRefreshListener(this);
    }

    private JPanel createDetailComponentHolder() {
        this.detailComponentHolder = new JPanel(new CardLayout());
        TransferDetailGeneral generalComponent = new TransferDetailGeneral();
        this.detailComponentHolder.add((Component)generalComponent, "G");
        TransferDetailFiles filesComponent = new TransferDetailFiles();
        this.detailComponentHolder.add((Component)filesComponent, "F");
        TransferDetailPieces piecesComponent = new TransferDetailPieces();
        this.detailComponentHolder.add((Component)piecesComponent, "P");
        TransferDetailTrackers trackersComponent = new TransferDetailTrackers();
        this.detailComponentHolder.add((Component)trackersComponent, "T");
        TransferDetailPeers peersComponent = new TransferDetailPeers();
        this.detailComponentHolder.add((Component)peersComponent, "p");
        this.cardPanelMap = new HashMap();
        this.cardPanelMap.put("G", generalComponent);
        this.cardPanelMap.put("F", filesComponent);
        this.cardPanelMap.put("P", piecesComponent);
        this.cardPanelMap.put("T", trackersComponent);
        this.cardPanelMap.put("p", peersComponent);
        HashMap<String, JToggleButton> cardButtonMap = new HashMap<String, JToggleButton>();
        cardButtonMap.put("G", this.generalButton);
        cardButtonMap.put("F", this.filesButton);
        cardButtonMap.put("P", this.piecesButton);
        cardButtonMap.put("T", this.trackersButton);
        cardButtonMap.put("p", this.peersButton);
        String lastTransferSelected = UISettings.LAST_SELECTED_TRANSFER_DETAIL_JPANEL.getValue();
        if (cardButtonMap.containsKey(lastTransferSelected)) {
            ((JToggleButton)cardButtonMap.get(lastTransferSelected)).doClick();
        }
        return this.detailComponentHolder;
    }

    private JPanel createDetailSwitcherButtons() {
        JPanel detailSwitcherButtonsPanel = new JPanel(new MigLayout("align right, ins 0 0 0 8"));
        ButtonGroup switcherButtonsGroup = new ButtonGroup();
        this.generalButton = new JToggleButton(I18n.tr("General"), false);
        this.filesButton = new JToggleButton(I18n.tr("Files"), true);
        this.piecesButton = new JToggleButton(I18n.tr("Pieces"), false);
        this.trackersButton = new JToggleButton(I18n.tr("Trackers"), false);
        this.peersButton = new JToggleButton(I18n.tr("Peers"), false);
        this.generalButton.addActionListener(e -> this.showDetailComponent("G"));
        this.filesButton.addActionListener(e -> this.showDetailComponent("F"));
        this.piecesButton.addActionListener(e -> this.showDetailComponent("P"));
        this.trackersButton.addActionListener(e -> this.showDetailComponent("T"));
        this.peersButton.addActionListener(e -> this.showDetailComponent("p"));
        Font smallHelvetica = new Font("Helvetica", 0, 11);
        Dimension buttonDimension = new Dimension(80, 24);
        this.applyFontAndDimensionToFilterToggleButtons(smallHelvetica, buttonDimension, this.generalButton, this.filesButton, this.piecesButton, this.trackersButton, this.peersButton);
        switcherButtonsGroup.add(this.generalButton);
        switcherButtonsGroup.add(this.filesButton);
        switcherButtonsGroup.add(this.piecesButton);
        switcherButtonsGroup.add(this.trackersButton);
        switcherButtonsGroup.add(this.peersButton);
        detailSwitcherButtonsPanel.add(this.generalButton);
        detailSwitcherButtonsPanel.add(this.filesButton);
        detailSwitcherButtonsPanel.add(this.piecesButton);
        detailSwitcherButtonsPanel.add(this.trackersButton);
        detailSwitcherButtonsPanel.add(this.peersButton);
        return detailSwitcherButtonsPanel;
    }

    private void showDetailComponent(String cardName) {
        CardLayout cardLayout = (CardLayout)this.detailComponentHolder.getLayout();
        if (cardLayout != null) {
            cardLayout.show(this.detailComponentHolder, cardName);
            if (!this.cardPanelMap.containsKey(cardName)) {
                throw new RuntimeException("showDetailComponent() - check your logic, cardName '" + cardName + "' not found");
            }
            UISettings.LAST_SELECTED_TRANSFER_DETAIL_JPANEL.setValue(cardName);
            this.currentComponent = this.cardPanelMap.get(cardName);
        }
    }

    private void applyFontAndDimensionToFilterToggleButtons(Font font, Dimension dimension, JToggleButton ... buttons) {
        for (JToggleButton button : buttons) {
            button.setFont(font);
            button.setMinimumSize(dimension);
            button.setMaximumSize(dimension);
            button.setPreferredSize(dimension);
        }
    }

    @Override
    public void refresh() {
        if (GUIMediator.instance().getSelectedTab() == GUIMediator.Tabs.TRANSFERS && this.isVisible() && this.currentComponent != null && this.selectedBittorrentDownload != null) {
            this.currentComponent.updateData(this.selectedBittorrentDownload);
        }
    }

    public void updateData(BittorrentDownload btDownload) {
        this.selectedBittorrentDownload = btDownload;
        if (this.currentComponent != null && this.isVisible()) {
            this.currentComponent.updateData(btDownload);
        }
    }

    static interface TransferDetailPanel {
        public void updateData(BittorrentDownload var1);
    }
}

