/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.bittorrent.BTEngine;
import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.bittorrent.BittorrentDownload;
import com.frostwire.gui.bittorrent.ShareTorrentDialog;
import com.frostwire.jlibtorrent.AnnounceEntry;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.swig.create_torrent;
import com.frostwire.jlibtorrent.swig.entry;
import com.frostwire.jlibtorrent.swig.error_code;
import com.frostwire.jlibtorrent.swig.file_storage;
import com.frostwire.jlibtorrent.swig.libtorrent;
import com.frostwire.transfers.TransferItem;
import com.frostwire.util.UrlUtils;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.VPNDropGuard;
import com.limegroup.gnutella.gui.search.TorrentUISearchResult;
import com.limegroup.gnutella.gui.search.UISearchResult;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class TorrentUtil {
    public static BittorrentDownload getDownloadManager(File f) {
        List<BTDownload> downloads = BTDownloadMediator.instance().getDownloads();
        for (BTDownload d : downloads) {
            if (!(d instanceof BittorrentDownload)) continue;
            BittorrentDownload bt = (BittorrentDownload)d;
            com.frostwire.bittorrent.BTDownload dl = bt.getDl();
            List<TransferItem> items = dl.getItems();
            for (TransferItem item : items) {
                if (!f.equals(item.getFile())) continue;
                return bt;
            }
        }
        return null;
    }

    private static Set<File> getIncompleteFiles() {
        HashSet<File> set = new HashSet<File>();
        List<BTDownload> downloads = BTDownloadMediator.instance().getDownloads();
        for (BTDownload d : downloads) {
            if (!(d instanceof BittorrentDownload)) continue;
            BittorrentDownload bt = (BittorrentDownload)d;
            com.frostwire.bittorrent.BTDownload dl = bt.getDl();
            set.addAll(dl.getIncompleteFiles());
        }
        return set;
    }

    private static Set<File> getPartsFiles() {
        HashSet<File> set = new HashSet<File>();
        List<BTDownload> downloads = BTDownloadMediator.instance().getDownloads();
        for (BTDownload d : downloads) {
            if (!(d instanceof BittorrentDownload)) continue;
            BittorrentDownload bt = (BittorrentDownload)d;
            com.frostwire.bittorrent.BTDownload dl = bt.getDl();
            set.add(dl.partsFile());
        }
        return set;
    }

    public static String getMagnet(String hash) {
        return "magnet:?xt=urn:btih:" + hash;
    }

    public static String getMagnet(UISearchResult sr) {
        String torrentUrl;
        if (sr instanceof TorrentUISearchResult && (torrentUrl = ((TorrentUISearchResult)sr).getTorrentUrl()).startsWith("magnet:?")) {
            return torrentUrl;
        }
        return TorrentUtil.getMagnet(sr.getHash());
    }

    static String getMagnetURLParameters(TorrentInfo torrent) {
        StringBuilder sb = new StringBuilder();
        sb.append("dn=");
        sb.append(UrlUtils.encode(torrent.name()));
        ArrayList<AnnounceEntry> trackers = torrent.trackers();
        for (AnnounceEntry tracker : trackers) {
            String url = tracker.url();
            sb.append("&tr=");
            sb.append(UrlUtils.encode(url));
        }
        sb.append(BTEngine.getInstance().magnetPeers());
        return sb.toString();
    }

    public static Set<File> getIgnorableFiles() {
        Set<File> set = TorrentUtil.getIncompleteFiles();
        set.addAll(TorrentUtil.getPartsFiles());
        return set;
    }

    public static boolean askForPermissionToSeedAndSeedDownloads(BTDownload[] downloaders) {
        boolean allowedToResume = true;
        boolean oneIsCompleted = false;
        if (!VPNDropGuard.canUseBitTorrent()) {
            return false;
        }
        if (downloaders != null) {
            for (BTDownload downloader : downloaders) {
                if (!downloader.isCompleted()) continue;
                oneIsCompleted = true;
                break;
            }
        }
        if ((oneIsCompleted || downloaders == null) && !SharingSettings.SEED_FINISHED_TORRENTS.getValue()) {
            String message2;
            DialogOption answer;
            String message1 = "";
            if (downloaders != null) {
                String string = message1 = downloaders.length > 1 ? I18n.tr("One of the transfers is complete and resuming will cause it to start seeding") : I18n.tr("This transfer is already complete, resuming it will cause it to start seeding");
            }
            if (allowedToResume = (answer = GUIMediator.showYesNoMessage(message1 + "\n\n" + (message2 = I18n.tr("Do you want to enable torrent seeding?")), DialogOption.YES)).equals((Object)DialogOption.YES)) {
                SharingSettings.SEED_FINISHED_TORRENTS.setValue(true);
            }
        }
        if (allowedToResume && downloaders != null) {
            for (BTDownload downloader : downloaders) {
                downloader.resume();
            }
        }
        return allowedToResume;
    }

    public static void makeTorrentAndDownload(File file, UITorrentMakerListener uiTorrentMakerListener, boolean showShareTorrentDialog) {
        TorrentUtil.makeTorrentAndDownload(file, uiTorrentMakerListener, showShareTorrentDialog, true);
    }

    private static void makeTorrentAndDownload(File file, UITorrentMakerListener uiTorrentMakerListener, boolean showShareTorrentDialog, boolean dhtTrackedOnly) {
        block4: {
            try {
                file_storage fs = new file_storage();
                libtorrent.add_files(fs, file.getAbsolutePath());
                create_torrent torrentCreator = new create_torrent(fs);
                if (!dhtTrackedOnly) {
                    torrentCreator.add_tracker("udp://tracker.openbittorrent.com:80", 0);
                    torrentCreator.add_tracker("udp://tracker.publicbt.com:80", 0);
                    torrentCreator.add_tracker("udp://open.demonii.com:1337", 0);
                    torrentCreator.add_tracker("udp://tracker.coppersurfer.tk:6969", 0);
                    torrentCreator.add_tracker("udp://tracker.leechers-paradise.org:6969", 0);
                    torrentCreator.add_tracker("udp://exodus.desync.com:6969", 0);
                    torrentCreator.add_tracker("udp://tracker.pomf.se", 0);
                }
                torrentCreator.set_priv(false);
                torrentCreator.set_creator("FrostWire " + FrostWireUtils.getFrostWireVersion() + " build " + FrostWireUtils.getBuildNumber());
                File torrentFile = new File(SharingSettings.TORRENTS_DIR_SETTING.getValue(), file.getName() + ".torrent");
                error_code ec = new error_code();
                libtorrent.set_piece_hashes(torrentCreator, file.getParentFile().getAbsolutePath(), ec);
                if (ec.value() != 0 && uiTorrentMakerListener != null) {
                    uiTorrentMakerListener.onCreateTorrentError(ec);
                    return;
                }
                entry torrentEntry = torrentCreator.generate();
                byte[] bencoded_torrent_bytes = Vectors.byte_vector2bytes(torrentEntry.bencode());
                FileOutputStream fos = new FileOutputStream(torrentFile);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                bos.write(bencoded_torrent_bytes);
                bos.flush();
                bos.close();
                TorrentInfo torrent = TorrentInfo.bdecode(bencoded_torrent_bytes);
                GUIMediator.safeInvokeLater(() -> {
                    if (uiTorrentMakerListener != null) {
                        uiTorrentMakerListener.beforeOpenForSeedInUIThread();
                    }
                    GUIMediator.instance().openTorrentForSeed(torrentFile, file.getParentFile());
                    if (showShareTorrentDialog) {
                        new ShareTorrentDialog(GUIMediator.getAppFrame(), torrent).setVisible(true);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                if (uiTorrentMakerListener == null) break block4;
                uiTorrentMakerListener.onException();
            }
        }
    }

    static interface UITorrentMakerListener {
        public void onCreateTorrentError(error_code var1);

        public void beforeOpenForSeedInUIThread();

        public void onException();
    }
}

