/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.DigestUtils;
import com.frostwire.gui.bittorrent.BittorrentDownload;
import com.frostwire.gui.bittorrent.HttpBTDownload;
import com.frostwire.transfers.TransferState;
import com.frostwire.util.Logger;
import com.frostwire.util.ThreadPool;
import com.frostwire.util.http.HttpClient;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.io.FilenameUtils;
import org.limewire.util.FileUtils;

public class HttpDownload
extends HttpBTDownload {
    private static final Executor HTTP_THREAD_POOL = new ThreadPool("HttpDownloaders", 4, 6, 60L, new LinkedBlockingQueue<Runnable>(), true);
    private static final Logger LOG = Logger.getLogger(HttpDownload.class);
    private final String url;
    private final String title;
    private final String saveAs;
    private final File completeFile;
    private final File incompleteFile;
    private final String md5;
    private final boolean deleteDataWhenCancelled;
    private File saveFile;
    private int md5CheckingProgress;
    private boolean isResumable;

    HttpDownload(String theURL, String theTitle, String saveFileAs, double fileSize, String md5hash, boolean shouldResume, boolean deleteFileWhenTransferCancelled) {
        super(saveFileAs, fileSize);
        this.url = theURL;
        this.title = theTitle;
        this.saveAs = saveFileAs;
        this.md5 = md5hash;
        this.deleteDataWhenCancelled = deleteFileWhenTransferCancelled;
        this.completeFile = FileUtils.buildFile(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue(), this.saveAs);
        this.incompleteFile = HttpDownload.buildIncompleteFile(this.completeFile);
        this.isResumable = shouldResume;
        this.start(shouldResume);
    }

    private static File buildIncompleteFile(File file) {
        String prefix = FilenameUtils.getBaseName(file.getName());
        String ext = FilenameUtils.getExtension(file.getAbsolutePath());
        return new File(HttpBTDownload.getIncompleteFolder(), prefix + ".incomplete." + ext);
    }

    @Override
    HttpClient.HttpClientListener createHttpClientListener() {
        return new HttpDownloadListenerImpl(this);
    }

    @Override
    public String getName() {
        return this.saveFile.getName();
    }

    @Override
    public String getDisplayName() {
        return this.title;
    }

    @Override
    public boolean isResumable() {
        return this.isResumable && this.state == TransferState.PAUSED && this.size > 0.0;
    }

    @Override
    public boolean isPausable() {
        return this.isResumable && this.state == TransferState.DOWNLOADING && this.size > 0.0;
    }

    @Override
    public void pause() {
        if (this.state != TransferState.FINISHED) {
            this.state = this.isPausable() ? TransferState.PAUSING : TransferState.CANCELING;
            this.httpClient.cancel();
        }
    }

    @Override
    public File getSaveLocation() {
        return this.saveFile;
    }

    @Override
    public void resume() {
        this.start(true);
    }

    @Override
    public int getProgress() {
        if (this.state == TransferState.CHECKING) {
            return this.md5CheckingProgress;
        }
        if (this.size <= 0.0) {
            return -1;
        }
        int progress = (int)((double)(this.bytesReceived * 100L) / this.size);
        return Math.min(100, progress);
    }

    @Override
    public String getHash() {
        return this.md5;
    }

    private void start(boolean resume) {
        this.state = TransferState.WAITING;
        this.saveFile = this.completeFile;
        HTTP_THREAD_POOL.execute(() -> {
            block5: {
                try {
                    File expectedFile = new File(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue(), this.saveAs);
                    if (this.md5 != null && (double)expectedFile.length() == this.size && this.checkMD5(expectedFile)) {
                        this.saveFile = expectedFile;
                        this.bytesReceived = expectedFile.length();
                        this.state = TransferState.FINISHED;
                        this.onComplete();
                        return;
                    }
                    if (resume && this.incompleteFile.exists()) {
                        this.bytesReceived = this.incompleteFile.length();
                    }
                    this.httpClient.save(this.url, this.incompleteFile, resume);
                }
                catch (IOException | StackOverflowError e) {
                    LOG.error(this.url, e);
                    if (this.httpClientListener != null) {
                        this.httpClientListener.onError(this.httpClient, e);
                    }
                    if (this.httpClient.getListener() == null) break block5;
                    this.httpClient.getListener().onError(this.httpClient, e);
                }
            }
        });
    }

    @Override
    void cleanupIncomplete() {
        this.cleanupFile(this.incompleteFile);
    }

    private boolean checkMD5(File file) {
        this.state = TransferState.CHECKING;
        this.md5CheckingProgress = 0;
        return file.exists() && DigestUtils.checkMD5(file, this.md5, new DigestUtils.DigestProgressListener(){

            @Override
            public void onProgress(int progressPercentage) {
                HttpDownload.this.md5CheckingProgress = progressPercentage;
            }

            @Override
            public boolean stopDigesting() {
                return HttpDownload.this.httpClient.isCanceled();
            }
        });
    }

    void onComplete() {
    }

    @Override
    public boolean canPreview() {
        return false;
    }

    @Override
    public File getPreviewFile() {
        return null;
    }

    private final class HttpDownloadListenerImpl
    implements HttpClient.HttpClientListener {
        private final HttpDownload dl;

        HttpDownloadListenerImpl(HttpDownload httpDownload2) {
            this.dl = httpDownload2;
        }

        @Override
        public void onError(HttpClient client, Throwable e) {
            if (e instanceof HttpClient.RangeNotSupportedException) {
                HttpDownload.this.isResumable = false;
                HttpDownload.this.start(false);
            } else {
                HttpDownload.this.state = TransferState.ERROR;
                HttpDownload.this.cleanup();
            }
        }

        @Override
        public void onData(HttpClient client, byte[] buffer, int offset, int length) {
            if (!HttpDownload.this.state.equals((Object)TransferState.PAUSING) && !HttpDownload.this.state.equals((Object)TransferState.CANCELING)) {
                HttpDownload.this.bytesReceived += (long)length;
                HttpDownload.this.updateAverageDownloadSpeed();
                HttpDownload.this.state = TransferState.DOWNLOADING;
            }
        }

        @Override
        public void onComplete(HttpClient client) {
            if (HttpDownload.this.md5 != null && !HttpDownload.this.checkMD5(HttpDownload.this.incompleteFile)) {
                HttpDownload.this.state = TransferState.ERROR_HASH_MD5;
                HttpDownload.this.cleanupIncomplete();
                return;
            }
            boolean renameTo = HttpDownload.this.incompleteFile.renameTo(HttpDownload.this.completeFile);
            if (!renameTo) {
                HttpDownload.this.state = TransferState.ERROR_MOVING_INCOMPLETE;
                LOG.error("Could not rename [" + HttpDownload.this.incompleteFile.getAbsolutePath() + "] into [" + HttpDownload.this.completeFile.getAbsolutePath() + "]");
            } else {
                HttpDownload.this.state = TransferState.FINISHED;
                HttpDownload.this.cleanupIncomplete();
                if (SharingSettings.SEED_FINISHED_TORRENTS.getValue()) {
                    BittorrentDownload.RendererHelper.onSeedTransfer(this.dl, false);
                }
                HttpDownload.this.onComplete();
            }
        }

        @Override
        public void onCancel(HttpClient client) {
            if (HttpDownload.this.state.equals((Object)TransferState.CANCELING)) {
                if (HttpDownload.this.deleteDataWhenCancelled) {
                    HttpDownload.this.cleanup();
                }
                HttpDownload.this.state = TransferState.CANCELED;
            } else if (HttpDownload.this.state.equals((Object)TransferState.PAUSING)) {
                HttpDownload.this.state = TransferState.PAUSED;
                HttpDownload.this.isResumable = true;
            } else {
                HttpDownload.this.state = TransferState.CANCELED;
            }
        }

        @Override
        public void onHeaders(HttpClient httpClient, Map<String, List<String>> headerFields) {
            String responseCodeStr;
            if (headerFields == null) {
                HttpDownload.this.isResumable = false;
                HttpDownload.this.size = -1.0;
                return;
            }
            HttpDownload.this.isResumable = headerFields.containsKey("Accept-Ranges") ? headerFields.get("Accept-Ranges").contains("bytes") : headerFields.containsKey("Content-Range");
            if (headerFields.containsKey("Content-Length")) {
                try {
                    HttpDownload.this.size = Long.parseLong(headerFields.get("Content-Length").get(0));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (HttpDownload.this.size < 0.0 && (responseCodeStr = headerFields.get(null).get(0)).contains(String.valueOf(200)) && headerFields.containsKey("Content-Length")) {
                try {
                    HttpDownload.this.size = Long.parseLong(headerFields.get("Content-Length").get(0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

