/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.bittorrent.CopyrightLicenseBroker;
import com.frostwire.bittorrent.PaymentOptions;
import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.transfers.TransferState;
import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.Logger;
import com.frostwire.util.http.HttpClient;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.util.Date;
import org.apache.commons.io.FileUtils;

abstract class HttpBTDownload
implements BTDownload {
    private static final Logger LOG = Logger.getLogger(HttpBTDownload.class);
    private static final int SPEED_AVERAGE_CALCULATION_INTERVAL_MILLISECONDS = 1000;
    final File completeFile;
    final HttpClient httpClient;
    private final Date dateCreated;
    double size;
    TransferState state;
    long bytesReceived;
    HttpClient.HttpClientListener httpClientListener;
    private long averageSpeed;
    private boolean deleteDataWhenRemoved;
    private long speedMarkTimestamp;
    private long totalReceivedSinceLastSpeedStamp;

    HttpBTDownload(String filename, double size) {
        this.completeFile = org.limewire.util.FileUtils.buildFile(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue(), filename);
        this.size = size;
        this.dateCreated = new Date();
        this.bytesReceived = 0L;
        this.httpClient = HttpClientFactory.getInstance(HttpClientFactory.HttpContext.DOWNLOAD);
        this.httpClient.setListener(this.createHttpClientListener());
    }

    static boolean copyPlayingTemp(File temp, File dest) {
        boolean r;
        System.out.println(temp);
        try {
            FileUtils.copyFile(temp, dest);
            r = true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            r = false;
        }
        return r;
    }

    static File getIncompleteFolder() {
        File incompleteFolder = new File(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue().getParentFile(), "Incomplete");
        if (!incompleteFolder.exists() && !incompleteFolder.mkdirs()) {
            LOG.warn("BTDownloadUtils.getIncompleteFolder(): could not mkdirs for [" + incompleteFolder.getAbsolutePath() + "]");
        }
        return incompleteFolder;
    }

    static File buildTempFile(String name, String ext) {
        return new File(HttpBTDownload.getIncompleteFolder(), name + "." + ext);
    }

    abstract HttpClient.HttpClientListener createHttpClientListener();

    void updateAverageDownloadSpeed() {
        long now = System.currentTimeMillis();
        if (this.isCompleted()) {
            this.averageSpeed = 0L;
            this.speedMarkTimestamp = now;
            this.totalReceivedSinceLastSpeedStamp = 0L;
        } else if (now - this.speedMarkTimestamp > 1000L) {
            this.averageSpeed = (this.bytesReceived - this.totalReceivedSinceLastSpeedStamp) * 1000L / (now - this.speedMarkTimestamp);
            this.speedMarkTimestamp = now;
            this.totalReceivedSinceLastSpeedStamp = this.bytesReceived;
        }
    }

    void cleanup() {
        this.cleanupIncomplete();
        this.cleanupComplete();
    }

    void cleanupFile(File f) {
        boolean delete;
        if (f.exists() && !(delete = f.delete())) {
            f.deleteOnExit();
        }
    }

    abstract void cleanupIncomplete();

    private void cleanupComplete() {
        this.cleanupFile(this.completeFile);
    }

    @Override
    public double getSize() {
        return this.size;
    }

    @Override
    public abstract String getName();

    @Override
    public abstract String getDisplayName();

    @Override
    public boolean isResumable() {
        return false;
    }

    @Override
    public boolean isPausable() {
        return false;
    }

    @Override
    public boolean isCompleted() {
        return this.bytesReceived > 0L && ((double)this.bytesReceived == this.size || this.state == TransferState.FINISHED);
    }

    @Override
    public TransferState getState() {
        return this.state;
    }

    @Override
    public void remove() {
        if (this.state != TransferState.FINISHED) {
            this.state = TransferState.CANCELING;
            this.httpClient.cancel();
        }
        if (this.deleteDataWhenRemoved) {
            this.cleanup();
            if (!this.getSaveLocation().delete()) {
                LOG.warn("HttpBTDownload.remove(): could not delete [" + this.getSaveLocation().getAbsolutePath() + "]");
            }
        }
    }

    @Override
    public void pause() {
        if (this.state != TransferState.FINISHED) {
            this.state = TransferState.CANCELING;
            this.httpClient.cancel();
        }
    }

    @Override
    public File getSaveLocation() {
        return this.completeFile;
    }

    @Override
    public abstract void resume();

    @Override
    public int getProgress() {
        int progress = -1;
        if (this.size > 0.0) {
            if (this.isCompleted()) {
                progress = 100;
            } else {
                progress = (int)((double)(this.bytesReceived * 100L) / this.size);
                progress = Math.min(100, progress);
            }
        }
        return progress;
    }

    @Override
    public long getBytesReceived() {
        if (this.isCompleted() && this.getSaveLocation().exists()) {
            this.bytesReceived = this.getSaveLocation().length();
        }
        return this.bytesReceived;
    }

    @Override
    public long getBytesSent() {
        return 0L;
    }

    @Override
    public double getDownloadSpeed() {
        double result = 0.0;
        if (this.state == TransferState.DOWNLOADING) {
            result = this.averageSpeed / 1000L;
        }
        return result;
    }

    @Override
    public double getUploadSpeed() {
        return 0.0;
    }

    @Override
    public long getETA() {
        if (this.size > 0.0) {
            long speed = this.averageSpeed;
            return speed > 0L ? (long)((this.size - (double)this.getBytesReceived()) / (double)speed) : -1L;
        }
        return -1L;
    }

    @Override
    public String getPeersString() {
        return "";
    }

    @Override
    public String getSeedsString() {
        return "";
    }

    @Override
    public void setDeleteTorrentWhenRemove(boolean deleteTorrentWhenRemove) {
    }

    @Override
    public void setDeleteDataWhenRemove(boolean deleteDataWhenRemove) {
        this.deleteDataWhenRemoved = deleteDataWhenRemove;
    }

    @Override
    public abstract String getHash();

    @Override
    public String getSeedToPeerRatio() {
        return "";
    }

    @Override
    public String getShareRatio() {
        return "";
    }

    @Override
    public boolean isPartialDownload() {
        return false;
    }

    @Override
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public PaymentOptions getPaymentOptions() {
        return null;
    }

    @Override
    public CopyrightLicenseBroker getCopyrightLicenseBroker() {
        return null;
    }

    @Override
    public boolean canPreview() {
        return true;
    }

    @Override
    public abstract File getPreviewFile();
}

