/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.bittorrent.CopyrightLicenseBroker;
import com.frostwire.bittorrent.PaymentOptions;
import com.frostwire.gui.bittorrent.CopyrightLicenseSelectorPanel;
import com.frostwire.gui.bittorrent.PaymentOptionsPanel;
import com.frostwire.gui.theme.ThemeMediator;
import com.frostwire.jlibtorrent.Entry;
import com.frostwire.jlibtorrent.swig.create_torrent;
import com.frostwire.jlibtorrent.swig.entry;
import com.frostwire.jlibtorrent.swig.error_code;
import com.frostwire.jlibtorrent.swig.file_storage;
import com.frostwire.jlibtorrent.swig.libtorrent;
import com.frostwire.jlibtorrent.swig.string_entry_map;
import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.Logger;
import com.frostwire.util.http.HttpClient;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LimeTextField;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import net.miginfocom.swing.MigLayout;

public class CreateTorrentDialog
extends JDialog {
    private static final PieceSize[] values = PieceSize.values();
    private static final Logger LOG = Logger.getLogger(CreateTorrentDialog.class);
    private final List<String> trackers;
    private final Container container;
    private final JTabbedPane tabbedPane;
    private final JPanel basicTorrentPane;
    private final JPanel licensesPane;
    private final JPanel paymentsPane;
    private final CopyrightLicenseSelectorPanel licenseSelectorPanel;
    private final PaymentOptionsPanel paymentOptionsPanel;
    private final Dimension MINIMUM_DIALOG_DIMENSIONS = new Dimension(942, 750);
    private boolean create_from_dir;
    private String singlePath = null;
    private String directoryPath = null;
    private String dotTorrentSavePath = null;
    private boolean autoOpen = true;
    private File saveDir;
    private LimeTextField textSelectedContent;
    private JButton buttonSelectFile;
    private JButton buttonSelectFolder;
    private JLabel labelTrackers;
    private JTextArea textTrackers;
    private JCheckBox checkStartSeeding;
    private JCheckBox checkUseDHT;
    private JTextArea textWebSeeds;
    private JButton buttonSaveAs;
    private JProgressBar progressBar;
    private JScrollPane textTrackersScrollPane;
    private String invalidTrackerURL;
    private JButton buttonClose;
    private JComboBox<PieceSize> pieceSizeComboBox;
    private int pieceSize;

    public CreateTorrentDialog(JFrame frame) {
        super(frame);
        this.trackers = new ArrayList<String>();
        this.container = this.getContentPane();
        this.tabbedPane = new JTabbedPane();
        this.basicTorrentPane = new JPanel();
        this.licensesPane = new JPanel();
        this.paymentsPane = new JPanel();
        this.licenseSelectorPanel = new CopyrightLicenseSelectorPanel();
        this.paymentOptionsPanel = new PaymentOptionsPanel();
        this.initContainersLayouts();
        this.initComponents();
        this.setLocationRelativeTo(frame);
        this.pack();
    }

    private static Entry entryFromMap(Map<?, ?> map) {
        entry e = new entry(entry.data_type.dictionary_t);
        string_entry_map d = e.dict();
        for (Object o : map.keySet()) {
            String k = (String)o;
            Object v = map.get(k);
            if (v instanceof String) {
                d.set(k, new entry((String)v));
                continue;
            }
            if (v instanceof Integer) {
                d.set(k, new entry(((Integer)v).intValue()));
                continue;
            }
            if (v instanceof Entry) {
                d.set(k, ((Entry)v).swig());
                continue;
            }
            if (v instanceof entry) {
                d.set(k, (entry)v);
                continue;
            }
            if (v instanceof List) {
                d.set(k, Entry.fromList((List)v).swig());
                continue;
            }
            if (v instanceof Map) {
                d.set(k, CreateTorrentDialog.entryFromMap((Map)v).swig());
                continue;
            }
            d.set(k, new entry(v.toString()));
        }
        return new Entry(e);
    }

    private void initContainersLayouts() {
        this.container.setLayout(new MigLayout("fill, insets 3px 3px 3px 3px"));
        this.basicTorrentPane.setLayout(new MigLayout("fill"));
        this.licensesPane.setLayout(new MigLayout("fill"));
        this.paymentsPane.setLayout(new MigLayout("fill"));
    }

    private void initTabbedPane() {
        this.container.add((Component)this.tabbedPane, "grow, pushy, wrap");
        this.licensesPane.add((Component)this.licenseSelectorPanel, "grow");
        this.paymentsPane.add((Component)this.paymentOptionsPanel, "grow");
        this.tabbedPane.addTab("1. " + I18n.tr("Contents and Tracking"), this.basicTorrentPane);
        this.tabbedPane.addTab("2. " + I18n.tr("Copyright License"), this.licensesPane);
        this.tabbedPane.addTab("3. " + I18n.tr("Payments/Tips"), this.paymentsPane);
    }

    private void initComponents() {
        this.initDialogSettings();
        this.initTabbedPane();
        this.initProgressBar();
        this.initSaveCloseButtons();
        this.initTorrentContents();
        this.initTorrentTracking();
        this.buildListeners();
    }

    private void initDialogSettings() {
        this.setTitle(I18n.tr("Create New Torrent"));
        this.setSize(this.MINIMUM_DIALOG_DIMENSIONS);
        this.setMinimumSize(this.MINIMUM_DIALOG_DIMENSIONS);
        this.setPreferredSize(this.MINIMUM_DIALOG_DIMENSIONS);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        GUIUtils.addHideAction((JComponent)this.container);
    }

    private void initTorrentContents() {
        JPanel torrentContentsPanel = new JPanel(new MigLayout("fillx, wrap 1", "[]"));
        GUIUtils.setTitledBorderOnPanel(torrentContentsPanel, I18n.tr("Torrent Contents"));
        this.textSelectedContent = new LimeTextField();
        this.textSelectedContent.setEditable(false);
        this.textSelectedContent.setToolTipText(I18n.tr("These box shows the contents you've selected for your new .torrent.\nEither a file, or the contents of a folder."));
        torrentContentsPanel.add((Component)this.textSelectedContent, "north, growx, gap 5 5 0 0, wrap");
        JPanel contentSelectionButtonsPanel = new JPanel(new MigLayout("ins 0, nogrid, fillx, wrap 1", ""));
        this.buttonSelectFile = new JButton(I18n.tr("Select File"));
        this.buttonSelectFile.setToolTipText(I18n.tr("Click here to select a single file as the content indexed by your new .torrent"));
        this.buttonSelectFolder = new JButton(I18n.tr("Select Folder"));
        this.buttonSelectFolder.setToolTipText(I18n.tr("Click here to select a folder as the content indexed by your new .torrent"));
        contentSelectionButtonsPanel.add((Component)this.buttonSelectFile, "align right, width 175px, gaptop 5, gapright 5, gapbottom 5");
        contentSelectionButtonsPanel.add((Component)this.buttonSelectFolder, "align right, width 175px, gaptop 5, gapright 5, gapbottom 5");
        torrentContentsPanel.add((Component)contentSelectionButtonsPanel, "width 380px, align right, gaptop 5, gapright 5, gapbottom 5");
        this.basicTorrentPane.add((Component)torrentContentsPanel, "growx, wrap");
    }

    private void initTorrentTracking() {
        JPanel torrentTrackingPanel = new JPanel(new MigLayout("fill"));
        GUIUtils.setTitledBorderOnPanel(torrentTrackingPanel, I18n.tr("Torrent Properties"));
        this.checkUseDHT = new JCheckBox(I18n.tr("Trackerless Torrent (DHT)"), true);
        this.checkUseDHT.setToolTipText(I18n.tr("Select this option to create torrents that don't need trackers, completely descentralized. (Recommended)"));
        torrentTrackingPanel.add((Component)this.checkUseDHT, "align left, gapleft 5");
        this.checkStartSeeding = new JCheckBox(I18n.tr("Start seeding"), true);
        this.checkStartSeeding.setToolTipText(I18n.tr("Announce yourself as a seed for the content indexed by this torrent as soon as it's created.\nIf nobody is seeding the torrent, it won't work. (Recommended)"));
        torrentTrackingPanel.add((Component)this.checkStartSeeding, "align right, gapright 10, wrap");
        this.labelTrackers = new JLabel("<html><p>" + I18n.tr("Tracker Announce URLs") + "</p><p>(" + I18n.tr("One tracker per line") + ")</p></html>");
        this.labelTrackers.setToolTipText(I18n.tr("Enter a list of valid BitTorrent Tracker Server URLs.\nYour new torrent will be announced to these trackers if you start seeding the torrent."));
        torrentTrackingPanel.add((Component)this.labelTrackers, "aligny top, pushy, growx 40, gapleft 5, gapright 10, wmin 150px");
        this.textTrackers = new JTextArea(10, 70);
        ThemeMediator.fixKeyStrokes(this.textTrackers);
        this.textTrackers.setToolTipText(this.labelTrackers.getToolTipText());
        this.textTrackers.setLineWrap(false);
        this.textTrackers.setText("udp://open.demonii.com:1337\nudp://tracker.coppersurfer.tk:6969\nudp://tracker.leechers-paradise.org:6969\nudp://exodus.desync.com:6969\nudp://tracker.pomf.se");
        this.textTrackersScrollPane = new JScrollPane(this.textTrackers);
        torrentTrackingPanel.add((Component)this.textTrackersScrollPane, "gapright 5, gapleft 80, gapbottom 5, hmin 165px, growx 60, growy, wrap");
        JLabel _labelWebseeds = new JLabel(I18n.tr("Web Seeds Mirror URLs"));
        _labelWebseeds.setToolTipText(I18n.tr("If these files can be downloaded from the web, enter the URLs of each possible mirror, one per line (GetRight style)."));
        torrentTrackingPanel.add((Component)_labelWebseeds, "aligny top, pushy, gapleft 5, gapright 10, wmin 150px");
        this.textWebSeeds = new JTextArea(4, 70);
        ThemeMediator.fixKeyStrokes(this.textWebSeeds);
        torrentTrackingPanel.add((Component)new JScrollPane(this.textWebSeeds), "gapright 5, gapleft 80, gapbottom 5, hmin 165px, growx 60, growy, wrap");
        JLabel labelPieceSize = new JLabel(I18n.tr("Piece Size"));
        torrentTrackingPanel.add((Component)labelPieceSize, "aligny top, pushy, gapleft 5, gapright 10, wmin 150px");
        this.pieceSizeComboBox = new JComboBox<PieceSize>(values);
        torrentTrackingPanel.add(this.pieceSizeComboBox, "gapright 5, gapleft 80, width 175px");
        this.updateTrackerRelatedControlsAvailability(true);
        this.basicTorrentPane.add((Component)torrentTrackingPanel, "grow, push");
    }

    private void initSaveCloseButtons() {
        JPanel buttonContainer = new JPanel();
        buttonContainer.setLayout(new MigLayout("fillx, insets 5 5 5 5"));
        this.buttonSaveAs = new JButton(I18n.tr("Save torrent as..."));
        buttonContainer.add((Component)this.buttonSaveAs, "pushx, alignx right, gapleft 5");
        this.buttonClose = new JButton(I18n.tr("Close"));
        buttonContainer.add((Component)this.buttonClose, "alignx right, gapright 5");
        this.container.add((Component)buttonContainer, "alignx right, pushx");
    }

    private void initProgressBar() {
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.container.add((Component)this.progressBar, "growx, gap 5px 0, wrap");
    }

    private void buildListeners() {
        this.buttonSelectFile.addActionListener(arg0 -> this.onButtonSelectFile());
        this.buttonSelectFolder.addActionListener(e -> this.onButtonSelectFolder());
        this.buttonClose.addActionListener(this::onButtonClose);
        this.buttonSaveAs.addActionListener(arg0 -> this.onButtonSaveAs());
        this.checkUseDHT.addChangeListener(arg0 -> {
            boolean useDHT = this.checkUseDHT.isSelected();
            this.updateTrackerRelatedControlsAvailability(useDHT);
        });
        this.textTrackers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (CreateTorrentDialog.this.checkUseDHT.isSelected()) {
                    CreateTorrentDialog.this.checkUseDHT.setSelected(false);
                }
            }
        });
        this.pieceSizeComboBox.addActionListener(e -> this.onPieceSizeSelected(this.pieceSizeComboBox.getSelectedIndex()));
    }

    private void onPieceSizeSelected(int selectedIndex) {
        if (selectedIndex > 0 && values.length > selectedIndex && values[selectedIndex] != null) {
            this.pieceSize = values[selectedIndex].bytes();
        }
    }

    private void updateTrackerRelatedControlsAvailability(boolean useDHT) {
        this.labelTrackers.setEnabled(!useDHT);
        this.textTrackers.setEnabled(!useDHT);
        this.textTrackersScrollPane.setEnabled(!useDHT);
        this.textTrackersScrollPane.getHorizontalScrollBar().setEnabled(!useDHT);
        this.textTrackersScrollPane.getVerticalScrollBar().setEnabled(!useDHT);
        this.labelTrackers.setForeground(useDHT ? Color.GRAY : Color.BLACK);
    }

    private void onButtonClose(ActionEvent e) {
        GUIUtils.getDisposeAction().actionPerformed(e);
    }

    private void showFileChooser(final int fileFolderChoosingMode) {
        FileFilter directoryFilesAllowedFilter = new FileFilter(this){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.isFile();
            }

            @Override
            public String getDescription() {
                String desc = I18n.tr("Select a single file or one directory");
                if (fileFolderChoosingMode == 0) {
                    desc = I18n.tr("Select a single file");
                } else if (fileFolderChoosingMode == 1) {
                    desc = I18n.tr("Select a single directory");
                }
                return desc;
            }
        };
        File directory = FileChooserHandler.getLastInputDirectory();
        File chosenFile = null;
        if (fileFolderChoosingMode == 0) {
            chosenFile = FileChooserHandler.getInputFile(GUIMediator.getAppFrame(), I18n.tr("Select a single file"), directory, directoryFilesAllowedFilter);
        } else if (fileFolderChoosingMode == 1) {
            chosenFile = FileChooserHandler.getInputDirectory(GUIMediator.getAppFrame(), I18n.tr("Select a single directory"), I18n.tr("Select folder"), directory, directoryFilesAllowedFilter);
        }
        if (chosenFile != null) {
            FileChooserHandler.setLastInputDirectory(chosenFile);
            this.setChosenContent(chosenFile, fileFolderChoosingMode);
        }
    }

    public void setChosenContent(File chosenFile, int fileChoosingMode) {
        if (!chosenFile.canRead()) {
            this.textSelectedContent.setText(I18n.tr("Error: You can't read on that file/folder."));
            return;
        }
        chosenFile = this.correctFileSelectionMode(chosenFile, fileChoosingMode);
        this.setTorrentPathFromChosenFile(chosenFile);
        this.displayChosenContent(chosenFile);
    }

    private void displayChosenContent(File chosenFile) {
        String prefix = chosenFile.isFile() ? "[file] " : "[folder] ";
        this.textSelectedContent.setText(prefix + chosenFile.getAbsolutePath());
    }

    private void setTorrentPathFromChosenFile(File chosenFile) {
        try {
            File canonicalFile = chosenFile.getCanonicalFile();
            if (canonicalFile.isFile()) {
                this.create_from_dir = false;
                this.directoryPath = null;
                this.singlePath = chosenFile.getAbsolutePath();
            } else if (canonicalFile.isDirectory()) {
                this.create_from_dir = true;
                this.directoryPath = chosenFile.getAbsolutePath();
                this.singlePath = null;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private File correctFileSelectionMode(File chosenFile, int fileSelectionMode) {
        if (fileSelectionMode == 1 && chosenFile.isFile()) {
            chosenFile = chosenFile.getParentFile();
        }
        this.create_from_dir = chosenFile.isDirectory();
        return chosenFile;
    }

    private void onContentSelectionButton(int onContentSelectionButton) {
        this.showFileChooser(onContentSelectionButton);
        this.revertSaveCloseButtons();
    }

    private void onButtonSelectFile() {
        this.onContentSelectionButton(0);
    }

    private void onButtonSelectFolder() {
        this.onContentSelectionButton(1);
    }

    private void onButtonSaveAs() {
        boolean useTrackers;
        File[] fileArray;
        if (this.singlePath == null && this.directoryPath == null) {
            JOptionPane.showMessageDialog(this, I18n.tr("Please select a file or a folder.\nYour new torrent will need content to index."), I18n.tr("Something's missing"), 0);
            this.tabbedPane.setSelectedIndex(0);
            return;
        }
        if (this.directoryPath != null && (fileArray = new File(this.directoryPath).listFiles()) != null && fileArray.length == 0) {
            JOptionPane.showMessageDialog(this, I18n.tr("The folder you selected is empty."), I18n.tr("Invalid Folder"), 0);
            this.tabbedPane.setSelectedIndex(0);
            return;
        }
        boolean bl = useTrackers = !this.checkUseDHT.isSelected();
        if (useTrackers) {
            if (!this.validateAndFixTrackerURLS()) {
                if (this.invalidTrackerURL == null) {
                    this.invalidTrackerURL = "";
                }
                JOptionPane.showMessageDialog(this, I18n.tr("Check again your tracker URL(s).\n" + this.invalidTrackerURL), I18n.tr("Invalid Tracker URL\n"), 0);
                return;
            }
        } else {
            this.trackers.clear();
        }
        this.autoOpen = this.checkStartSeeding.isSelected();
        if (!this.showSaveAsDialog()) {
            return;
        }
        new Thread(() -> {
            if (this.makeTorrent()) {
                this.revertSaveCloseButtons();
                this.progressBar.setString(I18n.tr("Torrent Created."));
                SwingUtilities.invokeLater(this::dispose);
                if (this.autoOpen) {
                    SwingUtilities.invokeLater(() -> GUIMediator.instance().openTorrentForSeed(new File(this.dotTorrentSavePath), this.saveDir));
                }
            }
        }).start();
    }

    private boolean showSaveAsDialog() {
        FileFilter saveAsFilter = new FileFilter(this){

            @Override
            public String getDescription() {
                return I18n.tr("Torrent File");
            }

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".torrent");
            }
        };
        File torrContents = this.create_from_dir ? new File(this.directoryPath) : new File(this.singlePath);
        File suggestedFile = new File(SharingSettings.DEFAULT_TORRENTS_DIR, torrContents.getName() + ".torrent");
        File chosenFile = FileChooserHandler.getSaveAsFile(I18n.tr("Save .torrent"), suggestedFile, saveAsFilter);
        if (chosenFile == null) {
            this.dotTorrentSavePath = null;
            return false;
        }
        this.dotTorrentSavePath = chosenFile.getAbsolutePath();
        if (!this.dotTorrentSavePath.endsWith(".torrent")) {
            this.dotTorrentSavePath = this.dotTorrentSavePath + ".torrent";
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean validateAndFixTrackerURLS() {
        String trackersText = this.textTrackers.getText();
        if (trackersText == null || trackersText.length() == 0) {
            return false;
        }
        String patternStr = "^(https?|udp)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        Pattern pattern = Pattern.compile(patternStr);
        String[] tracker_urls = trackersText.split("\n");
        ArrayList<String> valid_tracker_urls = new ArrayList<String>();
        for (String string : tracker_urls) {
            void var9_9;
            Matcher matcher;
            if (string.trim().equals("")) continue;
            if (!(string.startsWith("http://") || string.startsWith("https://") || string.startsWith("udp://"))) {
                String string2 = "http://" + string.trim();
            }
            if (!(matcher = pattern.matcher(var9_9.trim())).matches()) {
                this.invalidTrackerURL = var9_9.trim();
                return false;
            }
            valid_tracker_urls.add(var9_9.trim());
        }
        this.fixValidTrackers(valid_tracker_urls);
        this.trackers.clear();
        this.trackers.addAll(valid_tracker_urls);
        this.invalidTrackerURL = null;
        return true;
    }

    private void fixValidTrackers(List<String> valid_tracker_urls) {
        StringBuilder builder = new StringBuilder();
        for (String valid_tracker_url : valid_tracker_urls) {
            builder.append(valid_tracker_url);
            builder.append("\n");
        }
        this.textTrackers.setText(builder.toString());
    }

    private boolean makeTorrent() {
        boolean result;
        this.disableSaveCloseButtons();
        File f = new File(this.create_from_dir ? this.directoryPath : this.singlePath);
        try {
            file_storage fs = new file_storage();
            this.reportCurrentTask(I18n.tr("Adding files..."));
            libtorrent.add_files(fs, f.getPath());
            create_torrent torrent = new create_torrent(fs, this.pieceSize);
            torrent.set_priv(false);
            torrent.set_creator("FrostWire " + FrostWireUtils.getFrostWireVersion() + " build " + FrostWireUtils.getBuildNumber());
            if (this.trackers != null && !this.trackers.isEmpty()) {
                this.reportCurrentTask(I18n.tr("Adding trackers..."));
                for (String trackerUrl : this.trackers) {
                    torrent.add_tracker(trackerUrl, 0);
                }
            }
            if (this.addAvailableWebSeeds(torrent, this.create_from_dir)) {
                this.reportCurrentTask(I18n.tr("Calculating piece hashes..."));
                this.saveDir = f.getParentFile();
                error_code ec = new error_code();
                libtorrent.set_piece_hashes(torrent, this.saveDir.getAbsolutePath(), ec);
                this.reportCurrentTask(I18n.tr("Generating torrent entry..."));
                Entry entry2 = new Entry(torrent.generate());
                Map<String, Entry> entryMap = entry2.dictionary();
                this.addAvailablePaymentOptions(entryMap);
                this.addAvailableCopyrightLicense(entryMap);
                File torrent_file = new File(this.dotTorrentSavePath);
                this.reportCurrentTask(I18n.tr("Saving torrent to disk..."));
                Entry entryFromUpdatedMap = CreateTorrentDialog.entryFromMap(entryMap);
                byte[] bencoded_torrent_bytes = entryFromUpdatedMap.bencode();
                FileOutputStream fos = new FileOutputStream(torrent_file);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                bos.write(bencoded_torrent_bytes);
                bos.flush();
                bos.close();
                result = true;
                this.reportCurrentTask("");
            } else {
                result = false;
                this.revertSaveCloseButtons();
                this.textWebSeeds.selectAll();
            }
        }
        catch (Throwable e) {
            result = false;
            this.revertSaveCloseButtons();
            LOG.error(e.getMessage(), e);
            this.reportCurrentTask(I18n.tr("Operation failed."));
        }
        return result;
    }

    private boolean addAvailableWebSeeds(create_torrent torrent, boolean isMultiFile) {
        List<String> mirrors;
        boolean result = true;
        if (this.textWebSeeds.getText().length() > 0 && !(mirrors = Arrays.asList(this.textWebSeeds.getText().split("\n"))).isEmpty()) {
            this.reportCurrentTask(I18n.tr("Checking Web seed mirror URLs..."));
            for (String mirror : mirrors) {
                if (isMultiFile && !mirror.endsWith("/")) {
                    this.fixWebSeedMirrorUrl(mirror);
                }
                if (this.checkWebSeedMirror(mirror, torrent, isMultiFile)) continue;
                result = false;
                this.showWebseedsErrorMessage(new Exception(this.getWebSeedTestPath(mirror, torrent, isMultiFile) + " " + I18n.tr("Web seed not reachable.")));
                break;
            }
            if (result) {
                for (String mirror : mirrors) {
                    torrent.add_url_seed(mirror);
                }
                result = true;
            }
        }
        return result;
    }

    private void fixWebSeedMirrorUrl(String mirror) {
        GUIMediator.safeInvokeLater(() -> {
            String text = this.textWebSeeds.getText();
            this.textWebSeeds.setText(text.replaceAll(mirror, mirror + "/"));
        });
    }

    private boolean checkWebSeedMirror(String mirror, create_torrent torrent, boolean isMultiFile) {
        String urlPath = this.getWebSeedTestPath(mirror, torrent, isMultiFile);
        HttpClient browser = HttpClientFactory.getInstance(HttpClientFactory.HttpContext.MISC);
        int responseCode = 500;
        try {
            responseCode = browser.head(urlPath, 2000, null);
            System.out.println(responseCode + ": " + urlPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return responseCode == 200;
    }

    private String getWebSeedTestPath(String mirror, create_torrent torrent, boolean isMultiFile) {
        Object urlPath;
        if (isMultiFile && !((String)mirror).endsWith("/")) {
            mirror = (String)mirror + "/";
        }
        if (isMultiFile) {
            file_storage files = torrent.files();
            urlPath = (String)mirror + files.name() + "/" + files.file_path(0);
        } else {
            urlPath = mirror;
        }
        return urlPath;
    }

    private void addAvailableCopyrightLicense(Map<String, Entry> entryMap) {
        CopyrightLicenseBroker license;
        if (this.licenseSelectorPanel.hasConfirmedRightfulUseOfLicense() && (license = this.licenseSelectorPanel.getLicenseBroker()) != null) {
            Map<String, Entry> info = entryMap.get("info").dictionary();
            info.put("license", Entry.fromMap(license.asMap()));
            entryMap.put("info", Entry.fromMap(info));
        }
    }

    private void addAvailablePaymentOptions(Map<String, Entry> entryMap) {
        PaymentOptions paymentOptions;
        if (this.paymentOptionsPanel.hasPaymentOptions() && (paymentOptions = this.paymentOptionsPanel.getPaymentOptions()) != null) {
            Map<String, Entry> info = entryMap.get("info").dictionary();
            info.put("paymentOptions", Entry.fromMap(paymentOptions.asMap()));
            entryMap.put("info", Entry.fromMap(info));
        }
    }

    private void revertSaveCloseButtons() {
        this.buttonSaveAs.setText(I18n.tr("Save torrent as..."));
        this.buttonSaveAs.setEnabled(true);
        this.buttonClose.setEnabled(true);
    }

    private void disableSaveCloseButtons() {
        SwingUtilities.invokeLater(() -> {
            this.buttonSaveAs.setText(I18n.tr("Saving Torrent..."));
            this.buttonSaveAs.setEnabled(false);
            this.buttonClose.setEnabled(false);
        });
    }

    private void showWebseedsErrorMessage(Exception webSeedsException) {
        Exception e = webSeedsException;
        this.reportCurrentTask(e.getMessage());
        GUIMediator.safeInvokeLater(() -> GUIMediator.showError(e.getMessage()));
    }

    private void reportCurrentTask(String task_description) {
        SwingUtilities.invokeLater(() -> this.progressBar.setString(task_description));
    }

    private static enum PieceSize {
        AUTO_DETECT(0, "(" + I18n.tr("Auto Detect") + ")"),
        _16KB(16),
        _32KB(32),
        _64KB(64),
        _128KB(128),
        _256KB(256),
        _512KB(512),
        _1024KB(1024),
        _2048KB(2048),
        _4096KB(4096);

        private final int kb;
        private final String humanRep;

        private PieceSize(int k, String rep) {
            this.kb = k;
            this.humanRep = rep;
        }

        private PieceSize(int k) {
            this(k, k + " kB");
        }

        int bytes() {
            return this.kb * 1024;
        }

        public String toString() {
            return this.humanRep;
        }
    }
}

