/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.bittorrent.CopyrightLicenseBroker;
import com.frostwire.gui.bittorrent.LicenseToggleButton;
import com.frostwire.gui.bittorrent.LicenseToggleButtonOnToggleListener;
import com.frostwire.licenses.License;
import com.frostwire.licenses.Licenses;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LimeTextField;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

class CopyrightLicenseSelectorPanel
extends JPanel {
    private static final String CREATIVE_COMMONS_CARD_NAME = I18n.tr("Creative Commons");
    private static final String OPEN_SOURCE_CARD_NAME = I18n.tr("Open Source");
    private static final String PUBLIC_DOMAIN_CARD_NAME = I18n.tr("Public Domain");
    private final JCheckBox confirmRightfulUseOfLicense;
    private final JLabel authorsNameLabel;
    private final LimeTextField authorsName;
    private final JLabel titleLabel;
    private final LimeTextField title;
    private final JLabel attributionUrlLabel;
    private final LimeTextField attributionUrl;
    private final JPanel licenseTypesCardLayoutContainer;
    private final JRadioButton licenseTypeCC;
    private final JRadioButton licenseTypeOpenSource;
    private final JRadioButton licenseTypePublicDomain;
    private final LicenseToggleButton ccButton;
    private final LicenseToggleButton byButton;
    private final LicenseToggleButton ncButton;
    private final LicenseToggleButton ndButton;
    private final LicenseToggleButton saButton;
    private final LicenseToggleButton apacheButton;
    private final LicenseToggleButton bsd2ClauseButton;
    private final LicenseToggleButton bsd3ClauseButton;
    private final LicenseToggleButton gpl3Button;
    private final LicenseToggleButton lgplButton;
    private final LicenseToggleButton mitButton;
    private final LicenseToggleButton mozillaButton;
    private final LicenseToggleButton cddlButton;
    private final LicenseToggleButton eclipseButton;
    private final List<LicenseToggleButton> openSourceLicenseButtons;
    private final LicenseToggleButton cc0Button;
    private final LicenseToggleButton publicDomainButton;
    private final JButton pickedLicenseLabel;
    private CopyrightLicenseBroker licenseBroker;

    CopyrightLicenseSelectorPanel() {
        this.setLayout(new MigLayout("fill"));
        GUIUtils.setTitledBorderOnPanel(this, I18n.tr("Choose a Copyright License for this work"));
        this.confirmRightfulUseOfLicense = new JCheckBox("<html><strong>" + I18n.tr("I am the Content Creator of this work or I have been granted the rights to share this content under the following license by the Content Creator(s).") + "</strong></html>");
        this.authorsNameLabel = new JLabel("<html>" + I18n.tr("Author's Name") + "</html>");
        this.authorsName = new LimeTextField();
        this.authorsName.setToolTipText(I18n.tr("The name of the creator or creators of this work."));
        this.titleLabel = new JLabel("<html>" + I18n.tr("Work's Title") + "</html>");
        this.title = new LimeTextField();
        this.title.setToolTipText(I18n.tr("The name of this work, i.e. the titleLabel of a music album, the titleLabel of a book, the titleLabel of a movie, etc."));
        this.title.setPrompt(I18n.tr("album name, movie title, book title, game title."));
        this.attributionUrlLabel = new JLabel("<html>" + I18n.tr("Attribution URL") + "</html>");
        this.attributionUrl = new LimeTextField();
        this.attributionUrl.setToolTipText(I18n.tr("The Content Creator's website to give attribution about this work if shared by others."));
        this.attributionUrl.setPrompt("http://www.contentcreator.com/website/here");
        this.licenseTypesCardLayoutContainer = new JPanel(new CardLayout());
        this.licenseTypeCC = new JRadioButton(I18n.tr(CREATIVE_COMMONS_CARD_NAME));
        this.licenseTypeOpenSource = new JRadioButton(I18n.tr(OPEN_SOURCE_CARD_NAME));
        this.licenseTypePublicDomain = new JRadioButton(I18n.tr(PUBLIC_DOMAIN_CARD_NAME));
        this.ccButton = new LicenseToggleButton(LicenseToggleButton.LicenseIcon.CC, CREATIVE_COMMONS_CARD_NAME, I18n.tr("Offering your work under a Creative Commons license does not mean giving up your copyright. It means offering some of your rights to any member of the public but only under certain conditions."), true, false);
        this.byButton = new LicenseToggleButton(LicenseToggleButton.LicenseIcon.BY, "Attribution", I18n.tr("You let others copy, distribute, display, and perform your copyrighted work but only if they give credit the way you request."), true, false);
        this.ncButton = new LicenseToggleButton(LicenseToggleButton.LicenseIcon.NC, "NonCommercial", I18n.tr("<strong>No commercial use allowed.</strong><br>You let others copy, distribute, display, and perform your work &mdash; and derivative works based upon it &mdash; but for noncommercial purposes only."), true, true);
        this.ndButton = new LicenseToggleButton(LicenseToggleButton.LicenseIcon.ND, "NoDerivatives", I18n.tr("<strong>No remixing allowed.</strong><br>You let others copy, distribute, display, and perform only verbatim copies of your work, not derivative works based upon it."), false, true);
        this.saButton = new LicenseToggleButton(LicenseToggleButton.LicenseIcon.SA, "Share-Alike", I18n.tr("You allow others to distribute derivative works only under a license identical to the license that governs your work."), true, true);
        this.apacheButton = new LicenseToggleButton(LicenseToggleButton.LicenseIcon.APACHE, "Apache 2.0", "Apache License 2.0", false, true);
        this.bsd2ClauseButton = new LicenseToggleButton(LicenseToggleButton.LicenseIcon.BSD, "BSD 2-Clause", "BSD 2-Clause \"Simplified\" or \"FreeBSD\" license.", false, true);
        this.bsd3ClauseButton = new LicenseToggleButton(LicenseToggleButton.LicenseIcon.BSD, "BSD 3-Clause", "BSD 3-Clause \"New\" or \"Revised\" license.", false, true);
        this.gpl3Button = new LicenseToggleButton(LicenseToggleButton.LicenseIcon.GPL3, "GPLv3", "GNU General Public License (GPL) version 3", false, true);
        this.lgplButton = new LicenseToggleButton(LicenseToggleButton.LicenseIcon.LGPL3, "LGPL", "GNU Library or \"Lesser\" General Public License (LGPL)", false, true);
        this.mozillaButton = new LicenseToggleButton(LicenseToggleButton.LicenseIcon.MOZILLA, "Mozilla 2.0", "Mozilla Public License 2.0", false, true);
        this.mitButton = new LicenseToggleButton(LicenseToggleButton.LicenseIcon.OPENSOURCE, "MIT", "MIT license", false, true);
        this.cddlButton = new LicenseToggleButton(LicenseToggleButton.LicenseIcon.OPENSOURCE, "CDDL-1.0", "Common Development and Distribution License (CDDL-1.0)", false, true);
        this.eclipseButton = new LicenseToggleButton(LicenseToggleButton.LicenseIcon.OPENSOURCE, "EPL-1.0", "Eclipse Public License, Vesion 1.0 (EPL-1.0)", false, true);
        this.openSourceLicenseButtons = new LinkedList<LicenseToggleButton>();
        this.initOpenSourceButtonList();
        this.publicDomainButton = new LicenseToggleButton(LicenseToggleButton.LicenseIcon.PUBLICDOMAIN, "Public Domain Mark 1.0", I18n.tr("This work has been identified as being free of known restrictions under copyright law, including all related and neighboring rights."), true, true);
        this.cc0Button = new LicenseToggleButton(LicenseToggleButton.LicenseIcon.CC0, "CC0 1.0", I18n.tr("The person who associated a work with this deed has dedicated the work to the public domain by waiving all of his or her rights to the work worldwide under copyright law, including all related and neighboring rights, to the extent allowed by law."), false, true);
        this.pickedLicenseLabel = new JButton();
        this.initListeners();
        this.initComponents();
    }

    CopyrightLicenseBroker getLicenseBroker() {
        return this.licenseBroker;
    }

    boolean hasConfirmedRightfulUseOfLicense() {
        return this.confirmRightfulUseOfLicense.isSelected();
    }

    private void initOpenSourceButtonList() {
        this.openSourceLicenseButtons.add(this.apacheButton);
        this.openSourceLicenseButtons.add(this.bsd2ClauseButton);
        this.openSourceLicenseButtons.add(this.bsd3ClauseButton);
        this.openSourceLicenseButtons.add(this.gpl3Button);
        this.openSourceLicenseButtons.add(this.lgplButton);
        this.openSourceLicenseButtons.add(this.mozillaButton);
        this.openSourceLicenseButtons.add(this.mitButton);
        this.openSourceLicenseButtons.add(this.cddlButton);
        this.openSourceLicenseButtons.add(this.eclipseButton);
    }

    private void onCreativeCommonsButtonToggled(LicenseToggleButton button) {
        if (this.confirmRightfulUseOfLicense.isSelected()) {
            if (button.getLicenseIcon() == LicenseToggleButton.LicenseIcon.ND && button.isSelected()) {
                this.saButton.setSelected(false);
            } else if (button.getLicenseIcon() == LicenseToggleButton.LicenseIcon.SA && button.isSelected()) {
                this.ndButton.setSelected(false);
            }
            this.updatePickedLicenseLabel();
        }
    }

    private void onOpenSourceButtonToggled(LicenseToggleButton button) {
        for (LicenseToggleButton b : this.openSourceLicenseButtons) {
            if (b == button) continue;
            b.setSelected(false);
        }
        button.setSelected(true);
        this.updatePickedLicenseLabel();
    }

    private void onPublicDomainButtonToggled(LicenseToggleButton button) {
        if (button == this.cc0Button) {
            this.publicDomainButton.setSelected(false);
        } else {
            this.cc0Button.setSelected(false);
        }
        button.setSelected(true);
        this.updatePickedLicenseLabel();
    }

    private void updatePickedLicenseLabel() {
        if (this.licenseTypeCC.isSelected()) {
            this.updateCreativeCommonsPickedLicenseLabel();
        } else if (this.licenseTypeOpenSource.isSelected()) {
            this.updateOpenSourcePickedLicenseLabel();
        } else if (this.licenseTypePublicDomain.isSelected()) {
            this.updatePublicDomainPickedLicenseLabel();
        }
    }

    private void updateCreativeCommonsPickedLicenseLabel() {
        this.updateLicenseBrokerWithCreativeCommonsLicense();
        this.updateLicenseLabel();
    }

    private void updateLicenseBroker(License license, CopyrightLicenseBroker.LicenseCategory category) {
        if (license != null) {
            this.licenseBroker = new CopyrightLicenseBroker(category, license, this.title.getText(), this.authorsName.getText(), this.attributionUrl.getText());
        }
    }

    private void updateLicenseLabel() {
        if (this.licenseBroker != null) {
            this.pickedLicenseLabel.setText("<html>" + I18n.tr("You have selected the following License") + ":<br> <a href=\"" + this.licenseBroker.license.getUrl() + "\">" + this.licenseBroker.getLicenseName() + "</a>");
            ActionListener[] actionListeners = this.pickedLicenseLabel.getActionListeners();
            if (actionListeners != null) {
                for (ActionListener listener : actionListeners) {
                    this.pickedLicenseLabel.removeActionListener(listener);
                }
            }
            this.pickedLicenseLabel.addActionListener(e -> GUIMediator.openURL(this.licenseBroker.license.getUrl()));
        } else {
            this.pickedLicenseLabel.setText("");
        }
    }

    private void updateOpenSourcePickedLicenseLabel() {
        this.licenseBroker = null;
        License license = null;
        if (this.apacheButton.isSelected()) {
            license = Licenses.APACHE;
        } else if (this.bsd2ClauseButton.isSelected()) {
            license = Licenses.BSD_2_CLAUSE;
        } else if (this.bsd3ClauseButton.isSelected()) {
            license = Licenses.BSD_3_CLAUSE;
        } else if (this.gpl3Button.isSelected()) {
            license = Licenses.GPL3;
        } else if (this.lgplButton.isSelected()) {
            license = Licenses.LGPL;
        } else if (this.mitButton.isSelected()) {
            license = Licenses.MIT;
        } else if (this.mozillaButton.isSelected()) {
            license = Licenses.MOZILLA;
        } else if (this.cddlButton.isSelected()) {
            license = Licenses.CDDL;
        } else if (this.eclipseButton.isSelected()) {
            license = Licenses.ECLIPSE;
        }
        this.updateLicenseBroker(license, CopyrightLicenseBroker.LicenseCategory.OpenSource);
        this.updateLicenseLabel();
    }

    private void updatePublicDomainPickedLicenseLabel() {
        this.licenseBroker = null;
        License license = Licenses.PUBLIC_DOMAIN_MARK;
        if (this.publicDomainButton.isSelected()) {
            license = Licenses.PUBLIC_DOMAIN_MARK;
        } else if (this.cc0Button.isSelected()) {
            license = Licenses.PUBLIC_DOMAIN_CC0;
        }
        this.updateLicenseBroker(license, CopyrightLicenseBroker.LicenseCategory.PublicDomain);
        this.updateLicenseLabel();
    }

    private void updateLicenseBrokerWithCreativeCommonsLicense() {
        this.licenseBroker = null;
        if (this.hasConfirmedRightfulUseOfLicense() && this.licenseTypeCC.isSelected()) {
            this.licenseBroker = new CopyrightLicenseBroker(this.saButton.isSelected(), this.ncButton.isSelected(), this.ndButton.isSelected(), this.title.getText(), this.authorsName.getText(), this.attributionUrl.getText());
        }
    }

    private void initListeners() {
        this.confirmRightfulUseOfLicense.addActionListener(e -> this.onConfirmRightfulUseOfLicenseAction());
        this.initLicenseTypeRadioButtonsListener();
        this.initCreativeCommonsLicenseToggleListeners();
        this.initOpenSourceLicensesToggleListeners();
        this.initPublicDomainToggleListeners();
    }

    private void initOpenSourceLicensesToggleListeners() {
        LicenseToggleButtonOnToggleListener openSourceToggleListener = this::onOpenSourceButtonToggled;
        this.apacheButton.setOnToggleListener(openSourceToggleListener);
        this.bsd2ClauseButton.setOnToggleListener(openSourceToggleListener);
        this.bsd3ClauseButton.setOnToggleListener(openSourceToggleListener);
        this.cddlButton.setOnToggleListener(openSourceToggleListener);
        this.eclipseButton.setOnToggleListener(openSourceToggleListener);
        this.gpl3Button.setOnToggleListener(openSourceToggleListener);
        this.lgplButton.setOnToggleListener(openSourceToggleListener);
        this.mitButton.setOnToggleListener(openSourceToggleListener);
        this.mozillaButton.setOnToggleListener(openSourceToggleListener);
        this.updatePickedLicenseLabel();
    }

    private void initCreativeCommonsLicenseToggleListeners() {
        LicenseToggleButtonOnToggleListener ccToggleListener = this::onCreativeCommonsButtonToggled;
        this.ncButton.setOnToggleListener(ccToggleListener);
        this.ndButton.setOnToggleListener(ccToggleListener);
        this.saButton.setOnToggleListener(ccToggleListener);
    }

    private void initPublicDomainToggleListeners() {
        LicenseToggleButtonOnToggleListener pdToggleListener = this::onPublicDomainButtonToggled;
        this.cc0Button.setOnToggleListener(pdToggleListener);
        this.publicDomainButton.setOnToggleListener(pdToggleListener);
    }

    private void initLicenseTypeRadioButtonsListener() {
        ActionListener licenseTypeChangeListener = e -> this.onLicenseTypeChanged();
        this.licenseTypeCC.addActionListener(licenseTypeChangeListener);
        this.licenseTypeOpenSource.addActionListener(licenseTypeChangeListener);
        this.licenseTypePublicDomain.addActionListener(licenseTypeChangeListener);
    }

    private void initComponents() {
        this.initCommonComponents();
        this.initCreativeCommonsLicensePanel();
        this.initOpenSourceLicensesPanel();
        this.initPublicDomainLicensePanel();
        this.add((Component)this.licenseTypesCardLayoutContainer, "aligny top, span 2, grow, pushy, gapbottom 5px, wrap");
        this.pickedLicenseLabel.setHorizontalAlignment(2);
        this.pickedLicenseLabel.setBorderPainted(false);
        this.pickedLicenseLabel.setOpaque(false);
        this.pickedLicenseLabel.setContentAreaFilled(false);
        this.pickedLicenseLabel.setFocusPainted(false);
        this.add((Component)this.pickedLicenseLabel, "alignx center, growx, span 2, pushx");
    }

    private void initCreativeCommonsLicensePanel() {
        JPanel licenseButtonsPanel = new JPanel(new MigLayout("fill, insets 0 0 0 0"));
        JLabel label = new JLabel("<html>" + I18n.tr("Select what people can and can't do with this work") + "</html>");
        label.setEnabled(false);
        licenseButtonsPanel.add((Component)label, "span 5, alignx center, pushy, aligny bottom, wrap");
        licenseButtonsPanel.add((Component)this.ccButton, "wmin 130px, aligny top, pushy, grow, gap 2 2 2 2");
        licenseButtonsPanel.add((Component)this.byButton, "wmin 130px, aligny top, pushy, grow, gap 2 2 2 2");
        licenseButtonsPanel.add((Component)this.ncButton, "wmin 130px, aligny top, pushy, grow, gap 2 2 2 2");
        licenseButtonsPanel.add((Component)this.ndButton, "wmin 130px, aligny top, pushy, grow, gap 2 2 2 2");
        licenseButtonsPanel.add((Component)this.saButton, "wmin 130px, aligny top, pushy, grow, gap 2 2 2 2, wrap");
        this.licenseTypesCardLayoutContainer.add((Component)licenseButtonsPanel, CREATIVE_COMMONS_CARD_NAME);
    }

    private void initOpenSourceLicensesPanel() {
        JPanel licenseButtonsPanel = new JPanel(new MigLayout("fill, insets 0 0 0 0"));
        licenseButtonsPanel.add((Component)this.apacheButton, "wmin 130px, aligny top, pushy, grow, gap 2 2 2 2");
        licenseButtonsPanel.add((Component)this.bsd3ClauseButton, "wmin 130px, aligny top, pushy, grow, gap 2 2 2 2");
        licenseButtonsPanel.add((Component)this.bsd2ClauseButton, "wmin 130px, aligny top, pushy, grow, gap 2 2 2 2, wrap");
        licenseButtonsPanel.add((Component)this.gpl3Button, "wmin 130px, aligny top, pushy, grow, gap 2 2 2 2");
        licenseButtonsPanel.add((Component)this.lgplButton, "wmin 130px, aligny top, pushy, grow, gap 2 2 2 2");
        licenseButtonsPanel.add((Component)this.mitButton, "wmin 130px, aligny top, pushy, grow, gap 2 2 2 2, wrap");
        licenseButtonsPanel.add((Component)this.mozillaButton, "wmin 130px, aligny top, pushy, grow, gap 2 2 2 2");
        licenseButtonsPanel.add((Component)this.cddlButton, "wmin 130px, aligny top, pushy, grow, gap 2 2 2 2");
        licenseButtonsPanel.add((Component)this.eclipseButton, "wmin 130px, aligny top, pushy, grow, gap 2 2 2 2");
        JScrollPane scrollPane = new JScrollPane(licenseButtonsPanel);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.licenseTypesCardLayoutContainer.add((Component)scrollPane, OPEN_SOURCE_CARD_NAME);
    }

    private void initPublicDomainLicensePanel() {
        JPanel publicDomainLicensePanel = new JPanel(new MigLayout("fill, insets 0 0 0 0, alignx center"));
        JLabel label = new JLabel(I18n.tr("You can copy, modify, distribute and perform the work, even for commercial purposes, all without asking permission."));
        label.setEnabled(false);
        publicDomainLicensePanel.add((Component)label, "gaptop 10px, aligny center, push, alignx center, span 2, wrap");
        publicDomainLicensePanel.add((Component)this.publicDomainButton, "wmin 400px, aligny top, push, grow, gap 2 2 2 2");
        publicDomainLicensePanel.add((Component)this.cc0Button, "wmin 400px, aligny top, push, grow, gap 2 2 2 2");
        this.licenseTypesCardLayoutContainer.add((Component)publicDomainLicensePanel, PUBLIC_DOMAIN_CARD_NAME);
    }

    private void initCommonComponents() {
        this.confirmRightfulUseOfLicense.setSelected(false);
        this.add((Component)this.confirmRightfulUseOfLicense, "growx, north, gapbottom 8, wrap");
        this.confirmRightfulUseOfLicense.setSelected(false);
        this.onConfirmRightfulUseOfLicenseAction();
        this.add((Component)this.authorsNameLabel, "gapbottom 5px, pushx, wmin 215px");
        this.add((Component)this.titleLabel, "gapbottom 5px, wmin 215px, pushx, wrap");
        this.add((Component)this.authorsName, "gapbottom 5px, growx 50, aligny top, pushy, wmin 215px, height 30px, span 1");
        this.add((Component)this.title, "gapbottom 5px, growx 50, aligny top, pushy, wmin 215px, span 1, height 30px, wrap");
        JPanel attribPanel = new JPanel(new MigLayout("fillx, insets 0 0 0 0"));
        attribPanel.add((Component)this.attributionUrlLabel, "width 110px!, alignx left");
        attribPanel.add((Component)this.attributionUrl, "alignx left, growx, pushx");
        this.add((Component)attribPanel, "aligny top, pushy, growx, gapbottom 10px, span 2, wrap");
        JPanel licenseRadioButtonsContainer = new JPanel(new MigLayout("fillx, insets 0 0 0 0"));
        ButtonGroup group = new ButtonGroup();
        this.licenseTypeCC.setSelected(true);
        this.licenseTypeOpenSource.setSelected(false);
        this.licenseTypePublicDomain.setSelected(false);
        this.licenseTypeCC.setEnabled(false);
        this.licenseTypeOpenSource.setEnabled(false);
        this.licenseTypePublicDomain.setEnabled(false);
        group.add(this.licenseTypeCC);
        group.add(this.licenseTypeOpenSource);
        group.add(this.licenseTypePublicDomain);
        licenseRadioButtonsContainer.add(this.licenseTypeCC);
        licenseRadioButtonsContainer.add(this.licenseTypeOpenSource);
        licenseRadioButtonsContainer.add(this.licenseTypePublicDomain);
        this.add(new JLabel(I18n.tr("License type:")));
        this.add((Component)licenseRadioButtonsContainer, "growx, span 2, wrap");
    }

    private void onLicenseTypeChanged() {
        if (this.confirmRightfulUseOfLicense.isSelected()) {
            System.out.println("onLicenseTypeChanged()");
            CardLayout deck = (CardLayout)this.licenseTypesCardLayoutContainer.getLayout();
            String currentPanelName = null;
            if (this.licenseTypeCC.isSelected()) {
                currentPanelName = CREATIVE_COMMONS_CARD_NAME;
            } else if (this.licenseTypeOpenSource.isSelected()) {
                currentPanelName = OPEN_SOURCE_CARD_NAME;
            } else if (this.licenseTypePublicDomain.isSelected()) {
                currentPanelName = PUBLIC_DOMAIN_CARD_NAME;
            }
            deck.show(this.licenseTypesCardLayoutContainer, currentPanelName);
            this.updatePickedLicenseLabel();
        }
    }

    private void onConfirmRightfulUseOfLicenseAction() {
        boolean rightfulUseConfirmed = this.hasConfirmedRightfulUseOfLicense();
        this.authorsNameLabel.setEnabled(rightfulUseConfirmed);
        this.authorsName.setEnabled(rightfulUseConfirmed);
        this.titleLabel.setEnabled(rightfulUseConfirmed);
        this.title.setEnabled(rightfulUseConfirmed);
        this.attributionUrlLabel.setEnabled(rightfulUseConfirmed);
        this.attributionUrl.setEnabled(rightfulUseConfirmed);
        this.ccButton.setSelected(rightfulUseConfirmed);
        this.byButton.setSelected(rightfulUseConfirmed);
        this.ncButton.setSelected(rightfulUseConfirmed);
        this.ncButton.setToggleable(rightfulUseConfirmed);
        this.ndButton.setToggleable(rightfulUseConfirmed);
        this.saButton.setToggleable(rightfulUseConfirmed);
        this.licenseTypeCC.setEnabled(rightfulUseConfirmed);
        this.licenseTypeOpenSource.setEnabled(rightfulUseConfirmed);
        this.licenseTypePublicDomain.setEnabled(rightfulUseConfirmed);
        this.licenseTypesCardLayoutContainer.setEnabled(rightfulUseConfirmed);
        this.updateOpenSourceLicensesToggleability(rightfulUseConfirmed);
        this.publicDomainButton.setSelected(rightfulUseConfirmed);
        this.cc0Button.setSelected(rightfulUseConfirmed);
        this.publicDomainButton.setToggleable(rightfulUseConfirmed);
        this.cc0Button.setToggleable(rightfulUseConfirmed);
        this.pickedLicenseLabel.setVisible(rightfulUseConfirmed);
        if (rightfulUseConfirmed) {
            this.apacheButton.setSelected(true);
            this.publicDomainButton.setSelected(true);
            this.cc0Button.setSelected(false);
            this.updatePickedLicenseLabel();
        } else {
            this.ndButton.setSelected(false);
            this.saButton.setSelected(false);
            this.publicDomainButton.setSelected(false);
            this.cc0Button.setSelected(false);
            for (LicenseToggleButton licenseToggleButton : this.openSourceLicenseButtons) {
                licenseToggleButton.setSelected(false);
            }
        }
    }

    private void updateOpenSourceLicensesToggleability(boolean toggleable) {
        for (LicenseToggleButton button : this.openSourceLicenseButtons) {
            button.setToggleable(toggleable);
        }
    }
}

