/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.bittorrent.PaymentOptions;
import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.SeedingHolder;
import com.frostwire.gui.bittorrent.SoundcloudDownload;
import com.frostwire.gui.bittorrent.TransferHolder;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.transfers.TransferState;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;
import com.limegroup.gnutella.gui.tables.IconAndNameHolderImpl;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.ProgressBarHolder;
import com.limegroup.gnutella.gui.tables.SeedsHolder;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import com.limegroup.gnutella.gui.tables.SpeedRenderer;
import com.limegroup.gnutella.gui.tables.TimeRemainingHolder;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public final class BTDownloadDataLine
extends AbstractDataLine<BTDownload> {
    static final LimeTableColumn ACTIONS_COLUMN;
    static final LimeTableColumn SEEDING_COLUMN;
    static final LimeTableColumn PAYMENT_OPTIONS_COLUMN;
    static final LimeTableColumn DATE_CREATED_COLUMN;
    private static final String PARTIAL_DOWNLOAD_TEXT;
    private static final List<LimeTableColumn> columns;
    private static final int COLUMN_COUNT;
    private static final LimeTableColumn FILE_COLUMN;
    private static final LimeTableColumn SIZE_COLUMN;
    private static final LimeTableColumn STATUS_COLUMN;
    private static final LimeTableColumn PROGRESS_COLUMN;
    private static final LimeTableColumn BYTES_DOWNLOADED_COLUMN;
    private static final LimeTableColumn BYTES_UPLOADED_COLUMN;
    private static final LimeTableColumn DOWNLOAD_SPEED_COLUMN;
    private static final LimeTableColumn UPLOAD_SPEED_COLUMN;
    private static final LimeTableColumn TIME_COLUMN;
    private static final LimeTableColumn SEEDS_COLUMN;
    private static final LimeTableColumn PEERS_COLUMN;
    private static final LimeTableColumn SHARE_RATIO_COLUMN;
    private static final LimeTableColumn SEED_TO_PEER_RATIO_COLUMN;
    private static final LimeTableColumn LICENSE_COLUMN;
    public static final Map<TransferState, String> TRANSFER_STATE_STRING_MAP;
    private TransferState transferState;
    private long download = 0L;
    private long upload;
    private int progress;
    private double size = -1.0;
    private double downloadSpeed;
    private double uploadSpeed;
    private long timeLeft;
    private String seeds;
    private String peers;
    private String shareRatio;
    private String seedToPeerRatio;
    private Date dateCreated;
    private String license;
    private boolean notificationShown;
    private PaymentOptions paymentOptions;
    private TransferHolder transferHolder;
    private SeedingHolder seedingHolder;

    static LimeTableColumn staticGetColumn(int idx) {
        try {
            return columns.get(idx);
        }
        catch (Throwable t) {
            System.out.println("BTDownloadDataLine::staticGetColumn(" + idx + ") - Index out of bound.");
            return null;
        }
    }

    @Override
    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    @Override
    public void initialize(BTDownload downloader) {
        super.initialize(downloader);
        this.notificationShown = downloader.isCompleted();
        this.transferHolder = new TransferHolder(downloader);
        this.seedingHolder = new SeedingHolder(downloader);
        this.paymentOptions = ((BTDownload)this.initializer).getPaymentOptions();
        this.update();
    }

    public boolean isSeeding() {
        return this.initializer != null && ((BTDownload)this.initializer).getState() == TransferState.SEEDING;
    }

    public boolean isDownloading() {
        TransferState state = ((BTDownload)this.initializer).getState();
        boolean downloading = state == TransferState.CHECKING || state == TransferState.DOWNLOADING || state == TransferState.DOWNLOADING_METADATA || state == TransferState.DOWNLOADING_TORRENT;
        boolean pausedButUnfinished = !((BTDownload)this.initializer).isCompleted() && state == TransferState.PAUSED;
        return this.initializer != null && (downloading || pausedButUnfinished);
    }

    public boolean isFinished() {
        return this.initializer != null && ((BTDownload)this.initializer).isCompleted() && !this.isSeeding();
    }

    public String getDisplayName() {
        if (this.initializer == null) {
            return "";
        }
        return ((BTDownload)this.initializer).getDisplayName();
    }

    @Override
    public Object getValueAt(int index) {
        LimeTableColumn column = columns.get(index);
        if (column == ACTIONS_COLUMN) {
            return this.transferHolder;
        }
        if (column == SEEDING_COLUMN) {
            return this.seedingHolder;
        }
        if (column == FILE_COLUMN) {
            return new IconAndNameHolderImpl(this.getIcon(), ((BTDownload)this.initializer).getDisplayName());
        }
        if (column == PAYMENT_OPTIONS_COLUMN) {
            return this.paymentOptions;
        }
        if (column == SIZE_COLUMN) {
            if (((BTDownload)this.initializer).isPartialDownload()) {
                return new SizeHolder(this.size, PARTIAL_DOWNLOAD_TEXT);
            }
            return new SizeHolder(this.size);
        }
        if (column == STATUS_COLUMN) {
            String status = TRANSFER_STATE_STRING_MAP.get((Object)this.transferState);
            if (status == null) {
                status = I18n.tr("Unknown status");
            }
            return status;
        }
        if (column == PROGRESS_COLUMN) {
            return this.progress;
        }
        if (column == BYTES_DOWNLOADED_COLUMN) {
            return new SizeHolder(this.download);
        }
        if (column == BYTES_UPLOADED_COLUMN) {
            return new SizeHolder(this.upload);
        }
        if (column == DOWNLOAD_SPEED_COLUMN) {
            return this.downloadSpeed;
        }
        if (column == UPLOAD_SPEED_COLUMN) {
            return this.uploadSpeed;
        }
        if (column == TIME_COLUMN) {
            if (((BTDownload)this.initializer).isCompleted()) {
                return new TimeRemainingHolder(0L);
            }
            if (this.downloadSpeed < 0.001) {
                return new TimeRemainingHolder(-1L);
            }
            return new TimeRemainingHolder(this.timeLeft);
        }
        if (column == SEEDS_COLUMN) {
            return new SeedsHolder(this.seeds);
        }
        if (column == PEERS_COLUMN) {
            return this.peers;
        }
        if (column == SHARE_RATIO_COLUMN) {
            return this.shareRatio;
        }
        if (column == SEED_TO_PEER_RATIO_COLUMN) {
            return this.seedToPeerRatio;
        }
        if (column == DATE_CREATED_COLUMN) {
            return this.dateCreated;
        }
        if (column == LICENSE_COLUMN) {
            return this.license;
        }
        return null;
    }

    @Override
    public LimeTableColumn getColumn(int idx) {
        return BTDownloadDataLine.staticGetColumn(idx);
    }

    @Override
    public int getTypeAheadColumn() {
        return FILE_COLUMN.getModelIndex();
    }

    @Override
    public String[] getToolTipArray(int col) {
        String[] info = new String[11];
        String name = ((BTDownload)this.getInitializeObject()).getDisplayName();
        String status = I18n.tr("Status") + ": " + I18n.tr(((BTDownload)this.getInitializeObject()).getState().name());
        String progress = I18n.tr("Progress") + ": " + ((BTDownload)this.getInitializeObject()).getProgress() + "%";
        String downSpeed = I18n.tr("Down Speed") + ": " + GUIUtils.rate2speed(((BTDownload)this.getInitializeObject()).getDownloadSpeed());
        String upSpeed = I18n.tr("Up Speed") + ": " + GUIUtils.rate2speed(((BTDownload)this.getInitializeObject()).getUploadSpeed());
        String downloaded = I18n.tr("Downloaded") + ": " + String.valueOf(new SizeHolder(((BTDownload)this.getInitializeObject()).getBytesReceived()));
        String uploaded = I18n.tr("Uploaded") + ": " + String.valueOf(new SizeHolder(((BTDownload)this.getInitializeObject()).getBytesSent()));
        String peers = I18n.tr("Peers") + ": " + ((BTDownload)this.getInitializeObject()).getPeersString();
        String seeds = I18n.tr("Seeds") + ": " + ((BTDownload)this.getInitializeObject()).getSeedsString();
        String size = I18n.tr("Size") + ": " + String.valueOf(new SizeHolder(((BTDownload)this.getInitializeObject()).getSize()));
        String time = I18n.tr("ETA") + ": " + String.valueOf(((BTDownload)this.getInitializeObject()).isCompleted() ? new TimeRemainingHolder(0L) : (((BTDownload)this.getInitializeObject()).getDownloadSpeed() < 0.001 ? new TimeRemainingHolder(-1L) : new TimeRemainingHolder(((BTDownload)this.getInitializeObject()).getETA())));
        info[0] = name;
        info[1] = status;
        info[2] = progress;
        info[3] = downSpeed;
        info[4] = upSpeed;
        info[5] = downloaded;
        info[6] = uploaded;
        info[7] = peers;
        info[8] = seeds;
        info[9] = size;
        info[10] = time;
        return info;
    }

    private Icon getIcon() {
        if (((BTDownload)this.initializer).isPartialDownload()) {
            try {
                return IconManager.instance().getIconForFile(new File(((BTDownload)this.initializer).getDisplayName()));
            }
            catch (Exception e) {
                return IconManager.instance().getIconForFile(((BTDownload)this.initializer).getSaveLocation());
            }
        }
        if (this.initializer instanceof SoundcloudDownload) {
            return IconManager.instance().getIconForFile(((BTDownload)this.initializer).getSaveLocation());
        }
        return IconManager.instance().getIconForFile(((BTDownload)this.initializer).getSaveLocation());
    }

    @Override
    public void update() {
        this.transferState = ((BTDownload)this.initializer).getState();
        this.progress = ((BTDownload)this.initializer).getProgress();
        this.download = ((BTDownload)this.initializer).getBytesReceived();
        this.upload = ((BTDownload)this.initializer).getBytesSent();
        this.downloadSpeed = ((BTDownload)this.initializer).getDownloadSpeed();
        this.uploadSpeed = ((BTDownload)this.initializer).getUploadSpeed();
        this.timeLeft = ((BTDownload)this.initializer).getETA();
        this.seeds = ((BTDownload)this.initializer).getSeedsString();
        this.peers = ((BTDownload)this.initializer).getPeersString();
        this.shareRatio = ((BTDownload)this.initializer).getShareRatio();
        this.seedToPeerRatio = ((BTDownload)this.initializer).getSeedToPeerRatio();
        this.size = ((BTDownload)this.initializer).getSize();
        this.dateCreated = ((BTDownload)this.initializer).getDateCreated();
        this.license = ((BTDownload)this.initializer).getCopyrightLicenseBroker() != null && ((BTDownload)this.initializer).getCopyrightLicenseBroker().license != null ? ((BTDownload)this.initializer).getCopyrightLicenseBroker().license.getName() : "";
        if (((BTDownload)this.initializer).getPaymentOptions() != null) {
            this.paymentOptions = ((BTDownload)this.initializer).getPaymentOptions();
        }
        if (((BTDownload)this.getInitializeObject()).isCompleted()) {
            this.showNotification();
        }
    }

    private void showNotification() {
        if (!this.notificationShown) {
            this.notificationShown = true;
            BTDownload theDownload = (BTDownload)this.getInitializeObject();
            if (theDownload.isCompleted()) {
                LibraryMediator.instance().getLibraryExplorer().clearDirectoryHolderCaches();
            }
        }
    }

    @Override
    public boolean isDynamic(int col) {
        return false;
    }

    @Override
    public boolean isClippable(int col) {
        return false;
    }

    static {
        PARTIAL_DOWNLOAD_TEXT = I18n.tr(" (Handpicked)");
        TRANSFER_STATE_STRING_MAP = new HashMap<TransferState, String>();
        columns = new ArrayList<LimeTableColumn>();
        ACTIONS_COLUMN = new LimeTableColumn(columns.size(), "TRANSFER_ACTIONS", I18n.tr("Actions"), 65, true, TransferHolder.class);
        columns.add(ACTIONS_COLUMN);
        FILE_COLUMN = new LimeTableColumn(columns.size(), "DOWNLOAD_NAME_COLUMN", I18n.tr("Name"), 232, true, IconAndNameHolder.class);
        columns.add(FILE_COLUMN);
        SEEDING_COLUMN = new LimeTableColumn(columns.size(), "SEEDING_COLUMN", I18n.tr("Seeding"), 67, true, SeedingHolder.class);
        columns.add(SEEDING_COLUMN);
        PAYMENT_OPTIONS_COLUMN = new LimeTableColumn(columns.size(), "PAYMENT_OPTIONS_COLUMN", I18n.tr("Tips/Donations"), 126, true, PaymentOptions.class);
        columns.add(PAYMENT_OPTIONS_COLUMN);
        SIZE_COLUMN = new LimeTableColumn(columns.size(), "DOWNLOAD_SIZE_COLUMN", I18n.tr("Size"), 79, true, SizeHolder.class);
        columns.add(SIZE_COLUMN);
        STATUS_COLUMN = new LimeTableColumn(columns.size(), "DOWNLOAD_STATUS_COLUMN", I18n.tr("Status"), 56, true, String.class);
        columns.add(STATUS_COLUMN);
        PROGRESS_COLUMN = new LimeTableColumn(columns.size(), "DOWNLOAD_PROGRESS_COLUMN", I18n.tr("Progress"), 156, true, ProgressBarHolder.class);
        columns.add(PROGRESS_COLUMN);
        BYTES_DOWNLOADED_COLUMN = new LimeTableColumn(columns.size(), "DOWNLOAD_BYTES_DOWNLOADED_COLUMN", I18n.tr("Downloaded"), 82, true, SizeHolder.class);
        columns.add(BYTES_DOWNLOADED_COLUMN);
        BYTES_UPLOADED_COLUMN = new LimeTableColumn(columns.size(), "DOWNLOAD_BYTES_UPLOADED_COLUMN", I18n.tr("Uploaded"), 20, false, SizeHolder.class);
        columns.add(BYTES_UPLOADED_COLUMN);
        DOWNLOAD_SPEED_COLUMN = new LimeTableColumn(columns.size(), "DOWNLOAD_SPEED_COLUMN", I18n.tr("Down Speed"), 89, true, SpeedRenderer.class);
        columns.add(DOWNLOAD_SPEED_COLUMN);
        UPLOAD_SPEED_COLUMN = new LimeTableColumn(columns.size(), "UPLOAD_SPEED_COLUMN", I18n.tr("Up Speed"), 84, true, SpeedRenderer.class);
        columns.add(UPLOAD_SPEED_COLUMN);
        TIME_COLUMN = new LimeTableColumn(columns.size(), "DOWNLOAD_TIME_REMAINING_COLUMN", I18n.tr("Time"), 66, true, TimeRemainingHolder.class);
        columns.add(TIME_COLUMN);
        SEEDS_COLUMN = new LimeTableColumn(columns.size(), "SEEDS_STATUS_COLUMN", I18n.tr("Seeds"), 56, true, String.class);
        columns.add(SEEDS_COLUMN);
        PEERS_COLUMN = new LimeTableColumn(columns.size(), "PEERS_STATUS_COLUMN", I18n.tr("Peers"), 80, false, String.class);
        columns.add(PEERS_COLUMN);
        SHARE_RATIO_COLUMN = new LimeTableColumn(columns.size(), "SHARE_RATIO_COLUMN", I18n.tr("Share Ratio"), 80, false, String.class);
        columns.add(SHARE_RATIO_COLUMN);
        SEED_TO_PEER_RATIO_COLUMN = new LimeTableColumn(columns.size(), "SEED_TO_PEER_RATIO_COLUMN", I18n.tr("Seeds/Peers"), 80, false, String.class);
        columns.add(SEED_TO_PEER_RATIO_COLUMN);
        DATE_CREATED_COLUMN = new LimeTableColumn(columns.size(), "DATE_CREATED_COLUMN", I18n.tr("Started On"), 80, false, Date.class);
        columns.add(DATE_CREATED_COLUMN);
        LICENSE_COLUMN = new LimeTableColumn(columns.size(), "LICENSE_COLUMN", I18n.tr("License"), 80, false, String.class);
        columns.add(LICENSE_COLUMN);
        COLUMN_COUNT = columns.size();
        TRANSFER_STATE_STRING_MAP.put(TransferState.CHECKING, I18n.tr("Checking..."));
        TRANSFER_STATE_STRING_MAP.put(TransferState.DOWNLOADING_METADATA, I18n.tr("Downloading metadata"));
        TRANSFER_STATE_STRING_MAP.put(TransferState.DOWNLOADING_TORRENT, I18n.tr("Downloading torrent"));
        TRANSFER_STATE_STRING_MAP.put(TransferState.DOWNLOADING, I18n.tr("Downloading"));
        TRANSFER_STATE_STRING_MAP.put(TransferState.FINISHED, I18n.tr("Finished"));
        TRANSFER_STATE_STRING_MAP.put(TransferState.SEEDING, I18n.tr("Seeding"));
        TRANSFER_STATE_STRING_MAP.put(TransferState.PAUSED, I18n.tr("Paused"));
        TRANSFER_STATE_STRING_MAP.put(TransferState.ERROR, I18n.tr("Error"));
        TRANSFER_STATE_STRING_MAP.put(TransferState.ERROR_MOVING_INCOMPLETE, I18n.tr("Error: Moving incomplete"));
        TRANSFER_STATE_STRING_MAP.put(TransferState.ERROR_HASH_MD5, I18n.tr("Error: Wrong md5 hash"));
        TRANSFER_STATE_STRING_MAP.put(TransferState.ERROR_SIGNATURE, I18n.tr("Error: Wrong signature"));
        TRANSFER_STATE_STRING_MAP.put(TransferState.ERROR_NOT_ENOUGH_PEERS, I18n.tr("Try again, not enough peers"));
        TRANSFER_STATE_STRING_MAP.put(TransferState.STOPPED, I18n.tr("Stopped"));
        TRANSFER_STATE_STRING_MAP.put(TransferState.PAUSING, I18n.tr("Pausing"));
        TRANSFER_STATE_STRING_MAP.put(TransferState.CANCELING, I18n.tr("Canceling"));
        TRANSFER_STATE_STRING_MAP.put(TransferState.CANCELED, I18n.tr("Canceled"));
        TRANSFER_STATE_STRING_MAP.put(TransferState.WAITING, I18n.tr("Waiting"));
        TRANSFER_STATE_STRING_MAP.put(TransferState.COMPLETE, I18n.tr("Complete"));
        TRANSFER_STATE_STRING_MAP.put(TransferState.UPLOADING, I18n.tr("Uploading"));
        TRANSFER_STATE_STRING_MAP.put(TransferState.UNCOMPRESSING, I18n.tr("Uncompressing"));
        TRANSFER_STATE_STRING_MAP.put(TransferState.DEMUXING, I18n.tr("Demuxing"));
        TRANSFER_STATE_STRING_MAP.put(TransferState.ERROR_DISK_FULL, I18n.tr("Error: Disk full - Change default save location."));
        TRANSFER_STATE_STRING_MAP.put(TransferState.REDIRECTING, I18n.tr("Redirecting"));
    }
}

